/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.url.ApacheURLLister;

public class URLRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private Map resourcesCache = new HashMap();
    private ApacheURLLister lister = new ApacheURLLister();

    @Override
    public Resource getResource(String string) throws IOException {
        Resource resource = (Resource)this.resourcesCache.get(string);
        if (resource == null) {
            resource = new URLResource(new URL(string));
            this.resourcesCache.put(string, resource);
        }
        return resource;
    }

    @Override
    public void get(String string, File file) throws IOException {
        URLRepository uRLRepository = this;
        uRLRepository.fireTransferInitiated(uRLRepository.getResource(string), 5);
        try {
            Resource resource = this.getResource(string);
            long l = resource.getContentLength();
            if (l > 0L) {
                this.progress.setTotalLength(new Long(l));
            }
            FileUtil.copy(new URL(string), file, (CopyProgressListener)this.progress);
            return;
        }
        catch (IOException iOException) {
            this.fireTransferError(iOException);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.fireTransferError(runtimeException);
            throw runtimeException;
        }
        finally {
            this.progress.setTotalLength(null);
        }
    }

    @Override
    public List list(String object) throws IOException {
        if (((String)object).startsWith("http")) {
            List list = this.lister.listAll(new URL((String)object));
            if (list != null) {
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    URL uRL = (URL)listIterator.next();
                    arrayList.add(uRL.toExternalForm());
                }
                return arrayList;
            }
        } else if (((String)object).startsWith("file")) {
            String string;
            Comparable<URI> comparable;
            try {
                comparable = new URI((String)object);
                string = ((URI)comparable).isOpaque() ? ((URI)comparable).getSchemeSpecificPart() : ((URI)comparable).getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException("Couldn't list content of '" + (String)object + "'");
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
            comparable = new File(string);
            if (((File)comparable).exists() && ((File)comparable).isDirectory()) {
                String[] stringArray = ((File)comparable).list();
                ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                object = string.endsWith("/") ? new URL((String)object) : new URL((String)object + "/");
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(new URL((URL)object, stringArray[i]).toExternalForm());
                }
                return arrayList;
            }
            return Collections.EMPTY_LIST;
        }
        return null;
    }
}

