/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Checks;

public class ChainVersionMatcher
extends AbstractVersionMatcher {
    private List matchers = new LinkedList();

    public ChainVersionMatcher() {
        super("chain");
    }

    public void add(VersionMatcher versionMatcher) {
        Checks.checkNotNull(versionMatcher, "matcher");
        this.matchers.add(0, versionMatcher);
        if (this.getSettings() != null && versionMatcher instanceof IvySettingsAware) {
            ((IvySettingsAware)((Object)versionMatcher)).setSettings(this.getSettings());
        }
    }

    @Override
    public void setSettings(IvySettings ivySettings) {
        super.setSettings(ivySettings);
        for (VersionMatcher versionMatcher : this.matchers) {
            if (!(versionMatcher instanceof IvySettingsAware)) continue;
            ((IvySettingsAware)((Object)versionMatcher)).setSettings(ivySettings);
        }
    }

    @Override
    public boolean isDynamic(ModuleRevisionId moduleRevisionId) {
        Checks.checkNotNull(moduleRevisionId, "askedMrid");
        for (VersionMatcher versionMatcher : this.matchers) {
            if (!versionMatcher.isDynamic(moduleRevisionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2, Comparator comparator) {
        Checks.checkNotNull(moduleRevisionId, "askedMrid");
        Checks.checkNotNull(moduleRevisionId2, "foundMrid");
        Checks.checkNotNull(comparator, "staticComparator");
        for (VersionMatcher versionMatcher : this.matchers) {
            if (!versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.compare(moduleRevisionId, moduleRevisionId2, comparator);
        }
        throw new IllegalArgumentException("impossible to compare revisions: askedMrid is not dynamic: " + moduleRevisionId);
    }

    @Override
    public boolean accept(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        Checks.checkNotNull(moduleRevisionId, "askedMrid");
        Checks.checkNotNull(moduleRevisionId2, "foundMrid");
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator.next();
            if (iterator.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.accept(moduleRevisionId, moduleRevisionId2);
        }
        return false;
    }

    @Override
    public boolean needModuleDescriptor(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
        Checks.checkNotNull(moduleRevisionId, "askedMrid");
        Checks.checkNotNull(moduleRevisionId2, "foundMrid");
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator.next();
            if (iterator.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.needModuleDescriptor(moduleRevisionId, moduleRevisionId2);
        }
        return false;
    }

    @Override
    public boolean accept(ModuleRevisionId moduleRevisionId, ModuleDescriptor moduleDescriptor) {
        Checks.checkNotNull(moduleRevisionId, "askedMrid");
        Checks.checkNotNull(moduleDescriptor, "foundMD");
        Iterator iterator = this.matchers.iterator();
        while (iterator.hasNext()) {
            VersionMatcher versionMatcher = (VersionMatcher)iterator.next();
            if (iterator.hasNext() && !versionMatcher.isDynamic(moduleRevisionId)) continue;
            return versionMatcher.accept(moduleRevisionId, moduleDescriptor);
        }
        return false;
    }
}

