.TH "TXT2TAGS" 1 "2010年8月" ""


.SH 名称

.P
txt2tags \- 文本格式化及转换工具 

.SH 总览

.P
\fBtxt2tags\fR [\fI选项\fR] [\fI文件\fR...]

.SH 描述

.P
\fBtxt2tags\fR 读入含少量标记的文本，并将其转换为多种格式的文档：
\fIASCII Art\fR,
\fIAsciiDoc\fR,
\fICreole\fR,
\fIDocBook\fR,
\fIDokuWiki\fR,
\fIGoogle Code Wiki\fR,
\fIHTML\fR,
\fILaTeX\fR,
\fILout\fR,
\fIMagicPoint\fR,
\fIMan page\fR,
\fIMoinMoin\fR,
\fIPageMaker\fR,
\fIPlain Text\fR,
\fIPmWiki\fR,
\fISGML\fR,
\fIWikipedia\fR 和
\fIXHTML\fR.

.P
此手册页是由\fBtxt2tags\fR转换一个示例文本文件生成。并且该示例文本文件同时被转换成HTML，作为此手册页的在线版本。

.P
单个源文件，多种格式的目标文件 \- http://txt2tags.org

.SH 标记

.nf
头部                源文件的前3行
标题                = 文字 =
带数字编号的标题    + 文字 +
注释                % 注释内容
隔离行              -----------------------...
粗隔离行            =======================...
图片                [filename.jpg]
链接                [标签 url地址]

粗体                **文字**
斜体                //文字//
下划线              __文字__
删除线              --文字--
等宽                ``文字``
原始文本            ""文字""
标记文本            ''文字''

段落                文字
引用                <TAB>文字
列表                 - 文字
带编号的列表        + 文字
定义式列表          : 文字
表格                | 单元格1 | 单元格2 | 单元格3...

完全引用行          ``` 文字
原文引用行          """ 文字
标记引用行          ''' 文字

完全引用块          ```
                    多行文本
                    ```
原文引用块          """
                    多行文本
                    """
标记引用块          '''
                    多行文本
                    '''
.fi


.SH 选项

.TP
    \fB\-\-art\-chars\fR=\fIPATTERN\fR
定义\fIPATTERN\fR为组成ASCII艺术字的字符模板，按以下顺序指定：
拐角，边框，侧面，一级块，二级块，二级水平线，三级水平线，四级水平线，五级水平线。
默认的模板是 +\-|\-==\-^"。此选项只在输出目标格式为艺术ASCII时可用。

.TP
\fB\-C\fR, \fB\-\-config\-file\fR=\fIFILE\fR
从外部文件\fIFILE\fR中读入配置。配置项格式为\fI%!关键字:取值\fR，详情请见
配置 小节。

.TP
    \fB\-\-css\-sugar\fR
优化生成的嵌入CSS样式HTML/XHTML内容。移除标签属性，禁用样式属性，头部内容由H1、H2和H3组成，新建以下DIV：
\fI#header\fR, \fI#body\fR, \fI.toc\fR。

.TP
    \fB\-\-css\-inside\fR
在HTML/XHTML头部嵌入CSS文件的内容。使用\-\-style指定读入的CSS文件。

.TP
    \fB\-\-dump\-config\fR
输出所有配置项后退出。

.TP
    \fB\-\-dump\-source\fR
输出文档源文件，并展开 (%!include) 中的内容。

.TP
    \fB\-\-encoding\fR=\fICODE\fR
设置源文件转换成目标\fICODE\fR时采用的字符集。例如 UTF\-8 and iso\-8859\-1。

.TP
    \fB\-\-gui\fR
启动TK图形界面。

.TP
\fB\-h\fR, \fB\-\-help\fR
输出帮助信息后退出。

.TP
\fB\-H\fR, \fB\-\-no\-headers\fR
输出内容时不显示头部、尾部信息，只显示主体内容。

.TP
    \fB\-\-headers\fR
输出内容时显示头部、尾部信息。此选项默认打开。

.TP
    \fB\-\-height\fR=\fINUM\fR
设置输出内容为\fINUM\fR行。此选项只在目标文档格式为艺术ASCII、且指定\-\-slides时可用。

.TP
\fB\-i\fR, \fB\-\-infile\fR=\fIFILE\fR
指定\fIFILE\fR为输入的源文件名。如果指定为'\-'，则从STDIN读入源文本。

.TP
    \fB\-\-mask\-email\fR
隐藏邮件地址，以防止垃圾邮件地址收割。移除@和.。邮件地址
foo@bar.com 被转换为 <foo (a) bar com>。

.TP
\fB\-n\fR, \fB\-\-enum\-title\fR
对所有标题行进行自动编号。显示的前缀为 1, 1.1, 1.1.1, ... 

.TP
    \fB\-\-no\-dump\-config\fR
取消\-\-dump\-config动作。

.TP
    \fB\-\-no\-dump\-source\fR
取消\-\-dump\-source动作。

.TP
    \fB\-\-no\-encoding\fR
清除encoding设置。

.TP
    \fB\-\-no\-enum\-title\fR
关闭标题自动编号的设置。

.TP
    \fB\-\-no\-infile\fR
清除之前所有infile的声明。

.TP
    \fB\-\-no\-targets\fR
取消\-\-targets动作。

.TP
    \fB\-\-no\-mask\-email\fR
关闭隐藏邮件地址的特性。

.TP
    \fB\-\-no\-outfile\fR
清除之前所有outfile的声明。

.TP
    \fB\-\-no\-quiet\fR
输出消息，关闭\-\-quiet选项。

.TP
    \fB\-\-no\-rc\fR
不读入用户配置文件~/.txt2tagsrc。

.TP
    \fB\-\-no\-slides\fR
关闭演示文档特性。

.TP
    \fB\-\-no\-style\fR
清除所有样式设置。

.TP
    \fB\-\-no\-toc\fR
不输出目录。

.TP
    \fB\-\-no\-toc\-only\fR
关闭\-\-toc\-only动作。

.TP
\fB\-o\fR, \fB\-\-outfile\fR=\fIFILE\fR
指定输出的文件名为\fIFILE\fR。指定'\-'则将结果输出到STDOUT。

.TP
\fB\-q\fR, \fB\-\-quiet\fR
安静模式。关闭除了错误之外的所有其他消息输出。

.TP
    \fB\-\-rc\fR
读入用户配置文件~/.txt2tagsrc。此选项默认打开。

.TP
    \fB\-\-slides\fR
指定输出格式为演示文档，此选项只在输出目标格式为艺术ASCII时可用。

.TP
    \fB\-\-style\fR=\fIFILE\fR
指定\fIFILE\fR作为目标文档的样式文件。用于指定HTML/XHTML文档使用的CSS文件，LaTeX文档使用的样式包。此选项可以多次使用，以指定多个样式文件。

.TP
\fB\-t\fR, \fB\-\-target\fR=\fITYPE\fR
指定输出目标文档的类型为\fITYPE\fR。一些常用的类型为：\fIhtml\fR, \fIxhtml\fR, \fItex\fR, \fIman\fR, \fItxt\fR。使用\-\-targets选项查看所有支持的目标文档类型。

.TP
    \fB\-\-targets\fR
输出所有可用的目标文档类型后退出。

.TP
    \fB\-\-toc\fR
在输出内容中包含自动生成的目录信息，置于头部内容和主体内容之间。也可以
通过`%%TOC``宏显示指定目录输出位置。 

.TP
    \fB\-\-toc\-level\fR=\fINUM\fR
指定目录最大深度为\fINUM\fR。所有比\fINUM\fR深的标题不会在目录中显示。

.TP
    \fB\-\-toc\-only\fR
输出目录后退出。

.TP
\fB\-v\fR, \fB\-\-verbose\fR
在文档转换过程中输出详细的信息。此选项可以多次使用，以提高输出的消息量。

.TP
\fB\-V\fR, \fB\-\-version\fR
输出程序版本后退出。

.TP
    \fB\-\-width\fR=\fINUM\fR
设置输出的宽度为\fINUM\fR，此选项只在输出目标格式为艺术ASCII时可用。

.SH 源文件

.P
源文件扩展名一般为\fI.t2t\fR (例如 myfile.t2t)。可以在以下三个区域指定源文件：

.TP
\fB头部\fR (可选)
源文件的前三行。如果不需要头部信息，则源文件首行留空。
用于指定文档标题、作者、版本和日期信息。

.TP
\fB配置\fR (可选)
紧接在头部信息之后（第4行或第2行），在主体内容之前结束。
用于指定各种配置项，格式为%!关键字:取值。

.TP
\fB主体\fR
从头部区域之后的第一个有效文本行开始（非注释或配置），直至源文件结束。
用于指定文档内容。

.SH 配置

.P
配置用于定制\fBtxt2tags\fR，与选项类似。配置项可以在源文件的配置区域，~/.txt2tagsrc文件，\-\-config\-file指定的外部文件中指定。

.TP
\fB%!target\fR
配置输出目标文档类型，功能与\-\-target相同。举例：
.nf
%!target: html
.fi



.TP
\fB%!options(target)\fR
设置该目标类型（target）文档的默认选项。必须以命令行的形式调用。举例：
.nf
%!options(html): --toc --toc-level 3 --css-sugar
.fi



.TP
\fB%!includeconf\fR
指定读入外部文件中包含的配置项，功能与\-\-config\-file相同。举例：
.nf
%!includeconf: myconfig.t2t
.fi



.TP
\fB%!style\fR
为目标文档指定样式文件，功能与\-\-style相同。可以多次使用。举例：
.nf
%!style: colors.css
.fi



.TP
\fB%!encoding\fR
指定目标文档使用的字符集，功能与\-\-encoding相同。举例：
.nf
%!encoding: UTF-8
.fi



.TP
\fB%!preproc\fR
指定查找/替换的过滤器，在txt2tags解析源文档之前，改变源文档的内容。格式采用Python正则表达式。举例：
.nf
%!preproc:  "JJS"  "John J. Smith"
.fi



.TP
\fB%!postproc\fR
指定查找/替换的过滤器，在txt2tags转换源文档之后，改变目标文档的内容。格式采用Python正则表达式。举例：
.nf
%!postproc(html):  "<B>"  "<STRONG>"
.fi



.P
如果同一个关键字多次出现，则以最后的取值为准（options, preproc and postproc是累计的除外）。异常关键字被忽略。解析顺序为：~/.txt2tagsrc，源文档的配置区域，\-\-config\-file命令行选项。

.SH 指令

.P
指令在文本转换过程中生效。指令必须在源文件主体内容中指定。

.TP
\fB%!csv: file.csv\fR
读入一个外部的CSV文件，作为表格。

.TP
\fB%!include: file.t2t\fR
读入一个txt2tags文件。

.TP
\fB%!include: ``file.txt``\fR
读入一个文本文件的内容，作为源文件的“原文引用块”。

.TP
\fB%!include: \&''file.html''\fR
读入一个标签文件内容到目标文档。

.SH 宏

.P
使用宏很容易在文档中插入动态内容。宏必须在源文件的主体内容中指定。
除了%%toc，所有宏都能够用修饰符指定格式，例如%Y和%f。详情请查看txt2tags用户指南。

.TP
\fB%%date\fR
插入当前日期。默认格式是%%date(%Y%m%d)，输出YYYYMMDD。

.TP
\fB%%infile\fR
插入源文件所在路径。默认格式是%%infile(%f)。常用尾部链接举例：[查看源文件 %%infile]。

.TP
\fB%%mtime\fR
插入源文件修改时间。默认格式是%%date(%Y%m%d)，输出YYYYMMDD。

.TP
\fB%%outfile\fR
输出目标文档所在路径。默认格式是%%outfile(%f)。常用的自引用形式举例："这是 manpage\-zh.man 文件"。

.TP
\fB%%toc\fR
指定目录信息所在位置。可以多次使用。注意同时指定\-\-toc选项。

.SH 示例

.TP
txt2tags \-t html file.t2t

转换成HTML，将转换的结果输出到文件file.html。

.TP
txt2tags \-t html \-o \- file.t2t

转换成HTML，将转换的结果输出到STDOUT。

.TP
txt2tags \-t html \-\-toc file.t2t

转换成HTML，包含自动生成的目录。

.TP
txt2tags \-t html \-\-toc \-\-toc\-level 2 \-n file.t2t

转换成HTML，并生成目录，目录深度为2，各项标题采用数字编号。

.TP
txt2tags \-\-toc\-only file.t2t

只输出目录，不进行实际的转换。

.TP
txt2tags \-t html \-\-css\-sugar \-\-style base.css \-\-style ui.css file.t2t

转换成HTML，并预先设置采用CSS，同时指定引用两个外部CSS文件。

.TP
txt2tags \-t art \-\-slides \-\-width 80 \-\-height 25 \-o \- file.t2t | more

生成艺术ASCII演示文档，用于在80x25的屏幕或窗口上演示。

.TP
(echo ; echo "**bold**") | txt2tags \-t html \-H \-

易用的单行指令，从STDIN读取内容做快速的测试。

.TP
txt2tags \-t html \-o \- file.t2t | tidy > file.html

将转换的结果输出到STDOUT，然后调用外部程序优化结果代码，最终保存到文件。

.SH 文件

.TP
~/.txt2tagsrc
用户默认配置文件。

.SH 环境

.TP
T2TCONFIG
该值设置用户默认配置文件的绝对路径。

.SH 作者

.P
原文由Aurelio Jargas <verde@aurelio.net>编写。

.P
中文版由Abby Pan <abbypan@gmail.com>翻译。

.SH 缺陷

.P
http://bugs.txt2tags.org

.SH 版权

.P
Copyright (C) 2001\-2010 Aurelio Jargas, GNU GPL v2

.\" man code generated by txt2tags 2.6 (http://txt2tags.org)
.\" cmdline: txt2tags -t man doc/Chinese/manpage-zh.t2t
