.TH "TXT2TAGS" 1 "Ago, 2010" ""


.SH NOME

.P
txt2tags \- ferramenta para formatar e converter textos

.SH SINOPSE

.P
\fBtxt2tags\fR [\fIopções\fR] [\fIARQUIVO\fR...]

.SH DESCRIÇÃO

.P
O \fBtxt2tags\fR lê um arquivo texto com poucas marcações e o converte para:
\fIASCII Art\fR,
\fIAsciiDoc\fR,
\fICreole\fR,
\fIDocBook\fR,
\fIDokuWiki\fR,
\fIGoogle Code Wiki\fR,
\fIHTML\fR,
\fILaTeX\fR,
\fILout\fR,
\fIMagicPoint\fR,
\fIMan page\fR,
\fIMoinMoin\fR,
\fIPageMaker\fR,
\fIPlain Text\fR,
\fIPmWiki\fR,
\fISGML\fR,
\fIWikipedia\fR e
\fIXHTML\fR.

.P
Esta página de manual foi criada pelo \fBtxt2tags\fR a partir de um arquivo de texto. Este mesmo arquivo de texto também é convertido para HTML e colocado no site do programa para consulta.

.P
UM arquivo fonte, VÁRIOS destinos \- http://txt2tags.org

.SH SINTAXE

.nf
Cabeçalhos          As 3 primeiras linhas do arquivo fonte
Título              = palavras =
Título numerado     + palavras +
Comentário          % comentários
Linha de separação  -----------------------...
Linha destacada     =======================...
Imagem              [arquivo.jpg]
Link                [nome url]

Negrito             **palavras**
Itálico             //palavras//
Sublinhado          __palavras__
Riscado             --palavras--
Monoespaçado        ``palavras``
Texto protegido     ""palavras""
Texto com tags      ''palavras''

Parágrafo           palavras
Citação             <TAB>palavras
Lista               - palavras
Lista numerada      + palavras
Lista de definição  : palavras
Tabela              | cel1 | cel2 | cel3...

Linha formatada     ``` palavras
Linha protegida     """ palavras
Linha com tags      ''' palavras

Área formatada      ```
                    linhas
                    ```
Área protegida      """
                    linhas
                    """
Área com tags       '''
                    linhas
                    '''
.fi


.SH OPÇÕES

.TP
    \fB\-\-art\-chars\fR=\fISTRING\fR
Define \fISTRING\fR como a lista de caracteres usados para fazer os enfeites do ASCII Art, nesta ordem: canto, borda, lado, linha1, linha2, nível2, nível3, nível4, nível5. O valor padrão da string é +\-|\-==\-^". Esta opção é utilizada somente pelo formato ASCII Art.

.TP
\fB\-C\fR, \fB\-\-config\-file\fR=\fIARQUIVO\fR
Lê a configuração a partir do arquivo externo \fIARQUIVO\fR. A configuração deve estar no formato \fI%!nome:valor\fR. Veja o tópico CONFIGURAÇÕES para mais detalhes.

.TP
    \fB\-\-css\-sugar\fR
Prepara o código HTML/XHTML para ser usado com arquivos CSS. Os atributos das tags são removidos, tags de formatação são evitadas, o cabeçalho é composto pelas tags H1, H2 e H3, novos DIVs são criados: \fI#header\fR, \fI#body\fR, \fI.toc\fR.

.TP
    \fB\-\-css\-inside\fR
Insere o conteúdo do arquivo CSS no cabeçalho do documento HTML/XHTML. Use \-\-style para indicar o arquivo CSS a ser lido.

.TP
    \fB\-\-dump\-config\fR
Exibe todas as configurações encontradas e sai.

.TP
    \fB\-\-dump\-source\fR
Exibe os fontes do documento, com os arquivos incluídos (%!include) expandidos.

.TP
    \fB\-\-encoding\fR=\fICÓDIGO\fR
Define a codificação do arquivo para \fICÓDIGO\fR. Alguns exemplos são UTF\-8 e iso\-8859\-1.

.TP
    \fB\-\-gui\fR
Carrega a interface gráfica (Tk).

.TP
\fB\-h\fR, \fB\-\-help\fR
Exibe o texto de ajuda e sai.

.TP
\fB\-H\fR, \fB\-\-no\-headers\fR
Suprime os cabeçalhos e o rodapé do documento. Apenas o Corpo do documento será mostrado.

.TP
    \fB\-\-headers\fR
Exibe os cabeçalhos e o rodapé no documento. Esta opção é usada por padrão.

.TP
    \fB\-\-height\fR=\fIN\fR
Define a altura da saída para \fIN\fR linhas. Esta opção é utilizada somente pelo formato ASCII Art, quando também utilizada a opção \-\-slides.

.TP
\fB\-i\fR, \fB\-\-infile\fR=\fIARQUIVO\fR
Define \fIARQUIVO\fR como arquivo fonte. Use '\-' para ler os dados de STDIN.

.TP
    \fB\-\-mask\-email\fR
Esconde os e\-mails dos robôs de SPAM. Os pontos e o @ são removidos. O endereço foo@bar.com vira <foo (a) bar com>.

.TP
\fB\-n\fR, \fB\-\-enum\-title\fR
Enumera todos os títulos automaticamente, nos formatos 1, 1.1, 1.1.1, ...

.TP
    \fB\-\-no\-dump\-config\fR
Cancela a ação \-\-dump\-config.

.TP
    \fB\-\-no\-dump\-source\fR
Cancela a ação \-\-dump\-source.

.TP
    \fB\-\-no\-encoding\fR
Remove a configuração de codificação.

.TP
    \fB\-\-no\-enum\-title\fR
Desativa a numeração automática de títulos.

.TP
    \fB\-\-no\-infile\fR
Remove as definições anteriores do arquivo fonte.

.TP
    \fB\-\-no\-targets\fR
Cancela a ação \-\-targets.

.TP
    \fB\-\-no\-mask\-email\fR
Desativa o disfarce de emails.

.TP
    \fB\-\-no\-outfile\fR
Remove as definições anteriores sobre o arquivo de destino.

.TP
    \fB\-\-no\-quiet\fR
Mostras as mensagens, desativando a opção \-\-quiet.

.TP
    \fB\-\-no\-rc\fR
Não lê o arquivo configuração do usuário em ~/.txt2tagsrc.

.TP
    \fB\-\-no\-slides\fR
Desliga os slides.

.TP
    \fB\-\-no\-style\fR
Remove todas as configurações de estilo.

.TP
    \fB\-\-no\-toc\fR
Remove o Sumário automático.

.TP
    \fB\-\-no\-toc\-only\fR
Desativa a opção \-\-toc\-only.

.TP
\fB\-o\fR, \fB\-\-outfile\fR=\fIARQUIVO\fR
Define \fIARQUIVO\fR como arquivo de destino. Use '\-' para mandar o resultado para STDOUT.

.TP
\fB\-q\fR, \fB\-\-quiet\fR
Modo silencioso, não mostra nada na saída, exceto os erros.

.TP
    \fB\-\-rc\fR
Lê a configuração do usuário em ~/.txt2tagsrc. Esta opção é usada por padrão.

.TP
    \fB\-\-slides\fR
Formata a saída como uma apresentação de slides. Esta opção é utilizada somente pelo formato ASCII Art.

.TP
    \fB\-\-style\fR=\fIARQUIVO\fR
Utiliza \fIARQUIVO\fR como estilo do documento. É usado para incluir arquivos CSS em documentos HTML, e pacotes para o LaTeX. Esta opção pode ser usada mais de uma vez caso você precise incluir dois ou mais arquivos.

.TP
\fB\-t\fR, \fB\-\-target\fR=\fIFORMATO\fR
Define o formato do documento de destino. Alguns formatos populares são: \fIhtml\fR, \fIxhtml\fR, \fItex\fR, \fIman\fR, \fItxt\fR. Use a opção \-\-targets para ver a lista completa com todos os formatos disponíveis.

.TP
    \fB\-\-targets\fR
Mostra a lista completa de todos os formatos disponíveis e sai.

.TP
    \fB\-\-toc\fR
Inclui um Sumário automático (Table of Contents) no documento de destino, entre o cabeçalho e o corpo. Você também pode indicar onde o Sumário deve ser colocado, usando a macro %%TOC.

.TP
    \fB\-\-toc\-level\fR=\fIN\fR
Define o nível máximo (profundidade) do Sumário para \fIN\fR. Os títulos abaixo do nível \fIN\fR não serão incluídos no Sumário.

.TP
    \fB\-\-toc\-only\fR
Exibe o Sumário do documento e sai.

.TP
\fB\-v\fR, \fB\-\-verbose\fR
Exibe mensagens informativas durante a conversão. Utilize\-a duas ou mais vezes na linha de comando para aumentar o número de mensagens a serem mostradas.

.TP
\fB\-V\fR, \fB\-\-version\fR
Exibe a versão do programa e sai.

.TP
    \fB\-\-width\fR=\fIN\fR
Define a largura da saída para \fIN\fR colunas. Esta opção é utilizada somente pelo formato ASCII Art.

.SH ARQUIVO FONTE

.P
Um arquivo fonte do \fBtxt2tags\fR geralmente usa a extensão \fI.t2t\fR, como por exemplo: trabalho.t2t. Você pode ter três áreas distintas em seus fontes:

.TP
\fBCabeçalho\fR
As primeiras três linhas. São usadas para identificação do documento, como título, autor, versão e data. Se você não quiser usar cabeçalhos, deixe a primeira linha em branco.

.TP
\fBConfiguração\fR
Inicia logo após o cabeçalho (4ª ou 2ª linha) e termina quando o Corpo se inicia. Esta área é usada para configurações no formato %!nome:valor.

.TP
\fBCorpo\fR
Começa na primeira linha de texto (que não seja um comentário ou uma configuração) logo após o cabeçalho e vai até o fim do documento. É usada para guardar o conteúdo do documento.

.SH CONFIGURAÇÕES

.P
Você pode personalizar o txt2tags usando configurações. Elas são parecidas com as opções de linha de comando e podem ser usadas nos seguintes locais: na área Configuração do seu arquivo fonte, no arquivo ~/.txt2tagsrc ou ainda em um arquivo externo chamado com a opção \-\-config\-file.

.TP
\fB%!target\fR
Define o formato de saída, igual faz a opção \-\-target. Exemplo:
.nf
%!target: html
.fi



.TP
\fB%!options(target)\fR
Define as opções de cada formato. No valor você deve colocar as opções de linha de comando. Exemplo:
.nf
%!options(html): --toc --toc-level 3 --css-sugar
.fi



.TP
\fB%!includeconf\fR
Lê as configurações a partir de um arquivo externo, igual faz a opção \-\-config\-file. Exemplo:
.nf
%!includeconf: minhaconfig.t2t
.fi



.TP
\fB%!style\fR
Define um arquivo de estilos para o documento, igual faz a opção \-\-style. Pode ser usada várias vezes para definir mais de um arquivo. Exemplo:
.nf
%!style: cores.css
.fi



.TP
\fB%!encoding\fR
Define a codificação do texto, igual faz a opção \-\-encoding. Exemplo:
.nf
%!encoding: UTF-8
.fi



.TP
\fB%!preproc\fR
Filtro de entrada (estilo troque "isso" por "aquilo") usado para alterar o Corpo do documento ANTES do txt2tags processá\-lo. Você pode usar as expressões regulares do Python. Exemplo:
.nf
%!preproc:  "FSS"  "Fulano da Silva Sauro"
.fi



.TP
\fB%!postproc\fR
Filtro de saída (estilo troque "isso" por "aquilo") usado para alterar o documento de saída DEPOIS da conversão feita pelo txt2tags. Você pode usar as expressões regulares do Python. Exemplo:
.nf
%!postproc(html):  "<B>"  "<STRONG>"
.fi



.P
Se a mesma configuração for usada mais de uma vez, somente a última será utilizada. As exceções são: options, preproc e postproc, que são cumulativas. Configurações com nomes inválidos serão ignoradas. A ordem de processamento é: ~/.txt2tagsrc, área Configuração do arquivo fonte, opção \-\-config\-file.

.SH COMANDOS

.P
Os comandos são executados durante a conversão do documento. Eles devem ser colocados dentro do Corpo do arquivo fonte.

.TP
\fB%!csv: arquivo.csv\fR
Gera uma tabela a partir de um arquivo externo CSV.

.TP
\fB%!include: arquivo.t2t\fR
Inclui um arquivo fonte txt2tags no documento.

.TP
\fB%!include: ``arquivo.txt``\fR
Inclui um arquivo texto no documento.

.TP
\fB%!include: \&''arquivo.html''\fR
Inclui um arquivo pronto no documento, ele não é modificado.

.SH MACROS

.P
As macros são úteis para inserir conteúdos dinâmicos em seu documento, como a data atual, por exemplo. Exceto a %%toc, todas as macros podem ser personalizadas com curingas tipo %Y e %f. Veja o Guia do Usuário para saber mais detalhes.

.TP
\fB%%date\fR
Insere a data atual. O formato padrão é %%date(%Y%m%d), que fica AAAAMMDD.

.TP
\fB%%infile\fR
Insere o nome do arquivo fonte. O formato padrão é %%infile(%f). Útil para links de rodapé, como [Veja os fontes %%infile].

.TP
\fB%%mtime\fR
Insere a data de modificação do arquivo fonte. O formato padrão é %%date(%Y%m%d), que fica AAAAMMDD.

.TP
\fB%%outfile\fR
Insere o nome do arquivo de saída. O formato padrão é %%outfile(%f). Útil para mencionar o próprio documento, como em "Este é o arquivo manpage\-pt.man".

.TP
\fB%%toc\fR
Especifica o lugar onde será colocado o Sumário (Table Of Contents). Você pode utilizá\-la em qualquer parte do documento, inclusive mais de uma vez. A opção \-\-toc também deve ser usada para esta que esta macro funcione.

.SH EXEMPLOS

.TP
txt2tags \-t html arquivo.t2t

Converte para HTML, gravando o resultado em arquivo.html.

.TP
txt2tags \-t html \-o \- arquivo.t2t

Converte para HTML, mandando o resultado para STDOUT.

.TP
txt2tags \-t html \-\-toc arquivo.t2t

Converte para HTML, com Sumário automático (Table Of Contents).

.TP
txt2tags \-t html \-\-toc \-\-toc\-level 2 \-n arquivo.t2t

Converte para HTML, com Sumário de dois níveis e títulos numerados.

.TP
txt2tags \-\-toc\-only arquivo.t2t

Apenas mostra o Sumário, nenhuma conversão é feita.

.TP
txt2tags \-t html \-\-css\-sugar \-\-style base.css \-\-style ui.css arquivo.t2t

Converte para HTML, com código preparado para usar CSS e também inclui dois arquivos CSS externos.

.TP
txt2tags \-t art \-\-slides \-\-width 80 \-\-height 25 \-o \- arquivo.t2t | more

Cria uma apresentação de slides em ASCII Art, pronta para ser mostrada em um terminal de tamanho 80x25 (colunas e linhas).

.TP
(echo ; echo "**bold**") | txt2tags \-t html \-H \-

Mostra como testar o programa rapidamente usando a STDIN como fonte.

.TP
txt2tags \-t html \-o \- arquivo.t2t | tidy > arquivo.html

Manda os resultados para STDOUT e refina o código gerado usando um programa externo (tidy) antes de salvar o arquivo HTML final.

.SH ARQUIVOS

.TP
~/.txt2tagsrc
A localização padrão para o arquivo com as configurações do usuário.

.SH AMBIENTE

.TP
T2TCONFIG
Se definida, esta variável guarda o caminho completo para o arquivo de configuração do usuário.

.SH AUTOR

.P
Aurélio Marinho Jargas <verde@aurelio.net>

.P
Já trabalharam neste manual José Inácio Coelho <jic@technologist.com> e Mauricio Teixeira <mteixeira@webset.net>.

.SH BUGS

.P
http://bugs.txt2tags.org

.SH COPYRIGHT

.P
Copyright (C) 2001\-2010 Aurelio Jargas, GNU GPL v2

.\" man code generated by txt2tags 2.6 (http://txt2tags.org)
.\" cmdline: txt2tags -t man doc/Portuguese/manpage-pt.t2t
