/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Force;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationSummary;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.NativeTradeItem;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.GameEndedMessage;
import net.sf.freecol.common.networking.GameStateMessage;
import net.sf.freecol.common.networking.HighScoresMessage;
import net.sf.freecol.common.networking.InciteMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.NationSummaryMessage;
import net.sf.freecol.common.networking.NativeTradeMessage;
import net.sf.freecol.common.networking.NewTradeRouteMessage;
import net.sf.freecol.common.networking.RearrangeColonyMessage;
import net.sf.freecol.common.networking.ScoutSpeakToChiefMessage;
import net.sf.freecol.common.networking.SetCurrentPlayerMessage;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.REFAIPlayer;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.model.DiplomacySession;
import net.sf.freecol.server.model.LootSession;
import net.sf.freecol.server.model.MonarchSession;
import net.sf.freecol.server.model.NativeDemandSession;
import net.sf.freecol.server.model.NativeTradeSession;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.Session;

public final class InGameController
extends Controller {
    private static final Logger logger = Logger.getLogger(InGameController.class.getName());
    private static final Predicate<Player> coronadoPred = p -> p.hasAbility("model.ability.seeAllColonies");
    private Random random = null;
    private int debugOnlyAITurns = 0;
    private Monarch.MonarchAction debugMonarchAction = null;
    private ServerPlayer debugMonarchPlayer = null;

    public InGameController(FreeColServer freeColServer) {
        super(freeColServer);
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    private long getTimeout() {
        boolean single = this.getFreeColServer().getSinglePlayer();
        return FreeCol.getTimeout(single);
    }

    public int getSkippedTurns() {
        return FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) ? this.debugOnlyAITurns : -1;
    }

    public void setSkippedTurns(int turns) {
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            this.debugOnlyAITurns = turns;
        }
    }

    public void setMonarchAction(ServerPlayer serverPlayer, Monarch.MonarchAction action) {
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            this.debugMonarchPlayer = serverPlayer;
            this.debugMonarchAction = action;
        }
    }

    public int stepRandom() {
        return RandomUtils.randomInt(logger, "step random", this.random, 100);
    }

    public void addFoundingFather(Player player, FoundingFather father) {
        ChangeSet cs = new ChangeSet();
        ((ServerPlayer)player).csAddFoundingFather(father, this.random, cs);
        cs.addAttribute(ChangeSet.See.only(player), "flush", Boolean.TRUE.toString());
        this.getGame().sendTo(player, cs);
    }

    public void changeStance(Player player, Stance stance, Player other, boolean symmetric) {
        ChangeSet cs = new ChangeSet();
        if (((ServerPlayer)player).csChangeStance(stance, other, symmetric, cs)) {
            this.getGame().sendToAll(cs);
        }
    }

    public void debugChangeOwner(ServerColony colony, ServerPlayer serverPlayer) {
        ChangeSet cs = new ChangeSet();
        Player owner = colony.getOwner();
        colony.csChangeOwner(serverPlayer, false, null, cs);
        serverPlayer.invalidateCanSeeTiles();
        owner.invalidateCanSeeTiles();
        this.getGame().sendToAll(cs);
    }

    public void debugChangeOwner(ServerUnit unit, ServerPlayer serverPlayer) {
        Player owner = unit.getOwner();
        ChangeSet cs = new ChangeSet();
        ((ServerPlayer)owner).csChangeOwner(unit, serverPlayer, null, null, cs);
        cs.add(ChangeSet.See.perhaps().always(owner), unit.getTile());
        serverPlayer.invalidateCanSeeTiles();
        owner.invalidateCanSeeTiles();
        this.getGame().sendToAll(cs);
    }

    public int debugApplyDisaster(ServerColony colony, Disaster disaster) {
        ChangeSet cs;
        ServerGame game = this.getGame();
        Player owner = colony.getOwner();
        List<ModelMessage> messages = ((ServerPlayer)owner).csApplyDisaster(this.random, colony, disaster, cs = new ChangeSet());
        if (!messages.isEmpty()) {
            cs.addGlobalMessage(game, null, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.DISASTERS, "model.disaster.strikes", owner).addName("%colony%", colony.getName())).addName("%disaster%", disaster));
            for (ModelMessage message : messages) {
                cs.addGlobalMessage(game, null, message);
            }
            game.sendToAll(cs);
        }
        return messages.size();
    }

    public ServerPlayer createREFPlayer(ServerPlayer serverPlayer) {
        List<Unit> navalUnits;
        List<Unit> landUnits;
        List<Unit> leftOver;
        Nation refNation = serverPlayer.getNation().getREFNation();
        Monarch monarch = serverPlayer.getMonarch();
        ServerPlayer refPlayer = this.getFreeColServer().makeAIPlayer(refNation);
        Europe europe = refPlayer.getEurope();
        Predicate<Tile> exploredPred = t -> (!t.isLand() || t.isCoastland() || t.getOwner() == serverPlayer) && t.isExploredBy(serverPlayer);
        HashSet explore = new HashSet();
        this.getGame().getMap().forEachTile(exploredPred, t -> explore.add(t));
        refPlayer.exploreTiles(explore);
        refPlayer.setEntryTile(null);
        Player.makeContact(serverPlayer, refPlayer);
        Force exf = monarch.getExpeditionaryForce();
        if (exf.prepareToBoard(monarch.getNavalREFUnitType()) < 0) {
            logger.warning("Unable to ensure space for the REF land units.");
        }
        if (!(leftOver = refPlayer.loadShips(landUnits = refPlayer.createUnits(exf.getLandUnitsList(), europe, null), navalUnits = refPlayer.createUnits(exf.getNavalUnitsList(), europe, this.random), this.random)).isEmpty()) {
            logger.warning("Failed to board REF units: " + StringUtils.join(" ", CollectionUtils.transform(leftOver, CollectionUtils.alwaysTrue(), FreeColObject::getId)));
        }
        return refPlayer;
    }

    private void csBuy(ServerUnit unit, Goods goods, int price, ServerIndianSettlement sis, ChangeSet cs) {
        Specification spec = this.getGame().getSpecification();
        int alarmBonus = -Math.round((float)price * 0.001f * (float)spec.getPercentage("model.option.alarmBonusBuy"));
        Player owner = unit.getOwner();
        unit.csVisit((ServerPlayer)owner, sis, 0, cs);
        GoodsLocation.moveGoods(sis, goods.getType(), goods.getAmount(), unit);
        cs.add(ChangeSet.See.perhaps(), unit);
        sis.getOwner().modifyGold(price);
        owner.modifyGold(-price);
        sis.csModifyAlarm(owner, alarmBonus, true, cs);
        sis.updateWantedGoods();
        Tile tile = sis.getTile();
        tile.updateIndianSettlement(owner);
        cs.add(ChangeSet.See.only(owner), tile);
        cs.addPartial(ChangeSet.See.only(owner), owner, "gold", String.valueOf(owner.getGold()));
        logger.finest(owner.getSuffix() + " " + unit + " buys " + goods + " at " + sis.getName() + " for " + price);
    }

    private void csSell(ServerUnit unit, Goods goods, int price, ServerIndianSettlement sis, ChangeSet cs) {
        Specification spec = this.getGame().getSpecification();
        Player owner = unit.getOwner();
        int alarmBonus = -Math.round((float)price * 0.001f * (float)spec.getPercentage("model.option.alarmBonusSell"));
        unit.csVisit((ServerPlayer)owner, sis, 0, cs);
        GoodsLocation.moveGoods(unit, goods.getType(), goods.getAmount(), sis);
        cs.add(ChangeSet.See.perhaps(), unit);
        sis.getOwner().modifyGold(-price);
        owner.modifyGold(price);
        sis.csModifyAlarm(owner, alarmBonus, true, cs);
        sis.updateWantedGoods();
        Tile tile = sis.getTile();
        tile.updateIndianSettlement(owner);
        cs.add(ChangeSet.See.only(owner), tile);
        cs.addPartial(ChangeSet.See.only(owner), owner, "gold", String.valueOf(owner.getGold()));
        cs.addSale(owner, sis, goods.getType(), Math.round((float)price / (float)goods.getAmount()));
        logger.finest(owner.getSuffix() + " " + unit + " sells " + goods + " at " + sis.getName() + " for " + price);
    }

    private void csGift(ServerUnit unit, Goods goods, int price, ServerIndianSettlement sis, ChangeSet cs) {
        Specification spec = this.getGame().getSpecification();
        Player owner = unit.getOwner();
        int alarmBonus = -Math.round((float)price * 0.001f * (float)spec.getPercentage("model.option.alarmBonusGift"));
        unit.csVisit((ServerPlayer)owner, sis, 0, cs);
        GoodsLocation.moveGoods(unit, goods.getType(), goods.getAmount(), sis);
        cs.add(ChangeSet.See.perhaps(), unit);
        sis.csModifyAlarm(owner, alarmBonus, true, cs);
        sis.updateWantedGoods();
        Tile tile = sis.getTile();
        tile.updateIndianSettlement(owner);
        cs.add(ChangeSet.See.only(owner), tile);
        logger.finest(owner.getSuffix() + " " + unit + " gives " + goods + " at " + sis.getName() + " worth " + price);
    }

    private void csLaunchREF(ServerPlayer serverPlayer, boolean teleport, ChangeSet cs) {
        Player rebel = CollectionUtils.first(serverPlayer.getRebels());
        if (rebel != null) {
            serverPlayer.setEntryTile(rebel.getEntryTile());
        }
        if (teleport) {
            List<Unit> naval = CollectionUtils.transform(serverPlayer.getUnits(), Unit::isNaval);
            HashSet<Tile> seen = new HashSet<Tile>(naval.size());
            for (Unit u : naval) {
                Tile entry = u.getFullEntryLocation();
                u.setLocation(entry);
                u.setWorkLeft(-1);
                u.setState(Unit.UnitState.ACTIVE);
                if (!seen.add(entry)) continue;
                cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.exploreForUnit(u));
                cs.add(ChangeSet.See.perhaps().except(serverPlayer), entry);
            }
            serverPlayer.invalidateCanSeeTiles();
        } else {
            for (Unit u : CollectionUtils.transform(serverPlayer.getUnits(), Unit::isNaval)) {
                u.setWorkLeft(1);
                u.setDestination(u.getFullEntryLocation());
                u.setLocation(u.getOwner().getHighSeas());
            }
        }
    }

    private void csGiveIndependence(ServerPlayer serverPlayer, Player independent, ChangeSet cs) {
        serverPlayer.csChangeStance(Stance.PEACE, independent, true, cs);
        independent.changePlayerType(Player.PlayerType.INDEPENDENT);
        ServerGame game = this.getGame();
        Turn turn = game.getTurn();
        independent.setTax(0);
        independent.reinitialiseMarket();
        HistoryEvent h = new HistoryEvent(turn, HistoryEvent.HistoryEventType.INDEPENDENCE, independent);
        int n = CollectionUtils.count(game.getLiveEuropeanPlayers(independent), p -> p.getPlayerType() == Player.PlayerType.INDEPENDENT);
        h.setScore(n);
        cs.addGlobalHistory(game, h);
        cs.addMessage(independent, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "giveIndependence.announce", independent).addStringTemplate("%ref%", serverPlayer.getNationLabel()));
        Predicate<Unit> surrenderPred = u -> u.hasTile() && !u.isNaval() && !u.isOnCarrier() && (!u.hasAbility("model.ability.refUnit") || u.hasAbility("model.ability.canBeSurrendered")) && serverPlayer.csChangeOwner((Unit)u, independent, "model.unitChange.capture", null, cs);
        List<Unit> surrenderUnits = CollectionUtils.transform(serverPlayer.getUnits(), surrenderPred);
        for (Unit u2 : surrenderUnits) {
            u2.setMovesLeft(0);
            u2.setState(Unit.UnitState.ACTIVE);
            cs.add(ChangeSet.See.perhaps().always(serverPlayer), u2.getTile());
        }
        if (!surrenderUnits.isEmpty()) {
            cs.addMessage(independent, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "giveIndependence.unitsAcquired", independent).addStringTemplate("%units%", this.unitTemplate(", ", surrenderUnits)));
            independent.invalidateCanSeeTiles();
            serverPlayer.invalidateCanSeeTiles();
        }
        cs.addPartial(ChangeSet.See.all().except(independent), independent, "playerType", String.valueOf((Object)independent.getPlayerType()));
        cs.addGlobalMessage(game, independent, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "giveIndependence.otherAnnounce", independent).addStringTemplate("%nation%", independent.getNationLabel())).addStringTemplate("%ref%", serverPlayer.getNationLabel()));
        cs.add(ChangeSet.See.only(independent), independent);
        cs.add(ChangeSet.See.only(independent), ((ServerPlayer)independent).exploreMap(true));
    }

    private StringTemplate unitTemplate(String base, List<Unit> units) {
        StringTemplate template = StringTemplate.label(base);
        for (Unit u : units) {
            template.addStringTemplate(u.getLabel(Unit.UnitLabelType.PLAIN));
        }
        return template;
    }

    private void csMonarchAction(ServerPlayer serverPlayer, Monarch.MonarchAction action, ChangeSet cs) {
        Monarch monarch = serverPlayer.getMonarch();
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        boolean valid = monarch.actionIsValid(action);
        if (!valid) {
            return;
        }
        String messageId = action.getTextKey();
        String monarchKey = serverPlayer.getNationId();
        switch (action) {
            case NO_ACTION: {
                break;
            }
            case RAISE_TAX_WAR: 
            case RAISE_TAX_ACT: {
                int taxRaise = monarch.raiseTax(this.random);
                Goods goods = serverPlayer.getMostValuableGoods();
                if (goods == null) {
                    logger.finest("Ignoring tax raise, no goods to boycott.");
                    break;
                }
                Object template = ((StringTemplate)StringTemplate.template(messageId).addStringTemplate("%goods%", goods.getType().getLabel())).addAmount("%amount%", taxRaise);
                if (action == Monarch.MonarchAction.RAISE_TAX_WAR) {
                    template = ((StringTemplate)template).add("%nation%", Nation.getRandomNonPlayerNationNameKey(game, this.random));
                } else if (action == Monarch.MonarchAction.RAISE_TAX_ACT) {
                    template = ((StringTemplate)((StringTemplate)template).addAmount("%number%", RandomUtils.randomInt(logger, "Tax act goods", this.random, 6))).addName("%newWorld%", serverPlayer.getNewLandName());
                }
                cs.add(ChangeSet.See.only(serverPlayer), new MonarchActionMessage(action, (StringTemplate)template, monarchKey).setTax(taxRaise));
                new MonarchSession(serverPlayer, action, taxRaise, goods).register();
                break;
            }
            case LOWER_TAX_WAR: 
            case LOWER_TAX_OTHER: {
                int oldTax = serverPlayer.getTax();
                int taxLower = monarch.lowerTax(this.random);
                serverPlayer.csSetTax(taxLower, cs);
                Object template = ((StringTemplate)StringTemplate.template(messageId).addAmount("%difference%", oldTax - taxLower)).addAmount("%newTax%", taxLower);
                template = action == Monarch.MonarchAction.LOWER_TAX_WAR ? ((StringTemplate)template).add("%nation%", Nation.getRandomNonPlayerNationNameKey(game, this.random)) : ((StringTemplate)template).addAmount("%number%", RandomUtils.randomInt(logger, "Lower tax reason", this.random, 5));
                cs.add(ChangeSet.See.only(serverPlayer), new MonarchActionMessage(action, (StringTemplate)template, monarchKey));
                break;
            }
            case WAIVE_TAX: {
                cs.add(ChangeSet.See.only(serverPlayer), new MonarchActionMessage(action, StringTemplate.template(messageId), monarchKey));
                break;
            }
            case ADD_TO_REF: {
                AbstractUnit refAdditions = monarch.addToREF(this.random);
                if (refAdditions == null) break;
                Object template = ((StringTemplate)StringTemplate.template(messageId).addAmount("%number%", refAdditions.getNumber())).addNamed("%unit%", refAdditions.getType(spec));
                cs.add(ChangeSet.See.only(serverPlayer), monarch);
                cs.add(ChangeSet.See.only(serverPlayer), new MonarchActionMessage(action, (StringTemplate)template, monarchKey));
                break;
            }
            case DECLARE_PEACE: {
                List<Player> friends = monarch.collectPotentialFriends();
                if (friends.isEmpty()) break;
                Player friend = RandomUtils.getRandomMember(logger, "Choose friend", friends, this.random);
                serverPlayer.csChangeStance(Stance.PEACE, friend, true, cs);
                cs.add(ChangeSet.See.only(serverPlayer), new MonarchActionMessage(action, (StringTemplate)StringTemplate.template(messageId).addStringTemplate("%nation%", friend.getNationLabel()), monarchKey));
                break;
            }
            case DECLARE_WAR: {
                List<Player> enemies = monarch.collectPotentialEnemies();
                if (enemies.isEmpty()) break;
                Player enemy = RandomUtils.getRandomMember(logger, "Choose enemy", enemies, this.random);
                List<AbstractUnit> warSupport = monarch.getWarSupport(enemy, this.random);
                int warGold = 0;
                if (!warSupport.isEmpty()) {
                    serverPlayer.createUnits(warSupport, serverPlayer.getEurope(), this.random);
                    warGold = spec.getInteger("model.option.warSupportGold");
                    warGold += warGold / 10 * (RandomUtils.randomInt(logger, "War support gold", this.random, 5) - 2);
                    serverPlayer.modifyGold(warGold);
                    cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()), "score", String.valueOf(serverPlayer.getScore()));
                    logger.fine("War support v " + enemy.getNation().getSuffix() + " " + warGold + " gold + " + Messages.message(AbstractUnit.getListLabel(", ", warSupport)));
                }
                serverPlayer.csChangeStance(Stance.WAR, enemy, true, cs);
                cs.add(ChangeSet.See.only(serverPlayer), new MonarchActionMessage(action, (StringTemplate)((StringTemplate)((StringTemplate)StringTemplate.template(warSupport.isEmpty() ? messageId : "model.monarch.action.declareWarSupported.text").addStringTemplate("%nation%", enemy.getNationLabel())).addStringTemplate("%force%", AbstractUnit.getListLabel(", ", warSupport))).addAmount("%gold%", warGold), monarchKey));
                break;
            }
            case SUPPORT_LAND: 
            case SUPPORT_SEA: {
                boolean sea = action == Monarch.MonarchAction.SUPPORT_SEA;
                List<AbstractUnit> support = monarch.getSupport(this.random, sea);
                if (support.isEmpty()) break;
                serverPlayer.createUnits(support, serverPlayer.getEurope(), this.random);
                cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.getEurope());
                cs.add(ChangeSet.See.only(serverPlayer), new MonarchActionMessage(action, (StringTemplate)StringTemplate.template(messageId).addStringTemplate("%addition%", AbstractUnit.getListLabel(", ", support)), monarchKey));
                break;
            }
            case MONARCH_MERCENARIES: {
                ArrayList<AbstractUnit> mercenaries = new ArrayList<AbstractUnit>();
                int mercPrice = monarch.loadMercenaries(this.random, mercenaries);
                if (mercPrice <= 0) break;
                cs.add(ChangeSet.See.only(serverPlayer), new MonarchActionMessage(action, (StringTemplate)((StringTemplate)StringTemplate.template(messageId).addAmount("%gold%", mercPrice)).addStringTemplate("%mercenaries%", AbstractUnit.getListLabel(", ", mercenaries)), monarchKey));
                new MonarchSession(serverPlayer, action, mercenaries, mercPrice).register();
                break;
            }
            case HESSIAN_MERCENARIES: {
                ArrayList<AbstractUnit> hessians = new ArrayList<AbstractUnit>();
                int hessianPrice = monarch.loadMercenaries(this.random, hessians);
                if (hessianPrice <= 0) break;
                serverPlayer.csMercenaries(hessianPrice, hessians, action, this.random, cs);
                break;
            }
            default: {
                logger.warning("Bogus action: " + action);
            }
        }
    }

    public ChangeSet abandonSettlement(ServerPlayer serverPlayer, Settlement settlement) {
        ChangeSet cs = new ChangeSet();
        if (settlement instanceof Colony) {
            serverPlayer.csLoseLocation(settlement, cs);
            cs.addHistory(serverPlayer, (HistoryEvent)new HistoryEvent(this.getGame().getTurn(), HistoryEvent.HistoryEventType.ABANDON_COLONY, serverPlayer).addName("%colony%", settlement.getName()));
        }
        serverPlayer.csDisposeSettlement(settlement, cs);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet askLearnSkill(ServerPlayer serverPlayer, ServerUnit unit, IndianSettlement is) {
        ChangeSet cs = new ChangeSet();
        unit.csVisit(serverPlayer, is, 0, cs);
        Tile tile = is.getTile();
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
        return cs;
    }

    public ChangeSet assignTeacher(ServerPlayer serverPlayer, Unit student, Unit teacher) {
        Unit oldStudent = teacher.getStudent();
        Unit oldTeacher = student.getTeacher();
        ChangeSet cs = new ChangeSet();
        if (oldTeacher != null) {
            oldTeacher.setStudent(null);
            cs.add(ChangeSet.See.only(serverPlayer), oldTeacher);
        }
        if (oldStudent != null) {
            oldStudent.setTeacher(null);
            cs.add(ChangeSet.See.only(serverPlayer), oldStudent);
        }
        teacher.setStudent(student);
        teacher.changeWorkType(null);
        student.setTeacher(teacher);
        cs.add(ChangeSet.See.only(serverPlayer), student, teacher);
        return cs;
    }

    public ChangeSet assignTradeRoute(ServerPlayer serverPlayer, Unit unit, TradeRoute tradeRoute) {
        TradeRouteStop stop;
        unit.setDestination(tradeRoute == null && unit.isAtSea() && (stop = unit.getStop()) != null ? stop.getLocation() : null);
        unit.setTradeRoute(tradeRoute);
        if (tradeRoute != null) {
            List<TradeRouteStop> stops = tradeRoute.getStopList();
            int found = -1;
            for (int i = 0; i < stops.size(); ++i) {
                if (!Map.isSameLocation(unit.getLocation(), stops.get(i).getLocation())) continue;
                found = i;
                break;
            }
            if (found < 0) {
                found = 0;
            }
            unit.setCurrentStop(found);
        }
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit);
    }

    public ChangeSet buildSettlement(ServerPlayer serverPlayer, Unit unit, String name) {
        Settlement settlement;
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        ChangeSet cs = new ChangeSet();
        Tile tile = unit.getTile();
        if ("".equals(name)) {
            name = serverPlayer.getSettlementName(this.random);
        }
        if (serverPlayer.isEuropean()) {
            StringTemplate nation = serverPlayer.getNationLabel();
            settlement = new ServerColony(game, serverPlayer, name, tile);
            for (Tile tile2 : tile.getSurroundingTiles(settlement.getRadius())) {
                tile2.cacheUnseen();
            }
            Set<Tile> visible = settlement.getVisibleTileSet();
            cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.collectNewTiles(visible));
            for (Player sp : CollectionUtils.transform(game.getConnectedPlayers(serverPlayer), coronadoPred)) {
                cs.add(ChangeSet.See.only(sp), ((ServerPlayer)sp).exploreForSettlement(settlement));
                sp.invalidateCanSeeTiles();
                cs.addMessage(sp, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "buildColony.others", settlement).addStringTemplate("%nation%", nation)).addStringTemplate("%colony%", settlement.getLocationLabelFor(sp))).addStringTemplate("%region%", tile.getRegion().getLabel()));
            }
            serverPlayer.addSettlement(settlement);
            boolean bl = spec.getBoolean("model.option.claimAllTiles");
            settlement.placeSettlement(bl);
            cs.addHistory(serverPlayer, (HistoryEvent)new HistoryEvent(game.getTurn(), HistoryEvent.HistoryEventType.FOUND_COLONY, serverPlayer).addName("%colony%", settlement.getName()));
            settlement.equipForRole(unit, spec.getDefaultRole(), 0);
        } else {
            IndianNationType nationType = (IndianNationType)serverPlayer.getNationType();
            UnitType skill = (UnitType)RandomChoice.getWeightedRandom(logger, "Choose skill", nationType.generateSkillsForTile(tile), this.random);
            if (skill == null) {
                List<UnitType> list = spec.getUnitTypesWithAbility("model.ability.expertScout");
                skill = RandomUtils.getRandomMember(logger, "Choose scout", list, this.random);
            }
            settlement = new ServerIndianSettlement(game, serverPlayer, name, tile, false, skill, null);
            for (Tile t : tile.getSurroundingTiles(settlement.getRadius())) {
                t.cacheUnseen();
            }
            serverPlayer.addSettlement(settlement);
            settlement.placeSettlement(true);
            for (Player p : this.getGame().getLivePlayerList(serverPlayer)) {
                ((IndianSettlement)settlement).setAlarm(p, p.isIndian() ? new Tension(Tension.Level.CONTENT.getLimit()) : serverPlayer.getTension(p));
            }
        }
        unit.setLocation(settlement);
        unit.setMovesLeft(0);
        cs.add(ChangeSet.See.perhaps(), settlement.getOwnedTiles());
        serverPlayer.invalidateCanSeeTiles();
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    private ChangeSet buyGoods(ServerPlayer serverPlayer, GoodsType type, int amount, Unit carrier) {
        if (!serverPlayer.canTrade(type, Market.Access.EUROPE)) {
            return serverPlayer.clientError("Can not trade boycotted goods");
        }
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = carrier.getGoodsContainer();
        container.saveState();
        int gold = serverPlayer.getGold();
        int buyAmount = serverPlayer.buyInEurope(this.random, container, type, amount);
        if (buyAmount < 0) {
            return serverPlayer.clientError("Player " + serverPlayer.getName() + " tried to buy " + amount + " " + type.getSuffix());
        }
        serverPlayer.propagateToEuropeanMarkets(type, -buyAmount, this.random);
        serverPlayer.csFlushMarket(type, cs);
        carrier.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()));
        cs.add(ChangeSet.See.only(serverPlayer), carrier);
        logger.finest(carrier + " bought " + amount + "(" + buyAmount + ") " + type.getSuffix() + " in Europe for " + (serverPlayer.getGold() - gold));
        return cs;
    }

    public ChangeSet cashInTreasureTrain(ServerPlayer serverPlayer, Unit unit) {
        String messageId;
        int cashInAmount;
        ServerGame game = this.getGame();
        ChangeSet cs = new ChangeSet();
        int fullAmount = unit.getTreasureAmount();
        if (serverPlayer.getPlayerType() == Player.PlayerType.COLONIAL) {
            cashInAmount = (fullAmount - unit.getTransportFee()) * (100 - serverPlayer.getTax()) / 100;
            messageId = "cashInTreasureTrain.colonial";
        } else {
            cashInAmount = fullAmount;
            messageId = "cashInTreasureTrain.independent";
        }
        serverPlayer.modifyGold(cashInAmount);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()), "score", String.valueOf(serverPlayer.getScore()));
        cs.addMessage(serverPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, serverPlayer, unit).addAmount("%amount%", fullAmount)).addAmount("%cashInAmount%", cashInAmount));
        messageId = serverPlayer.isRebel() || serverPlayer.getPlayerType() == Player.PlayerType.INDEPENDENT ? "cashInTreasureTrain.otherIndependent" : "cashInTreasureTrain.otherColonial";
        cs.addGlobalMessage(game, serverPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, serverPlayer).addAmount("%amount%", fullAmount)).addStringTemplate("%nation%", serverPlayer.getNationLabel()));
        cs.add(ChangeSet.See.only(serverPlayer), (FreeColGameObject)((Object)unit.getLocation()));
        ((ServerUnit)unit).csRemove(ChangeSet.See.only(serverPlayer), null, cs);
        game.sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet changeState(ServerPlayer serverPlayer, Unit unit, Unit.UnitState state) {
        boolean tileDirty;
        ChangeSet cs = new ChangeSet();
        Tile tile = unit.getTile();
        boolean bl = tileDirty = tile != null && tile.getIndianSettlement() != null;
        if (state == Unit.UnitState.FORTIFYING && tile != null) {
            Player owner;
            ServerColony colony = tile.getOwningSettlement() instanceof Colony ? (ServerColony)tile.getOwningSettlement() : null;
            Player player = owner = colony == null ? null : colony.getOwner();
            if (owner != null && owner != unit.getOwner() && serverPlayer.getStance(owner) != Stance.ALLIANCE && serverPlayer.getStance(owner) != Stance.PEACE) {
                if (colony.isTileInUse(tile)) {
                    colony.csEvictUsers(unit, cs);
                }
                if (serverPlayer.getStance(owner) == Stance.WAR) {
                    tile.changeOwnership(null, null);
                    tileDirty = true;
                }
            }
        }
        unit.setState(state);
        if (tileDirty) {
            cs.add(ChangeSet.See.perhaps(), tile);
        } else {
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)unit.getLocation()));
        }
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet changeWorkImprovementType(ServerPlayer serverPlayer, Unit unit, TileImprovementType type) {
        Tile tile = unit.getTile();
        TileImprovement improvement = tile.getTileImprovement(type);
        if (improvement == null) {
            improvement = new TileImprovement(this.getGame(), tile, type, null);
            tile.add(improvement);
        }
        unit.setWorkImprovement(improvement);
        unit.setState(Unit.UnitState.IMPROVING);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), tile);
    }

    public ChangeSet changeWorkType(ServerPlayer serverPlayer, Unit unit, GoodsType type) {
        if (unit.getWorkType() != type) {
            unit.setExperience(0);
            unit.changeWorkType(type);
        }
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit.getColony());
    }

    public ChangeSet chat(ServerPlayer serverPlayer, String message, boolean pri) {
        this.getGame().sendToOthers(serverPlayer, ChangeSet.simpleChange(ChangeSet.See.all().except(serverPlayer), (Message)new ChatMessage(serverPlayer, message, false)));
        return null;
    }

    public ChangeSet chooseFoundingFather(ServerPlayer serverPlayer, FoundingFather ff) {
        List<FoundingFather> offered = serverPlayer.getOfferedFathers();
        if (!serverPlayer.canRecruitFoundingFather()) {
            return serverPlayer.clientError("Player can not recruit fathers: " + serverPlayer.getId());
        }
        if (!offered.contains(ff)) {
            return serverPlayer.clientError("Founding father not offered: " + ff.getId());
        }
        serverPlayer.updateCurrentFather(ff);
        return null;
    }

    public ChangeSet claimLand(ServerPlayer serverPlayer, Tile tile, Settlement settlement, int price) {
        ServerGame sg = this.getGame();
        ChangeSet cs = new ChangeSet();
        serverPlayer.csClaimLand(tile, settlement, price, cs);
        if (settlement != null && serverPlayer.isEuropean()) {
            for (Player sp : CollectionUtils.transform(sg.getConnectedPlayers(serverPlayer), coronadoPred)) {
                ((ServerPlayer)sp).exploreTile(tile);
                cs.add(ChangeSet.See.only(sp), tile);
                sp.invalidateCanSeeTiles();
            }
        }
        sg.sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet clearSpeciality(ServerPlayer serverPlayer, Unit unit) {
        UnitTypeChange uc = unit.getUnitChange("model.unitChange.clearSkill");
        if (uc == null) {
            return serverPlayer.clientError("Can not clear unit speciality: " + unit.getId());
        }
        if (unit.getStudent() != null) {
            return serverPlayer.clientError("Can not clear speciality of a teacher.");
        }
        unit.changeType(uc.to);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit);
    }

    public ChangeSet combat(ServerPlayer attackerPlayer, FreeColGameObject attacker, FreeColGameObject defender, List<CombatModel.CombatResult> crs) {
        ChangeSet cs = new ChangeSet();
        try {
            attackerPlayer.csCombat(attacker, defender, crs, this.random, cs);
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, "Combat FAIL", e);
            return attackerPlayer.clientError(e.getMessage());
        }
        this.getGame().sendToOthers(attackerPlayer, cs);
        return cs;
    }

    public ChangeSet continuePlaying(ServerPlayer serverPlayer) {
        ServerGame game = this.getGame();
        if (!this.getFreeColServer().getSinglePlayer()) {
            logger.warning("Can not continue playing in multiplayer!");
        } else if (serverPlayer != game.checkForWinner()) {
            logger.warning("Can not continue playing, as " + serverPlayer.getName() + " has not won the game!");
        } else {
            Specification spec = game.getSpecification();
            spec.setBoolean("model.option.victoryDefeatREF", false);
            spec.setBoolean("model.option.victoryDefeatEuropeans", false);
            spec.setBoolean("model.option.victoryDefeatHumans", false);
            logger.info("Disabled victory conditions, as " + serverPlayer.getName() + " has won, but is continuing to play.");
        }
        return null;
    }

    public ChangeSet declareIndependence(ServerPlayer serverPlayer, String nationName, String countryName) {
        ArrayList<AbstractUnit> mercs;
        int mercPrice;
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        ChangeSet cs = new ChangeSet();
        StringTemplate oldNation = serverPlayer.getNationLabel();
        serverPlayer.setIndependentNationName(nationName);
        serverPlayer.setNewLandName(countryName);
        serverPlayer.changePlayerType(Player.PlayerType.REBEL);
        Turn turn = game.getTurn();
        HistoryEvent h = new HistoryEvent(turn, HistoryEvent.HistoryEventType.DECLARE_INDEPENDENCE, serverPlayer);
        int independenceTurn = spec.getInteger("model.option.independenceTurn");
        h.setScore(Math.max(0, independenceTurn - turn.getNumber()));
        cs.addGlobalHistory(game, h);
        serverPlayer.clearModelMessages();
        cs.addMessage(serverPlayer, new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "declareIndependence.resolution", serverPlayer));
        Europe europe = serverPlayer.getEurope();
        StringTemplate seized = StringTemplate.label(", ");
        boolean lost = false;
        for (Unit u2 : europe.getUnitList()) {
            seized.addStringTemplate(u2.getLabel());
            ((ServerUnit)u2).csRemove(ChangeSet.See.only(serverPlayer), null, cs);
            lost = true;
        }
        for (Unit u2 : CollectionUtils.transform(serverPlayer.getHighSeas().getUnits(), CollectionUtils.matchKey(europe, Unit::getDestination))) {
            seized.addStringTemplate(u2.getLabel());
            ((ServerUnit)u2).csRemove(ChangeSet.See.only(serverPlayer), null, cs);
            lost = true;
        }
        if (lost) {
            cs.addMessage(serverPlayer, (ModelMessage)new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "declareIndependence.unitsSeized", serverPlayer).addStringTemplate("%units%", seized));
        }
        serverPlayer.csLoseLocation(europe, cs);
        serverPlayer.reinitialiseMarket();
        ServerPlayer refPlayer = this.createREFPlayer(serverPlayer);
        cs.addPlayers(Collections.singletonList(refPlayer));
        Monarch monarch = serverPlayer.getMonarch();
        monarch.updateInterventionForce();
        String otherKey = Nation.getRandomNonPlayerNationNameKey(game, this.random);
        cs.addMessage(serverPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "declareIndependence.interventionForce", serverPlayer).add("%nation%", otherKey)).addAmount("%number%", spec.getInteger("model.option.interventionBells")));
        serverPlayer.csChangeStance(Stance.WAR, refPlayer, true, cs);
        HashMap unitMap = new HashMap();
        for (Colony colony : CollectionUtils.transform(serverPlayer.getColonies(), c -> c.getSonsOfLiberty() > 50)) {
            List<Unit> allUnits = colony.getAllUnitsList();
            int limit = (allUnits.size() + 2) * (colony.getSonsOfLiberty() - 50) / 100;
            unitMap.clear();
            for (Unit unit : CollectionUtils.transform(allUnits, u -> u.getUnitChange("model.unitChange.independence") != null)) {
                CollectionUtils.appendToMapList(unitMap, unit.getType(), unit);
            }
            for (Map.Entry entry : unitMap.entrySet()) {
                int n;
                UnitType fromType = (UnitType)entry.getKey();
                UnitType toType = spec.getUnitChange((String)"model.unitChange.independence", (UnitType)fromType).to;
                List units = (List)entry.getValue();
                for (n = 0; n < limit && !units.isEmpty(); ++n) {
                    Unit unit = (Unit)units.remove(0);
                    unit.changeType(toType);
                    cs.add(ChangeSet.See.only(serverPlayer), unit);
                }
                cs.addMessage(serverPlayer, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_IMPROVED, "declareIndependence.continentalArmyMuster", serverPlayer, colony).addName("%colony%", colony.getName())).addAmount("%number%", n)).addNamed("%oldUnit%", fromType)).addNamed("%unit%", toType));
                limit -= n;
            }
        }
        Comparator<Player> comp = Comparator.comparingInt(p -> p.getTension(serverPlayer).getValue());
        List<Player> natives = CollectionUtils.transform(game.getLiveNativePlayers(new Player[0]), p -> p.hasContacted(serverPlayer), Function.identity(), comp);
        if (!natives.isEmpty()) {
            int delta;
            Player good = CollectionUtils.first(natives);
            logger.info("Native ally following independence: " + good);
            cs.addMessage(serverPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "declareIndependence.nativeSupport", good).addStringTemplate("%nation%", good.getNationLabel())).add("%ruler%", serverPlayer.getRulerNameKey()));
            switch (good.getStance(serverPlayer)) {
                default: {
                    delta = 0;
                    break;
                }
                case CEASE_FIRE: {
                    delta = Tension.Level.HAPPY.getLimit() - good.getTension(serverPlayer).getValue();
                    break;
                }
                case WAR: {
                    delta = Tension.Level.CONTENT.getLimit() - good.getTension(serverPlayer).getValue();
                }
            }
            ((ServerPlayer)good).csModifyTension(serverPlayer, delta, cs);
            Player.makeContact(good, refPlayer);
            ((ServerPlayer)good).csModifyTension(refPlayer, Tension.Level.HATEFUL.getLimit(), cs);
            CollectionUtils.reverse(natives);
            Player bad = null;
            for (Player p2 : natives) {
                if (p2 == good || p2.getStance(serverPlayer) == Stance.ALLIANCE) break;
                bad = p2;
                if (p2.atWarWith(serverPlayer)) continue;
                break;
            }
            logger.info("Native enemy following independence: " + bad);
            if (bad != null) {
                switch (bad.getStance(serverPlayer)) {
                    case PEACE: 
                    case CEASE_FIRE: {
                        delta = Tension.Level.HATEFUL.getLimit() - bad.getTension(serverPlayer).getValue();
                        break;
                    }
                    default: {
                        delta = 0;
                    }
                }
                cs.addMessage(serverPlayer, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "declareIndependence.nativeHostile", bad).addStringTemplate("%nation%", bad.getNationLabel()));
                if (delta != 0) {
                    ((ServerPlayer)bad).csModifyTension(serverPlayer, delta, cs);
                }
                Player.makeContact(bad, refPlayer);
                ((ServerPlayer)bad).csModifyTension(refPlayer, -bad.getTension(refPlayer).getValue(), cs);
            }
        }
        if ((mercPrice = monarch.loadMercenaryForce(this.random, mercs = new ArrayList<AbstractUnit>())) > 0) {
            serverPlayer.csMercenaries(mercPrice, mercs, Monarch.MonarchAction.HESSIAN_MERCENARIES, this.random, cs);
            logger.info("Mercenary force offer on declaration (" + Messages.message(AbstractUnit.getListLabel(", ", mercs)) + ") for " + mercPrice);
        } else {
            logger.info("Mercenary force offer on declaration not affordable.");
        }
        cs.addPartial(ChangeSet.See.all().except(serverPlayer), serverPlayer, "playerType", String.valueOf((Object)serverPlayer.getPlayerType()), "independentNationName", serverPlayer.getIndependentNationName(), "newLandName", serverPlayer.getNewLandName());
        cs.addGlobalMessage(game, serverPlayer, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "declareIndependence.announce", serverPlayer).addStringTemplate("%oldNation%", oldNation)).addStringTemplate("%newNation%", serverPlayer.getNationLabel())).add("%ruler%", serverPlayer.getRulerNameKey()));
        cs.add(ChangeSet.See.only(serverPlayer), serverPlayer);
        serverPlayer.invalidateCanSeeTiles();
        cs.addRemove(ChangeSet.See.only(serverPlayer), null, europe);
        europe.dispose();
        game.sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet declineMounds(ServerPlayer serverPlayer, Tile tile) {
        tile.cacheUnseen();
        tile.removeLostCityRumour();
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.perhaps(), tile);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet deleteTradeRoute(ServerPlayer serverPlayer, TradeRoute tradeRoute) {
        List<Unit> dropped = serverPlayer.removeTradeRoute(tradeRoute);
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.only(serverPlayer), serverPlayer);
        if (!dropped.isEmpty()) {
            cs.add(ChangeSet.See.only(serverPlayer), dropped);
        }
        return cs;
    }

    public ChangeSet deliverGiftToSettlement(ServerPlayer serverPlayer, ServerUnit unit, Settlement settlement, Goods goods) {
        NativeTradeSession session = Session.lookup(NativeTradeSession.class, unit, settlement);
        if (session == null) {
            return serverPlayer.clientError("Trying to deliver gift without opening a session");
        }
        NativeTrade nt = session.getNativeTrade();
        if (!nt.getGift()) {
            return serverPlayer.clientError("Trying to deliver gift in a session where gift giving is not allowed: " + unit + " " + settlement + " " + session);
        }
        ChangeSet cs = new ChangeSet();
        Tile tile = settlement.getTile();
        GoodsLocation.moveGoods(unit, goods.getType(), goods.getAmount(), settlement);
        cs.add(ChangeSet.See.perhaps(), unit);
        if (settlement instanceof ServerIndianSettlement) {
            ServerIndianSettlement sis = (ServerIndianSettlement)settlement;
            int alarmBonus = -Math.round((float)sis.getPriceToBuy(goods) * 0.001f * (float)this.getGame().getSpecification().getPercentage("model.option.alarmBonusGift"));
            unit.csVisit(serverPlayer, sis, 0, cs);
            sis.csModifyAlarm(serverPlayer, alarmBonus, true, cs);
            sis.updateWantedGoods();
            tile.updateIndianSettlement(serverPlayer);
            cs.add(ChangeSet.See.only(serverPlayer), tile);
        }
        nt.setGift(true);
        ModelMessage m = (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.GIFT_GOODS, "deliverGift.goods", settlement, goods.getType()).addStringTemplate("%player%", serverPlayer.getNationLabel())).addNamed("%type%", goods)).addAmount("%amount%", goods.getAmount())).addName("%settlement%", settlement.getName());
        cs.addMessage(serverPlayer, m);
        Player receiver = settlement.getOwner();
        if (receiver.isConnected() && settlement instanceof Colony) {
            cs.add(ChangeSet.See.only(receiver), unit);
            cs.add(ChangeSet.See.only(receiver), settlement);
            cs.addMessage(receiver, m);
        }
        logger.info("Gift delivered by unit: " + unit.getId() + " to settlement: " + settlement.getName());
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet demandTribute(ServerPlayer serverPlayer, ServerUnit unit, IndianSettlement is) {
        ModelMessage m;
        ChangeSet cs = new ChangeSet();
        int TURNS_PER_TRIBUTE = 5;
        unit.csVisit(serverPlayer, is, 0, cs);
        Player indianPlayer = is.getOwner();
        int gold = 0;
        int year = this.getGame().getTurn().getNumber();
        RandomRange gifts = is.getType().getGifts();
        if (is.getLastTribute() + 5 < year && gifts != null) {
            switch (indianPlayer.getTension(serverPlayer).getLevel()) {
                case HAPPY: 
                case CONTENT: {
                    gold = Math.min(gifts.getAmount("Tribute", this.random, true) / 10, 100);
                    break;
                }
                case DISPLEASED: {
                    gold = Math.min(gifts.getAmount("Tribute", this.random, true) / 20, 100);
                    break;
                }
                default: {
                    gold = 0;
                }
            }
        }
        ((ServerIndianSettlement)is).csModifyAlarm(serverPlayer, 200, true, cs);
        is.setLastTribute(year);
        if (gold > 0) {
            indianPlayer.modifyGold(-gold);
            serverPlayer.modifyGold(gold);
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()), "score", String.valueOf(serverPlayer.getScore()));
            m = (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "scoutSettlement.tributeAgree", unit, is).addAmount("%amount%", gold);
        } else {
            m = new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "scoutSettlement.tributeDisagree", unit, is);
        }
        cs.addMessage(serverPlayer, m);
        Tile tile = is.getTile();
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
        return cs;
    }

    public ChangeSet denounceMission(ServerPlayer serverPlayer, ServerUnit sUnit, IndianSettlement is) {
        ChangeSet cs = new ChangeSet();
        sUnit.csVisit(serverPlayer, is, 0, cs);
        Unit missionary = is.getMissionary();
        if (missionary == null) {
            return serverPlayer.clientError("Denouncing null missionary");
        }
        Player enemy = missionary.getOwner();
        double denounce = RandomUtils.randomDouble(logger, "Denounce base", this.random) * (double)enemy.getImmigration() / (double)(serverPlayer.getImmigration() + 1);
        if (missionary.hasAbility("model.ability.expertMissionary")) {
            denounce += 0.2;
        }
        if (sUnit.hasAbility("model.ability.expertMissionary")) {
            denounce -= 0.2;
        }
        if (denounce < 0.5) {
            return this.establishMission(serverPlayer, sUnit, is);
        }
        Player owner = is.getOwner();
        cs.add(ChangeSet.See.only(serverPlayer), is);
        cs.addMessage(serverPlayer, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.mission.noDenounce", serverPlayer, sUnit).addStringTemplate("%nation%", owner.getNationLabel()));
        cs.addMessage(enemy, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.mission.enemyDenounce", enemy, is).addStringTemplate("%enemy%", serverPlayer.getNationLabel())).addStringTemplate("%settlement%", is.getLocationLabelFor(enemy))).addStringTemplate("%nation%", owner.getNationLabel()));
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)sUnit.getLocation()));
        sUnit.csRemove(ChangeSet.See.perhaps().always(serverPlayer), sUnit.getLocation(), cs);
        serverPlayer.invalidateCanSeeTiles();
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet diplomacy(ServerPlayer serverPlayer, Unit ourUnit, Colony otherColony, DiplomaticTrade agreement) {
        ChangeSet cs = new ChangeSet();
        DiplomaticTrade.TradeStatus status = agreement.getStatus();
        DiplomacySession session = Session.lookup(DiplomacySession.class, DiplomacySession.makeDiplomacySessionKey(ourUnit, otherColony));
        if (session == null) {
            if (status != DiplomaticTrade.TradeStatus.PROPOSE_TRADE) {
                return serverPlayer.clientError("Missing uc-diplomacy session for " + ourUnit.getId() + "/" + otherColony.getId() + " with " + agreement);
            }
            session = new DiplomacySession(ourUnit, otherColony, this.getTimeout());
            session.register();
            logger.info("New diplomacy session: " + session);
        } else {
            logger.info("Continuing diplomacy session: " + session + " from " + ourUnit);
        }
        serverPlayer.csDiplomacy(session, agreement, cs);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet diplomacy(ServerPlayer serverPlayer, Colony ourColony, Unit otherUnit, DiplomaticTrade agreement) {
        ChangeSet cs = new ChangeSet();
        DiplomacySession session = Session.lookup(DiplomacySession.class, DiplomacySession.makeDiplomacySessionKey(otherUnit, ourColony));
        if (session == null) {
            return serverPlayer.clientError("Missing cu-diplomacy session for " + otherUnit.getId() + "/" + ourColony.getId() + " with " + agreement);
        }
        logger.info("Continuing diplomacy session: " + session + " from " + ourColony);
        serverPlayer.csDiplomacy(session, agreement, cs);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet disbandUnit(ServerPlayer serverPlayer, Unit unit) {
        ChangeSet cs = new ChangeSet();
        Location loc = unit.getLocation();
        cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)loc));
        ((ServerUnit)unit).csRemove(ChangeSet.See.perhaps().always(serverPlayer), loc, cs);
        serverPlayer.invalidateCanSeeTiles();
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet disconnect(ServerPlayer serverPlayer) {
        FreeColServer freeColServer = this.getFreeColServer();
        if (serverPlayer != null) {
            freeColServer.removePlayerConnection(serverPlayer);
        }
        return null;
    }

    public ChangeSet disembarkUnit(ServerPlayer serverPlayer, ServerUnit serverUnit) {
        if (serverUnit.isNaval()) {
            return serverPlayer.clientError("Naval unit " + serverUnit.getId() + " can not disembark.");
        }
        Unit carrier = serverUnit.getCarrier();
        if (carrier == null) {
            return serverPlayer.clientError("Unit " + serverUnit.getId() + " is not embarked.");
        }
        ChangeSet cs = new ChangeSet();
        Location newLocation = carrier.getLocation();
        Set<Tile> newTiles = newLocation.getTile() == null ? null : serverPlayer.collectNewTiles(newLocation.getTile(), serverUnit.getLineOfSight());
        serverUnit.setLocation(newLocation);
        serverPlayer.invalidateCanSeeTiles();
        serverUnit.setMovesLeft(0);
        cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)newLocation));
        if (newTiles != null) {
            serverPlayer.csSeeNewTiles(newTiles, cs);
        }
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet embarkUnit(ServerPlayer serverPlayer, ServerUnit serverUnit, Unit carrier) {
        if (serverUnit.isNaval()) {
            return serverPlayer.clientError("Naval unit " + serverUnit.getId() + " can not embark.");
        }
        UnitLocation.NoAddReason reason = carrier.getNoAddReason(serverUnit);
        if (reason != UnitLocation.NoAddReason.NONE) {
            return serverPlayer.clientError("Carrier: " + carrier.getId() + " can not carry " + serverUnit.getId() + ": " + reason);
        }
        ChangeSet cs = new ChangeSet();
        serverUnit.csEmbark(carrier, cs);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet emigrate(ServerPlayer serverPlayer, int slot, Europe.MigrationType type) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.csEmigrate(slot, type, this.random, cs);
        return cs;
    }

    public ChangeSet endTurn(ServerPlayer serverPlayer) {
        List<Player> players;
        FreeColServer freeColServer = this.getFreeColServer();
        ServerGame serverGame = this.getGame();
        ServerPlayer winner = serverGame.checkForWinner();
        ServerPlayer current = (ServerPlayer)serverGame.getCurrentPlayer();
        if (serverPlayer != current) {
            throw new RuntimeException("It is not " + serverPlayer.getName() + "'s turn, it is " + (current == null ? "noone" : current.getName()) + "'s!");
        }
        ChangeSet cs = new ChangeSet();
        while (true) {
            boolean debugSkip;
            current.csEndTurn(cs);
            logger.finest("Ending turn for " + current.getName());
            current.clearModelMessages();
            if (serverGame.isNextPlayerInNewTurn()) {
                serverGame.csNextTurn(cs);
                LogBuilder lb = new LogBuilder(512);
                lb.add("New turn ", serverGame.getTurn(), " for ");
                serverGame.csNewTurn(this.random, lb, cs);
                lb.shrink(", ");
                lb.log(logger, Level.FINEST);
                if (this.debugOnlyAITurns > 0 && --this.debugOnlyAITurns <= 0) {
                    FreeColDebugger.signalEndDebugRun();
                }
                serverGame.sendToAll(cs);
                cs.clear();
            }
            if ((current = (ServerPlayer)serverGame.getNextPlayer()) == null) {
                return serverPlayer.clientError("Can not get next player");
            }
            switch (current.checkForDeath()) {
                case IS_DEFEATED: {
                    for (Player p : current.getRebels()) {
                        this.csGiveIndependence(current, p, cs);
                    }
                }
                case IS_DEAD: {
                    current.csWithdraw(cs, null, null);
                    logger.info("For " + serverPlayer.getSuffix() + ", " + current.getNation() + " has withdrawn.");
                    break;
                }
                case IS_AUTORECRUIT: {
                    current.csEmigrate(0, Europe.MigrationType.SURVIVAL, this.random, cs);
                    break;
                }
            }
            if (!cs.isEmpty()) {
                serverGame.sendToAll(cs);
                cs.clear();
            }
            if (current.isDead()) continue;
            List<Player> connected = serverGame.getConnectedPlayers(new Player[0]);
            boolean onlyAI = CollectionUtils.all(connected, Player::isAI);
            if (onlyAI) {
                Comparator<Player> scoreComp = Comparator.comparingInt(Player::getScore).reversed();
                winner = (ServerPlayer)CollectionUtils.first(CollectionUtils.sort(connected, scoreComp));
                logger.info("No human player left, winner is: " + winner);
                if (this.debugOnlyAITurns > 0) {
                    FreeColDebugger.signalEndDebugRun();
                }
                serverGame.setCurrentPlayer(null);
                cs.add(ChangeSet.See.all(), new GameEndedMessage(winner, false));
                serverGame.sendToAll(cs);
                cs.clear();
            }
            if (!(winner != current || freeColServer.getSinglePlayer() && winner.isAI())) {
                boolean highScore = !winner.isAI() && HighScore.newHighScore(winner);
                cs.add(ChangeSet.See.all(), new GameEndedMessage(winner, highScore));
                serverGame.sendToAll(cs);
                cs.clear();
            }
            serverGame.setCurrentPlayer(current);
            if (current.isREF() && current.getEntryTile() == null) {
                boolean teleport;
                REFAIPlayer refAIPlayer = (REFAIPlayer)freeColServer.getAIPlayer(current);
                if (refAIPlayer.initialize(teleport = serverGame.getSpecification().getBoolean("model.option.teleportREF"))) {
                    this.csLaunchREF(current, teleport, cs);
                } else {
                    logger.severe("REF failed to initialize.");
                }
            }
            current.csStartTurn(this.random, cs);
            cs.add(ChangeSet.See.all(), new SetCurrentPlayerMessage(current));
            if (current.getPlayerType() == Player.PlayerType.COLONIAL) {
                Monarch monarch = current.getMonarch();
                Monarch.MonarchAction action = null;
                if (this.debugMonarchAction != null && current == this.debugMonarchPlayer) {
                    action = this.debugMonarchAction;
                    this.debugMonarchAction = null;
                    this.debugMonarchPlayer = null;
                    logger.finest("Debug monarch action: " + action);
                } else if (monarch != null) {
                    action = (Monarch.MonarchAction)((Object)RandomChoice.getWeightedRandom(logger, "Choose monarch action", monarch.getActionChoices(), this.random));
                }
                if (action != null) {
                    if (monarch.actionIsValid(action)) {
                        logger.finest("Monarch action: " + action);
                        this.csMonarchAction(current, action, cs);
                    } else {
                        logger.finest("Skipping invalid monarch action: " + action);
                    }
                }
            }
            players = serverGame.getConnectedPlayers(current);
            players.add(current);
            boolean bl = debugSkip = this.debugOnlyAITurns > 0 && !current.isAI() && freeColServer.getSinglePlayer();
            if (!debugSkip) break;
            serverGame.sendToList(players, cs);
            cs.clear();
        }
        players.remove(serverPlayer);
        serverGame.sendToList(players, cs);
        return cs;
    }

    public ChangeSet enterRevengeMode(ServerPlayer serverPlayer) {
        if (!this.getFreeColServer().getSinglePlayer()) {
            return serverPlayer.clientError("Can not enter revenge mode, as this is not a single player game.");
        }
        ServerGame game = this.getGame();
        List<UnitType> undeads = game.getSpecification().getUnitTypesWithAbility("model.ability.undead");
        ArrayList<UnitType> navalUnits = new ArrayList<UnitType>();
        ArrayList<UnitType> landUnits = new ArrayList<UnitType>();
        for (UnitType undead : undeads) {
            if (undead.hasAbility("model.ability.navalUnit")) {
                navalUnits.add(undead);
                continue;
            }
            if (!undead.hasAbility("model.ability.multipleAttacks")) continue;
            landUnits.add(undead);
        }
        if (navalUnits.isEmpty() || landUnits.isEmpty()) {
            return serverPlayer.clientError("Can not enter revenge mode, because we can not find the undead units.");
        }
        ChangeSet cs = new ChangeSet();
        UnitType navalType = (UnitType)RandomUtils.getRandomMember(logger, "Choose undead navy", navalUnits, this.random);
        Tile start = serverPlayer.getEntryTile().getSafeTile(serverPlayer, this.random);
        ServerUnit theFlyingDutchman = new ServerUnit(game, start, serverPlayer, navalType);
        UnitType landType = (UnitType)RandomUtils.getRandomMember(logger, "Choose undead army", landUnits, this.random);
        ServerUnit undead = new ServerUnit(game, theFlyingDutchman, serverPlayer, landType);
        assert (undead != null);
        cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.exploreForUnit(theFlyingDutchman));
        serverPlayer.setDead(false);
        serverPlayer.changePlayerType(Player.PlayerType.UNDEAD);
        serverPlayer.invalidateCanSeeTiles();
        for (Player p : CollectionUtils.transform(game.getLivePlayers(serverPlayer), p2 -> serverPlayer.hasContacted((Player)p2))) {
            serverPlayer.csChangeStance(Stance.WAR, p, true, cs);
        }
        game.setCurrentPlayer(serverPlayer);
        cs.add(ChangeSet.See.all(), new SetCurrentPlayerMessage(serverPlayer));
        cs.add(ChangeSet.See.all(), serverPlayer);
        cs.add(ChangeSet.See.perhaps(), start);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet equipForRole(ServerPlayer serverPlayer, Unit unit, Role role, int roleCount) {
        Unit carrier;
        ChangeSet cs = new ChangeSet();
        boolean ret = false;
        if (unit.isInEurope()) {
            ServerEurope serverEurope = (ServerEurope)serverPlayer.getEurope();
            ret = serverEurope.csEquipForRole(unit, role, roleCount, this.random, cs);
        } else if (unit.getColony() != null) {
            ServerColony serverColony = (ServerColony)unit.getColony();
            ret = serverColony.csEquipForRole(unit, role, roleCount, this.random, cs);
        } else if (unit.getIndianSettlement() != null) {
            ServerIndianSettlement sis = (ServerIndianSettlement)unit.getIndianSettlement();
            ret = sis.csEquipForRole(unit, role, roleCount, this.random, cs);
        } else {
            return serverPlayer.clientError("Unsuitable equip location for: " + unit.getId());
        }
        if (!ret) {
            return null;
        }
        if (unit.getInitialMovesLeft() != unit.getMovesLeft()) {
            unit.setMovesLeft(0);
        }
        if ((carrier = unit.getCarrier()) != null && carrier.getInitialMovesLeft() != carrier.getMovesLeft() && carrier.getMovesLeft() != 0) {
            carrier.setMovesLeft(0);
        }
        return cs;
    }

    public ChangeSet establishMission(ServerPlayer serverPlayer, ServerUnit sUnit, IndianSettlement is) {
        ChangeSet cs = new ChangeSet();
        sUnit.csVisit(serverPlayer, is, 0, cs);
        Tension tension = is.getAlarm(serverPlayer);
        Location loc = sUnit.getLocation();
        switch (tension.getLevel()) {
            case ANGRY: 
            case HATEFUL: {
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)loc));
                sUnit.csRemove(ChangeSet.See.perhaps().always(serverPlayer), loc, cs);
                serverPlayer.invalidateCanSeeTiles();
                break;
            }
            case HAPPY: 
            case CONTENT: 
            case DISPLEASED: {
                ServerIndianSettlement sis = (ServerIndianSettlement)is;
                if (is.hasMissionary()) {
                    sis.csKillMissionary(Boolean.FALSE, cs);
                }
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), sUnit.getTile());
                sis.csChangeMissionary(sUnit, cs);
            }
        }
        StringTemplate nation = is.getOwner().getNationLabel();
        cs.addMessage(serverPlayer, (ModelMessage)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.mission." + tension.getKey(), serverPlayer, sUnit).addStringTemplate("%nation%", nation));
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet europeanFirstContact(ServerPlayer serverPlayer, Unit ourUnit, Colony ourColony, Unit otherUnit, Colony otherColony, DiplomaticTrade agreement) {
        DiplomacySession ds;
        String err = "Missing contact diplomacy session for ";
        boolean compatible = false;
        if (ourColony != null) {
            ds = DiplomacySession.findContactSession(otherUnit, ourColony);
            if (ds == null) {
                return serverPlayer.clientError(err + ourColony.getId() + " and " + otherUnit.getId());
            }
            compatible = ds.isCompatible(ourColony, otherUnit);
        } else if (otherUnit != null) {
            ds = DiplomacySession.findContactSession(ourUnit, otherUnit);
            if (ds == null) {
                return serverPlayer.clientError(err + ourUnit.getId() + " and " + otherUnit.getId());
            }
            compatible = ds.isCompatible(ourUnit, otherUnit);
        } else {
            ds = DiplomacySession.findContactSession(ourUnit, otherColony);
            if (ds == null) {
                return serverPlayer.clientError(err + ourUnit.getId() + " and " + otherColony.getId());
            }
            compatible = ds.isCompatible(ourUnit, otherColony);
        }
        logger.info("Continuing " + (compatible ? "" : "in") + "compatible contact session: " + ds.getKey());
        ChangeSet cs = new ChangeSet();
        if (compatible) {
            serverPlayer.csDiplomacy(ds, agreement, cs);
            this.getGame().sendToOthers(serverPlayer, cs);
        }
        return cs;
    }

    public ChangeSet gameState() {
        FreeColServer freeColServer = this.getFreeColServer();
        return ChangeSet.simpleChange((Player)null, (Message)new GameStateMessage(freeColServer.getServerState()));
    }

    public ChangeSet getHighScores(ServerPlayer serverPlayer, String key) {
        return ChangeSet.simpleChange(serverPlayer, (Message)new HighScoresMessage(key, HighScore.loadHighScores()));
    }

    public ChangeSet incite(ServerPlayer serverPlayer, ServerUnit unit, IndianSettlement is, Player enemy, int gold) {
        ChangeSet cs = new ChangeSet();
        Tile tile = is.getTile();
        unit.csVisit(serverPlayer, is, 0, cs);
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        Player nativePlayer = is.getOwner();
        int payingValue = nativePlayer.getTension(serverPlayer).getValue();
        int targetValue = nativePlayer.getTension(enemy).getValue();
        int goldToPay = payingValue > targetValue ? 10000 : 5000;
        goldToPay += 20 * (payingValue - targetValue);
        goldToPay = Math.max(goldToPay, 650);
        if (gold < 0) {
            cs.add(ChangeSet.See.only(serverPlayer), new InciteMessage(unit, is, enemy, goldToPay));
        } else if (gold < goldToPay || !serverPlayer.checkGold(gold)) {
            cs.addMessage(serverPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "missionarySettlement.inciteGoldFail", serverPlayer, is).addStringTemplate("%player%", enemy.getNationLabel())).addAmount("%amount%", goldToPay));
            unit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
        } else {
            ((ServerPlayer)nativePlayer).csModifyTension(enemy, Tension.WAR_MODIFIER, cs);
            ((ServerPlayer)enemy).csModifyTension(serverPlayer, 250, cs);
            serverPlayer.modifyGold(-gold);
            nativePlayer.modifyGold(gold);
            cs.addMessage(serverPlayer, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "missionarySettlement.inciteSuccess", nativePlayer).addStringTemplate("%native%", nativePlayer.getNationLabel())).addStringTemplate("%enemy%", enemy.getNationLabel()));
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()));
            unit.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
        }
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet indianDemand(ServerPlayer serverPlayer, Unit unit, Colony colony, GoodsType type, int amount, Constants.IndianDemandAction result) {
        Player victim = colony.getOwner();
        NativeDemandSession session = Session.lookup(NativeDemandSession.class, unit, colony);
        ChangeSet cs = new ChangeSet();
        if (serverPlayer.isIndian()) {
            if (session != null) {
                return serverPlayer.clientError("Repeated native demand: " + unit.getId() + "," + colony.getId());
            }
            session = new NativeDemandSession(unit, colony, type, amount, this.getTimeout());
            session.register();
            logger.info("Native demand(begin) " + session.getKey() + ": " + serverPlayer.getName() + " unit " + unit + " demands " + amount + " " + (Comparable)(type == null ? "gold" : type) + " from " + colony.getName());
            cs.add(ChangeSet.See.only(victim), new IndianDemandMessage(unit, colony, type, amount));
        } else {
            if (session == null) {
                return serverPlayer.clientError("Replying to missing demand: " + unit.getId() + "," + colony.getId());
            }
            logger.info("Native demand(" + result + ") " + session.getKey() + ": " + serverPlayer.getName() + " unit " + unit + " demands " + amount + " " + (Comparable)(type == null ? "gold" : type) + " from " + colony.getName());
            session.complete(result == Constants.IndianDemandAction.INDIAN_DEMAND_ACCEPT, cs);
        }
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet joinColony(ServerPlayer serverPlayer, Unit unit, Colony colony) {
        Specification spec = this.getGame().getSpecification();
        ChangeSet cs = new ChangeSet();
        Set<Tile> ownedTiles = colony.getOwnedTiles();
        Tile tile = colony.getTile();
        tile.cacheUnseen();
        unit.setLocation(colony);
        unit.setMovesLeft(0);
        colony.equipForRole(unit, spec.getDefaultRole(), 0);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        for (Tile t : CollectionUtils.transform(tile.getSurroundingTiles(1, colony.getRadius()), t2 -> t2.getOwningSettlement() == colony && !ownedTiles.contains(t2))) {
            cs.add(ChangeSet.See.perhaps(), t);
        }
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet learnFromIndianSettlement(ServerPlayer serverPlayer, ServerUnit sUnit, IndianSettlement is) {
        Specification spec = this.getGame().getSpecification();
        UnitType skill = is.getLearnableSkill();
        if (skill == null) {
            return serverPlayer.clientError("No skill to learn at " + is.getName());
        }
        if (sUnit.getUnitChange("model.unitChange.natives", skill) == null) {
            return serverPlayer.clientError("Unit " + sUnit + " can not learn skill " + skill + " at " + is.getName());
        }
        ChangeSet cs = new ChangeSet();
        sUnit.setMovesLeft(0);
        Location loc = sUnit.getLocation();
        switch (is.getAlarm(serverPlayer).getLevel()) {
            case HATEFUL: {
                cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)loc));
                sUnit.csRemove(ChangeSet.See.perhaps().always(serverPlayer), loc, cs);
                serverPlayer.invalidateCanSeeTiles();
                break;
            }
            case ANGRY: {
                cs.addPartial(ChangeSet.See.only(serverPlayer), sUnit, "movesLeft", String.valueOf(sUnit.getMovesLeft()));
                break;
            }
            default: {
                sUnit.changeType(skill);
                serverPlayer.invalidateCanSeeTiles();
                cs.add(ChangeSet.See.perhaps(), sUnit);
                if (is.isCapital() || is.hasMissionary(serverPlayer) && spec.getBoolean("model.option.enhancedMissionaries")) break;
                is.setLearnableSkill(null);
            }
        }
        Tile tile = is.getTile();
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet loadGoods(ServerPlayer serverPlayer, Location loc, GoodsType goodsType, int amount, Unit carrier) {
        Unit dst;
        if (carrier.getLoadableAmount(goodsType) < amount) {
            return serverPlayer.clientError("Too much goods");
        }
        if (loc instanceof Europe) {
            if (carrier.isInEurope()) {
                return this.buyGoods(serverPlayer, goodsType, amount, carrier);
            }
            return serverPlayer.clientError("Carrier not in Europe: " + loc);
        }
        if (!(loc instanceof GoodsLocation)) {
            return serverPlayer.clientError("Not a goods location: " + loc);
        }
        GoodsLocation gl = (GoodsLocation)loc;
        if (!carrier.isAtLocation(loc)) {
            return serverPlayer.clientError("Carrier not at location: " + loc);
        }
        if (gl.getGoodsCount(goodsType) < amount) {
            return serverPlayer.clientError("Not enough goods (" + gl.getGoodsCount(goodsType) + " < " + amount + " " + goodsType.getSuffix() + ") at " + gl);
        }
        ChangeSet cs = new ChangeSet();
        GoodsLocation.moveGoods(gl, goodsType, amount, carrier);
        logger.finest(Messages.message(loc.getLocationLabel()) + " loaded " + amount + " " + goodsType.getSuffix() + " onto " + carrier);
        cs.add(ChangeSet.See.only(serverPlayer), gl.getGoodsContainer());
        cs.add(ChangeSet.See.only(serverPlayer), carrier.getGoodsContainer());
        if (carrier.getInitialMovesLeft() != carrier.getMovesLeft()) {
            carrier.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), carrier, "movesLeft", String.valueOf(carrier.getMovesLeft()));
        }
        if (gl instanceof Unit && (dst = (Unit)gl).getInitialMovesLeft() != dst.getMovesLeft()) {
            dst.setMovesLeft(0);
            cs.addPartial(ChangeSet.See.only(serverPlayer), dst, "movesLeft", String.valueOf(dst.getMovesLeft()));
        }
        return cs;
    }

    public ChangeSet lootCargo(ServerPlayer serverPlayer, Unit winner, String loserId, List<Goods> loot) {
        LootSession session = Session.lookup(LootSession.class, winner.getId(), loserId);
        if (session == null) {
            return serverPlayer.clientError("Bogus looting!");
        }
        if (!winner.hasSpaceLeft()) {
            return serverPlayer.clientError("No space to loot to: " + winner.getId());
        }
        ChangeSet cs = new ChangeSet();
        List<Goods> available = session.getCapture();
        if (loot == null) {
            cs.add(ChangeSet.See.only(serverPlayer), new LootCargoMessage(winner, loserId, available));
        } else {
            for (Goods g : loot) {
                if (!available.contains(g)) {
                    return serverPlayer.clientError("Invalid loot: " + g);
                }
                available.remove(g);
                if (!winner.canAdd(g)) {
                    return serverPlayer.clientError("Loot failed: " + g);
                }
                winner.add(g);
            }
            session.complete(cs);
            cs.add(ChangeSet.See.perhaps(), winner);
            this.getGame().sendToOthers(serverPlayer, cs);
        }
        return cs;
    }

    public ChangeSet monarchAction(ServerPlayer serverPlayer, Monarch.MonarchAction action, boolean result) {
        MonarchSession session = Session.lookup(MonarchSession.class, serverPlayer.getId(), "");
        if (session == null) {
            return serverPlayer.clientError("Bogus monarch action: " + action);
        }
        if (action != session.getAction()) {
            return serverPlayer.clientError("Session action mismatch, " + session.getAction() + " expected: " + action);
        }
        ChangeSet cs = new ChangeSet();
        session.complete(result, cs);
        return cs;
    }

    public ChangeSet move(ServerPlayer serverPlayer, ServerUnit unit, Tile newTile) {
        ChangeSet cs = new ChangeSet();
        unit.csMove(newTile, this.random, cs);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet moveTo(ServerPlayer serverPlayer, Unit unit, Location destination) {
        ChangeSet cs = new ChangeSet();
        HighSeas highSeas = serverPlayer.getHighSeas();
        Location current = unit.getDestination();
        List<Location> destinations = highSeas.getDestinations();
        boolean others = false;
        boolean invalid = false;
        if (!unit.getType().canMoveToHighSeas()) {
            invalid = true;
        } else if (destination instanceof Europe) {
            if (!destinations.contains(destination)) {
                return serverPlayer.clientError("HighSeas does not connect to: " + destination.getId() + " in " + highSeas.destinationsToString());
            }
            if (unit.getLocation() == highSeas) {
                if (!(current instanceof Europe)) {
                    unit.setWorkLeft(unit.getSailTurns() - unit.getWorkLeft() + 1);
                }
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), unit, highSeas);
            } else if (unit.hasTile()) {
                Tile tile = unit.getTile();
                unit.setEntryLocation(tile);
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                serverPlayer.invalidateCanSeeTiles();
                cs.addDisappear(serverPlayer, tile, unit);
                cs.add(ChangeSet.See.only(serverPlayer), tile, highSeas);
                others = true;
            } else {
                invalid = true;
            }
            boolean hasMap = false;
            for (Location dest : destinations) {
                if (!(dest instanceof Map)) continue;
                hasMap = true;
                break;
            }
            if (!hasMap) {
                Map map = this.getGame().getMap();
                destinations.add(map);
            }
        } else if (destination instanceof Map) {
            if (!destinations.contains(destination)) {
                return serverPlayer.clientError("HighSeas does not connect to: " + destination.getId() + " in " + highSeas.destinationsToString());
            }
            if (unit.getLocation() == highSeas) {
                if (current != destination && (current == null || current.getTile() == null || current.getTile().getMap() != destination)) {
                    unit.setWorkLeft(unit.getSailTurns() - unit.getWorkLeft() + 1);
                }
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), highSeas);
            } else if (unit.getLocation() instanceof Europe) {
                Europe europe = (Europe)unit.getLocation();
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                cs.add(ChangeSet.See.only(serverPlayer), europe, highSeas);
            } else {
                invalid = true;
            }
        } else if (destination instanceof Settlement) {
            Tile tile = destination.getTile();
            if (!destinations.contains(tile.getMap())) {
                return serverPlayer.clientError("HighSeas does not connect to: " + destination.getId() + "/" + tile.getMap().getId() + " in " + highSeas.destinationsToString());
            }
            if (unit.getLocation() == highSeas) {
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                cs.add(ChangeSet.See.only(serverPlayer), highSeas);
            } else if (unit.getLocation() instanceof Europe) {
                Europe europe = (Europe)unit.getLocation();
                unit.setWorkLeft(unit.getSailTurns());
                unit.setDestination(destination);
                unit.setMovesLeft(0);
                unit.setLocation(highSeas);
                cs.add(ChangeSet.See.only(serverPlayer), europe, highSeas);
            } else {
                invalid = true;
            }
        } else {
            return serverPlayer.clientError("Bogus moveTo destination: " + destination.getId());
        }
        if (invalid) {
            return serverPlayer.clientError("Invalid moveTo: unit=" + unit.getId() + " from=" + unit.getLocation().getId() + " to=" + destination.getId());
        }
        if (others) {
            this.getGame().sendToOthers(serverPlayer, cs);
        }
        return cs;
    }

    public ChangeSet nationSummary(ServerPlayer serverPlayer, Player player) {
        return ChangeSet.simpleChange(serverPlayer, (Message)new NationSummaryMessage(player, new NationSummary(player, serverPlayer)));
    }

    public ChangeSet nativeFirstContact(ServerPlayer serverPlayer, Player other, Tile tile, boolean result) {
        ChangeSet cs = new ChangeSet();
        DiplomacySession session = null;
        if (tile != null) {
            Unit u = tile.getFirstUnit();
            Settlement s = tile.getOwningSettlement();
            if (u != null && s != null) {
                session = DiplomacySession.findContactSession(u, s);
            }
        }
        if (result) {
            if (tile != null) {
                if (session == null) {
                    return serverPlayer.clientError("No diplomacy for: " + tile.getId());
                }
                tile.cacheUnseen();
                tile.changeOwnership(serverPlayer, null);
                cs.add(ChangeSet.See.perhaps(), tile);
            }
        } else {
            ((ServerPlayer)other).csModifyTension(serverPlayer, 300, cs);
            ((ServerPlayer)other).addMissionBan(serverPlayer);
        }
        if (session != null) {
            session.completeFirstContact(cs);
        }
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet nativeGift(ServerPlayer serverPlayer, Unit unit, Colony colony) {
        Goods goods = CollectionUtils.first(unit.getGoodsList());
        if (goods == null) {
            return serverPlayer.clientError("No gift to deliver: " + unit.getId());
        }
        Player otherPlayer = colony.getOwner();
        ChangeSet cs = new ChangeSet();
        GoodsLocation.moveGoods(unit, goods.getType(), goods.getAmount(), colony);
        cs.add(ChangeSet.See.perhaps(), unit);
        ModelMessage m = (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.GIFT_GOODS, "deliverGift.goods", colony, goods.getType()).addStringTemplate("%player%", serverPlayer.getNationLabel())).addNamed("%type%", goods)).addAmount("%amount%", goods.getAmount())).addName("%settlement%", colony.getName());
        cs.addMessage(otherPlayer, m);
        cs.add(ChangeSet.See.only(otherPlayer), colony);
        logger.info("Gift delivered by unit: " + unit.getId() + " to colony " + colony.getName() + ": " + goods);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public ChangeSet nativeTrade(ServerPlayer serverPlayer, NativeTrade.NativeTradeAction action, NativeTrade nt) {
        ServerUnit unit = (ServerUnit)nt.getUnit();
        IndianSettlement is = nt.getIndianSettlement();
        Player otherPlayer = serverPlayer.owns(unit) ? is.getOwner() : unit.getOwner();
        NativeTradeSession session = Session.lookup(NativeTradeSession.class, unit, is);
        if (action.isEuropean() != serverPlayer.isEuropean()) {
            return serverPlayer.clientError((action.isEuropean() ? "European" : "Native") + " player expected for " + action + ": " + serverPlayer.getSuffix());
        }
        if (action == NativeTrade.NativeTradeAction.OPEN && session != null) {
            return serverPlayer.clientError("Session already open for: " + nt);
        }
        if (action != NativeTrade.NativeTradeAction.OPEN && session == null) {
            return serverPlayer.clientError("No session found for: " + nt);
        }
        ChangeSet cs = new ChangeSet();
        switch (action) {
            case OPEN: {
                if (unit.getMovesLeft() <= 0) {
                    return serverPlayer.clientError("Unit " + unit.getId() + " has no moves left.");
                }
                nt = NativeTradeSession.openSession(nt);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                break;
            }
            case CLOSE: {
                session.complete(cs);
                break;
            }
            case BUY: {
                NativeTradeItem item = nt.getItem();
                nt.mergeFrom(session.getNativeTrade());
                if (item == null) {
                    return serverPlayer.clientError("Null purchase: " + nt);
                }
                if (!nt.canBuy()) {
                    return serverPlayer.clientError("Can not buy: " + nt);
                }
                if (CollectionUtils.find(nt.getSettlementToUnit(), item.goodsMatcher()) == null) {
                    return serverPlayer.clientError("Item missing for " + action + ": " + nt);
                }
                if (!serverPlayer.checkGold(item.getPrice())) {
                    return serverPlayer.clientError("Player can not afford item: " + nt);
                }
                nt.setItem(item);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                break;
            }
            case SELL: {
                NativeTradeItem item = nt.getItem();
                nt.mergeFrom(session.getNativeTrade());
                if (item == null) {
                    return serverPlayer.clientError("Null sale: " + nt);
                }
                if (item.priceIsSet() && !nt.canSell()) {
                    return serverPlayer.clientError("Can not sell: " + nt);
                }
                if (CollectionUtils.find(nt.getUnitToSettlement(), item.goodsMatcher()) == null) {
                    return serverPlayer.clientError("Item missing for " + action + ": " + nt);
                }
                nt.setItem(item);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                break;
            }
            case GIFT: {
                NativeTradeItem item = nt.getItem();
                nt.mergeFrom(session.getNativeTrade());
                if (item == null) {
                    return serverPlayer.clientError("Null gift: " + nt);
                }
                if (!nt.canGift()) {
                    return serverPlayer.clientError("Can not gift: " + nt);
                }
                if (CollectionUtils.find(nt.getUnitToSettlement(), item.goodsMatcher()) == null) {
                    return serverPlayer.clientError("Item missing for " + action + ": " + nt);
                }
                nt.setItem(item);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                break;
            }
            case ACK_OPEN: {
                session.getNativeTrade().mergeFrom(nt);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                unit.setMovesLeft(0);
                cs.addPartial(ChangeSet.See.only(otherPlayer), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
                break;
            }
            case ACK_BUY_HAGGLE: 
            case ACK_SELL_HAGGLE: 
            case NAK_GOODS: {
                session.getNativeTrade().mergeFrom(nt);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                break;
            }
            case ACK_BUY: {
                NativeTradeItem item = nt.getItem();
                this.csBuy(unit, item.getGoods(), item.getPrice(), (ServerIndianSettlement)is, cs);
                nt.setBuy(false);
                nt.addToUnit(item);
                session.getNativeTrade().mergeFrom(nt);
                session.getNativeTrade().setBuy(false);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                break;
            }
            case ACK_SELL: {
                NativeTradeItem item = nt.getItem();
                this.csSell(unit, item.getGoods(), item.getPrice(), (ServerIndianSettlement)is, cs);
                nt.setSell(false);
                nt.removeFromUnit(item);
                session.getNativeTrade().mergeFrom(nt);
                session.getNativeTrade().setSell(false);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                break;
            }
            case ACK_GIFT: {
                NativeTradeItem item = nt.getItem();
                this.csGift(unit, item.getGoods(), item.getPrice(), (ServerIndianSettlement)is, cs);
                nt.setGift(false);
                nt.removeFromUnit(item);
                session.getNativeTrade().mergeFrom(nt);
                session.getNativeTrade().setGift(false);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                break;
            }
            case NAK_HAGGLE: 
            case NAK_NOSALE: {
                unit.setMovesLeft(0);
                cs.addPartial(ChangeSet.See.only(otherPlayer), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
            }
            case NAK_INVALID: 
            case NAK_HOSTILE: {
                session.getNativeTrade().mergeFrom(nt);
                cs.add(ChangeSet.See.only(otherPlayer), new NativeTradeMessage(action, nt));
                session.complete(cs);
                break;
            }
            default: {
                return serverPlayer.clientError("Bogus action: " + action);
            }
        }
        logger.fine("Native trade(" + StringUtils.downCase(action.toString()) + ": " + nt);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet newTradeRoute(ServerPlayer serverPlayer) {
        return ChangeSet.simpleChange(serverPlayer, (Message)new NewTradeRouteMessage(serverPlayer.newTradeRoute()));
    }

    public ChangeSet payArrears(ServerPlayer serverPlayer, GoodsType type) {
        int arrears = serverPlayer.getArrears(type);
        if (arrears <= 0) {
            return serverPlayer.clientError("No arrears for pay for: " + type.getId());
        }
        if (!serverPlayer.checkGold(arrears)) {
            return serverPlayer.clientError("Not enough gold to pay arrears for: " + type.getId());
        }
        ChangeSet cs = new ChangeSet();
        Market market = serverPlayer.getMarket();
        serverPlayer.modifyGold(-arrears);
        market.setArrears(type, 0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()));
        cs.add(ChangeSet.See.only(serverPlayer), market.getMarketData(type));
        return cs;
    }

    public ChangeSet payForBuilding(ServerPlayer serverPlayer, Colony colony) {
        if (!this.getGame().getSpecification().getBoolean("model.option.payForBuilding")) {
            return serverPlayer.clientError("Pay for building is disabled");
        }
        BuildableType build = colony.getCurrentlyBuilding();
        if (build == null) {
            return serverPlayer.clientError("Colony " + colony.getId() + " is not building anything!");
        }
        List<AbstractGoods> required = colony.getRequiredGoods(build);
        int price = colony.priceGoodsForBuilding(required);
        if (!serverPlayer.checkGold(price)) {
            return serverPlayer.clientError("Insufficient funds to pay for build.");
        }
        int savedGold = serverPlayer.modifyGold(-price);
        serverPlayer.modifyGold(price);
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = colony.getGoodsContainer();
        container.saveState();
        for (AbstractGoods ag : required) {
            GoodsType type = ag.getType();
            int amount = ag.getAmount();
            if (type.isStorable()) {
                if ((amount = serverPlayer.buyInEurope(this.random, container, type, amount)) < 0) {
                    return serverPlayer.clientError("Can not buy " + amount + " " + type + " for " + build);
                }
                serverPlayer.csFlushMarket(type, cs);
                continue;
            }
            container.addGoods(type, amount);
        }
        colony.invalidateCache();
        serverPlayer.setGold(savedGold);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()));
        cs.add(ChangeSet.See.only(serverPlayer), container);
        return cs;
    }

    public ChangeSet putOutsideColony(ServerPlayer serverPlayer, Unit unit) {
        Tile tile = unit.getTile();
        Colony colony = unit.getColony();
        if (unit.isInColony()) {
            tile.cacheUnseen();
        }
        unit.setLocation(tile);
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.add(ChangeSet.See.perhaps().except(serverPlayer), colony);
        return cs;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public ChangeSet rearrangeColony(ServerPlayer serverPlayer, Colony colony, List<RearrangeColonyMessage.Arrangement> arrangements) {
        Role defaultRole = this.getGame().getSpecification().getDefaultRole();
        Tile tile = colony.getTile();
        tile.cacheUnseen();
        for (RearrangeColonyMessage.Arrangement a2 : arrangements) {
            a2.unit.setLocation(tile);
            if (a2.unit.hasDefaultRole()) continue;
            colony.equipForRole(a2.unit, defaultRole, 0);
        }
        ArrayList<RearrangeColonyMessage.Arrangement> todo = new ArrayList<RearrangeColonyMessage.Arrangement>(arrangements);
        block6: while (!todo.isEmpty()) {
            RearrangeColonyMessage.Arrangement a2 = (RearrangeColonyMessage.Arrangement)todo.remove(0);
            if (a2.loc == tile) continue;
            WorkLocation wl = (WorkLocation)a2.loc;
            switch (wl.getNoAddReason(a2.unit)) {
                case NONE: {
                    a2.unit.setLocation(wl);
                }
                case ALREADY_PRESENT: {
                    if (a2.unit.getWorkType() == a2.work) continue block6;
                    a2.unit.changeWorkType(a2.work);
                    continue block6;
                }
                case CAPACITY_EXCEEDED: {
                    todo.add(todo.size(), a2);
                    continue block6;
                }
            }
            logger.warning("Bad move for " + a2.unit + " to " + wl);
        }
        for (RearrangeColonyMessage.Arrangement a3 : CollectionUtils.transform(arrangements, a -> a.role != defaultRole && a.role != a.unit.getRole(), Function.identity(), RearrangeColonyMessage.Arrangement::roleComparison)) {
            if (colony.equipForRole(a3.unit, a3.role, a3.roleCount)) continue;
            return serverPlayer.clientError("Failed to equip " + a3.unit.getId() + " for role " + a3.role + " at " + colony);
        }
        return new ChangeSet().add(ChangeSet.See.perhaps(), tile);
    }

    public ChangeSet renameObject(ServerPlayer serverPlayer, Nameable object, String newName) {
        ChangeSet cs = new ChangeSet();
        if (object instanceof Settlement) {
            ((Settlement)object).getTile().cacheUnseen();
        }
        object.setName(newName);
        FreeColGameObject fcgo = (FreeColGameObject)((Object)object);
        cs.addPartial(ChangeSet.See.all(), fcgo, "name", newName);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet retire(ServerPlayer serverPlayer) {
        boolean highScore = HighScore.newHighScore(serverPlayer);
        ChangeSet cs = new ChangeSet();
        serverPlayer.csWithdraw(cs, null, null);
        this.getGame().sendToOthers(serverPlayer, cs);
        cs.addAttribute(ChangeSet.See.only(serverPlayer), "highScore", Boolean.toString(highScore));
        return cs;
    }

    public ChangeSet scoutIndianSettlement(ServerPlayer serverPlayer, ServerUnit unit, IndianSettlement is) {
        Player owner = is.getOwner();
        ChangeSet cs = new ChangeSet();
        Tile tile = is.getTile();
        tile.updateIndianSettlement(serverPlayer);
        cs.add(ChangeSet.See.only(serverPlayer), tile);
        cs.add(ChangeSet.See.only(serverPlayer), new NationSummaryMessage(owner, new NationSummary(owner, serverPlayer)));
        return cs;
    }

    public ChangeSet scoutSpeakToChief(ServerPlayer serverPlayer, ServerUnit sUnit, IndianSettlement is) {
        String result;
        ChangeSet cs = new ChangeSet();
        Tile tile = is.getTile();
        boolean tileDirty = is.setVisited(serverPlayer);
        Tension tension = is.getAlarm(serverPlayer);
        if (tension.getLevel() == Tension.Level.HATEFUL) {
            Location loc = sUnit.getLocation();
            cs.add(ChangeSet.See.perhaps().always(serverPlayer), (FreeColGameObject)((Object)loc));
            sUnit.csRemove(ChangeSet.See.perhaps().always(serverPlayer), loc, cs);
            serverPlayer.invalidateCanSeeTiles();
            result = "die";
        } else {
            List<UnitType> scoutTypes = this.getGame().getSpecification().getUnitTypesWithAbility("model.ability.expertScout");
            UnitType scoutSkill = CollectionUtils.first(scoutTypes);
            int radius = sUnit.getLineOfSight();
            UnitType skill = is.getLearnableSkill();
            int rnd = RandomUtils.randomInt(logger, "scouting", this.random, 10);
            if (is.hasAnyScouted()) {
                result = "nothing";
            } else if (scoutSkill != null && sUnit.getType() != scoutSkill && (skill != null && skill.hasAbility("model.ability.expertScout") || rnd == 0)) {
                sUnit.changeType(scoutSkill);
                serverPlayer.invalidateCanSeeTiles();
                result = "expert";
            } else {
                int gold;
                RandomRange gifts = is.getType().getGifts();
                int n = gold = gifts == null ? 0 : gifts.getAmount("Base beads amount", this.random, true);
                if (gold <= 0 || rnd <= 3) {
                    radius = Math.max(radius, 6);
                    result = "tales";
                } else {
                    if (sUnit.hasAbility("model.ability.expertScout")) {
                        gold = gold * 11 / 10;
                    }
                    serverPlayer.modifyGold(gold);
                    is.getOwner().modifyGold(-gold);
                    result = Integer.toString(gold);
                    cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()), "score", String.valueOf(serverPlayer.getScore()));
                }
            }
            sUnit.csVisit(serverPlayer, is, 1, cs);
            tileDirty = true;
            Set tiles = CollectionUtils.transform(tile.getSurroundingTiles(1, radius), t -> !serverPlayer.canSee((Tile)t) && (t.isLand() || t.isShore()), Function.identity(), Collectors.toSet());
            cs.add(ChangeSet.See.only(serverPlayer), serverPlayer.exploreTiles(tiles));
            sUnit.setMovesLeft(0);
            if ("expert".equals(result)) {
                cs.add(ChangeSet.See.perhaps(), sUnit);
            } else {
                cs.addPartial(ChangeSet.See.only(serverPlayer), sUnit, "movesLeft", String.valueOf(sUnit.getMovesLeft()));
            }
        }
        if (tileDirty) {
            tile.updateIndianSettlement(serverPlayer);
            cs.add(ChangeSet.See.only(serverPlayer), tile);
        }
        cs.add(ChangeSet.See.only(serverPlayer), new ScoutSpeakToChiefMessage(sUnit, is, result));
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    private ChangeSet sellGoods(ServerPlayer serverPlayer, GoodsType type, int amount, Unit carrier) {
        ChangeSet cs = new ChangeSet();
        GoodsContainer container = carrier.getGoodsContainer();
        container.saveState();
        if (serverPlayer.canTrade(type, Market.Access.EUROPE)) {
            int gold = serverPlayer.getGold();
            int sellAmount = serverPlayer.sellInEurope(this.random, container, type, amount);
            if (sellAmount < 0) {
                return serverPlayer.clientError("Player " + serverPlayer.getName() + " tried to sell " + amount + " " + type.getSuffix());
            }
            serverPlayer.csFlushMarket(type, cs);
            cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()));
            logger.finest(carrier + " sold " + amount + "(" + sellAmount + ") " + type.getSuffix() + " in Europe for " + (serverPlayer.getGold() - gold));
        } else {
            GoodsLocation.moveGoods(carrier, type, amount, null);
            logger.finest(carrier + " dumped " + amount + " " + type.getSuffix() + " in Europe");
        }
        carrier.setMovesLeft(0);
        cs.add(ChangeSet.See.only(serverPlayer), carrier);
        return cs;
    }

    public ChangeSet setBuildQueue(ServerPlayer serverPlayer, Colony colony, List<BuildableType> queue) {
        BuildableType current = colony.getCurrentlyBuilding();
        colony.setBuildQueue(queue);
        if (this.getGame().getSpecification().getBoolean("model.option.clearHammersOnConstructionSwitch") && current != null && current != colony.getCurrentlyBuilding()) {
            for (AbstractGoods ag : CollectionUtils.transform(current.getRequiredGoods(), g -> !g.getType().isStorable())) {
                colony.removeGoods(ag.getType());
            }
        }
        colony.invalidateCache();
        ChangeSet cs = new ChangeSet();
        cs.add(ChangeSet.See.only(serverPlayer), colony);
        return cs;
    }

    public ChangeSet setCurrentStop(ServerPlayer serverPlayer, Unit unit, int index) {
        TradeRoute tr = unit.getTradeRoute();
        if (tr == null) {
            return serverPlayer.clientError("Unit has no trade route to set stop for.");
        }
        if (index < 0 || index >= tr.getStopCount()) {
            return serverPlayer.clientError("Stop index out of range [0.." + tr.getStopCount() + "]: " + index);
        }
        unit.setCurrentStop(index);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit);
    }

    public ChangeSet setDestination(ServerPlayer serverPlayer, Unit unit, Location destination) {
        if (unit.getTradeRoute() != null) {
            if (destination == null && unit.isAtSea()) {
                destination = unit.getStop().getLocation();
            }
            unit.setTradeRoute(null);
        }
        unit.setDestination(destination);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), unit);
    }

    public ChangeSet setGoodsLevels(ServerPlayer serverPlayer, Colony colony, ExportData exportData) {
        colony.setExportData(exportData);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), colony);
    }

    public ChangeSet setNewLandName(ServerPlayer serverPlayer, Unit unit, String name) {
        ChangeSet cs = new ChangeSet();
        serverPlayer.setNewLandName(name);
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "newLandName", name);
        Turn turn = serverPlayer.getGame().getTurn();
        HistoryEvent h = (HistoryEvent)new HistoryEvent(turn, HistoryEvent.HistoryEventType.DISCOVER_NEW_WORLD, serverPlayer).addName("%name%", name);
        cs.addHistory(serverPlayer, h);
        return cs;
    }

    public ChangeSet setNewRegionName(ServerPlayer serverPlayer, Unit unit, Region region, String name) {
        ServerGame game = this.getGame();
        ServerRegion serverRegion = (ServerRegion)region;
        if (!Utils.equals(region.getDiscoverer(), unit.getId())) {
            return serverPlayer.clientError("Discoverer mismatch, " + region.getDiscoverer() + " expected, " + unit.getId() + " provided.");
        }
        ChangeSet cs = new ChangeSet();
        serverRegion.csDiscover(serverPlayer, unit, game.getTurn(), name, cs);
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }

    public ChangeSet spySettlement(ServerPlayer serverPlayer, Unit unit, Settlement settlement) {
        ChangeSet cs = new ChangeSet();
        logger.info("Spy settlement for " + unit.getId() + " at " + settlement.getId() + "(" + settlement.getName() + ")");
        cs.addSpy(unit, settlement);
        unit.setMovesLeft(0);
        cs.addPartial(ChangeSet.See.only(serverPlayer), unit, "movesLeft", String.valueOf(unit.getMovesLeft()));
        return cs;
    }

    public ChangeSet trainUnitInEurope(ServerPlayer serverPlayer, UnitType type) {
        Europe europe = serverPlayer.getEurope();
        if (europe == null) {
            return serverPlayer.clientError("No Europe to train in.");
        }
        int price = europe.getUnitPrice(type);
        if (price <= 0) {
            return serverPlayer.clientError("Bogus price: " + price);
        }
        if (!serverPlayer.checkGold(price)) {
            return serverPlayer.clientError("Not enough gold (" + serverPlayer.getGold() + " < " + price + ") to train " + type);
        }
        if (!type.isAvailableTo(serverPlayer)) {
            return serverPlayer.clientError("Unit type is not available for the player.");
        }
        ServerGame game = this.getGame();
        Specification spec = game.getSpecification();
        Role role = spec.getBoolean("model.option.equipEuropeanRecruits") ? type.getDefaultRole() : spec.getDefaultRole();
        ServerUnit unit = new ServerUnit(game, europe, serverPlayer, type, role);
        unit.setName(serverPlayer.getNameForUnit(type, this.random));
        serverPlayer.modifyGold(-price);
        ((ServerEurope)europe).increasePrice(type, price);
        ChangeSet cs = new ChangeSet();
        cs.addPartial(ChangeSet.See.only(serverPlayer), serverPlayer, "gold", String.valueOf(serverPlayer.getGold()));
        cs.add(ChangeSet.See.only(serverPlayer), europe);
        return cs;
    }

    public ChangeSet unloadGoods(ServerPlayer serverPlayer, GoodsType goodsType, int amount, Unit carrier) {
        if (carrier.getGoodsCount(goodsType) < amount) {
            return serverPlayer.clientError("Too few goods");
        }
        if (carrier.isInEurope()) {
            return this.sellGoods(serverPlayer, goodsType, amount, carrier);
        }
        ChangeSet cs = new ChangeSet();
        Settlement settlement = carrier.getSettlement();
        if (settlement != null) {
            GoodsLocation.moveGoods(carrier, goodsType, amount, settlement);
            logger.finest(carrier + " unloaded " + amount + " " + goodsType.getSuffix() + " to " + settlement.getName());
            cs.add(ChangeSet.See.only(serverPlayer), settlement.getGoodsContainer());
            cs.add(ChangeSet.See.only(serverPlayer), carrier.getGoodsContainer());
            if (carrier.getInitialMovesLeft() != carrier.getMovesLeft()) {
                carrier.setMovesLeft(0);
                cs.addPartial(ChangeSet.See.only(serverPlayer), carrier, "movesLeft", String.valueOf(carrier.getMovesLeft()));
            }
        } else {
            GoodsLocation.moveGoods(carrier, goodsType, amount, null);
            logger.finest(carrier + " dumped " + amount + " " + goodsType.getSuffix() + " to " + carrier.getLocation());
            cs.add(ChangeSet.See.perhaps(), (FreeColGameObject)((Object)carrier.getLocation()));
            this.getGame().sendToOthers(serverPlayer, cs);
        }
        return cs;
    }

    public ChangeSet updateTradeRoute(ServerPlayer serverPlayer, TradeRoute tradeRoute) {
        String name;
        ServerGame game = this.getGame();
        if (tradeRoute == null || tradeRoute.getId() == null || (name = tradeRoute.getName()) == null) {
            return serverPlayer.clientError("Bogus route");
        }
        StringTemplate fail = tradeRoute.verify();
        if (fail != null) {
            return serverPlayer.clientError(Messages.message(fail));
        }
        TradeRoute tr = game.getFreeColGameObject(tradeRoute.getId(), TradeRoute.class);
        if (tr == null) {
            return serverPlayer.clientError("Not an existing trade route: " + tradeRoute.getId());
        }
        tr.copyIn(tradeRoute);
        return new ChangeSet().add(ChangeSet.See.only(serverPlayer), tr);
    }

    public ChangeSet work(ServerPlayer serverPlayer, Unit unit, WorkLocation workLocation) {
        Specification spec = this.getGame().getSpecification();
        Colony colony = workLocation.getColony();
        colony.getGoodsContainer().saveState();
        ChangeSet cs = new ChangeSet();
        Tile tile = workLocation.getWorkTile();
        if (tile != null && tile.getOwningSettlement() != colony) {
            serverPlayer.csClaimLand(tile, colony, 0, cs);
        }
        colony.equipForRole(unit, spec.getDefaultRole(), 0);
        UnitTypeChange uc = unit.getUnitChange("model.unitChange.enterColony");
        if (uc != null && uc.appliesTo(unit)) {
            unit.changeType(uc.to);
        }
        if (!unit.isInColony()) {
            unit.getColony().getTile().cacheUnseen();
        }
        unit.setLocation(workLocation);
        cs.add(ChangeSet.See.perhaps(), colony.getTile());
        this.getGame().sendToOthers(serverPlayer, cs);
        return cs;
    }
}

