/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.Platform;
import org.jetbrains.kotlin.konan.target.PlatformManager;
import org.jetbrains.kotlin.konan.target.TargetManager;
import org.jetbrains.kotlin.konan.util.SubstitutionKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\"H&J\u0006\u0010$\u001a\u00020\"R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/konan/target/AbstractToolConfig;", "", "konanHome", "", "userProvidedTargetName", "propertyOverrides", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "distribution", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "host", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "libclang", "getLibclang", "()Ljava/lang/String;", "llvmHome", "getLlvmHome", "platform", "Lorg/jetbrains/kotlin/konan/target/Platform;", "getPlatform", "()Lorg/jetbrains/kotlin/konan/target/Platform;", "platformManager", "Lorg/jetbrains/kotlin/konan/target/PlatformManager;", "substitutions", "getSubstitutions", "()Ljava/util/Map;", "sysRoot", "getSysRoot", "target", "getTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "targetManager", "Lorg/jetbrains/kotlin/konan/target/TargetManager;", "downloadDependencies", "", "loadLibclang", "prepare", "kotlin-native-utils"})
public abstract class AbstractToolConfig {
    private final Distribution distribution;
    private final PlatformManager platformManager;
    private final TargetManager targetManager;
    private final KonanTarget host;
    @NotNull
    private final KonanTarget target;
    @NotNull
    private final Platform platform;
    @NotNull
    private final Map<String, String> substitutions;
    @NotNull
    private final String llvmHome;
    @NotNull
    private final String sysRoot;
    @NotNull
    private final String libclang;

    @NotNull
    public final KonanTarget getTarget() {
        return this.target;
    }

    @NotNull
    protected final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final Map<String, String> getSubstitutions() {
        return this.substitutions;
    }

    public final void downloadDependencies() {
        this.platform.downloadDependencies();
    }

    @NotNull
    public final String getLlvmHome() {
        return this.llvmHome;
    }

    @NotNull
    public final String getSysRoot() {
        return this.sysRoot;
    }

    @NotNull
    public final String getLibclang() {
        return this.libclang;
    }

    public abstract void loadLibclang();

    public final void prepare() {
        this.downloadDependencies();
        this.loadLibclang();
    }

    public AbstractToolConfig(@NotNull String konanHome2, @Nullable String userProvidedTargetName, @NotNull Map<String, String> propertyOverrides2) {
        Intrinsics.checkNotNullParameter((Object)konanHome2, (String)"konanHome");
        Intrinsics.checkNotNullParameter(propertyOverrides2, (String)"propertyOverrides");
        this.distribution = new Distribution(konanHome2, false, null, propertyOverrides2, 6, null);
        this.platformManager = new PlatformManager(this.distribution, false, 2, null);
        this.targetManager = this.platformManager.targetManager(userProvidedTargetName);
        this.host = HostManager.Companion.getHost();
        this.target = this.targetManager.getTarget();
        this.platform = this.platformManager.platform(this.target);
        this.substitutions = SubstitutionKt.defaultTargetSubstitutions(this.target);
        this.llvmHome = this.platform.getAbsoluteLlvmHome();
        this.sysRoot = this.platform.getAbsoluteTargetSysRoot();
        KonanTarget konanTarget = this.host;
        this.libclang = Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE) ? this.llvmHome + "/bin/libclang.dll" : this.llvmHome + "/lib/" + System.mapLibraryName("clang");
    }
}

