/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.message;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.AttributeFactory;
import org.ice4j.attribute.ChangedAddressAttribute;
import org.ice4j.attribute.ChannelNumberAttribute;
import org.ice4j.attribute.ConnectionIdAttribute;
import org.ice4j.attribute.DataAttribute;
import org.ice4j.attribute.DestinationAddressAttribute;
import org.ice4j.attribute.ErrorCodeAttribute;
import org.ice4j.attribute.IceControlledAttribute;
import org.ice4j.attribute.IceControllingAttribute;
import org.ice4j.attribute.LifetimeAttribute;
import org.ice4j.attribute.MagicCookieAttribute;
import org.ice4j.attribute.MappedAddressAttribute;
import org.ice4j.attribute.MessageIntegrityAttribute;
import org.ice4j.attribute.NonceAttribute;
import org.ice4j.attribute.PriorityAttribute;
import org.ice4j.attribute.RealmAttribute;
import org.ice4j.attribute.ReservationTokenAttribute;
import org.ice4j.attribute.SourceAddressAttribute;
import org.ice4j.attribute.UnknownAttributesAttribute;
import org.ice4j.attribute.UsernameAttribute;
import org.ice4j.attribute.XorMappedAddressAttribute;
import org.ice4j.attribute.XorPeerAddressAttribute;
import org.ice4j.attribute.XorRelayedAddressAttribute;
import org.ice4j.message.Indication;
import org.ice4j.message.Request;
import org.ice4j.message.Response;

public class MessageFactory {
    private static final Logger logger = Logger.getLogger(MessageFactory.class.getName());

    public static Request createBindingRequest() {
        Request bindingRequest = new Request();
        try {
            bindingRequest.setMessageType('\u0001');
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return bindingRequest;
    }

    public static Request createBindingRequest(long priority) throws StunException {
        Request bindingRequest = MessageFactory.createBindingRequest();
        PriorityAttribute attribute = AttributeFactory.createPriorityAttribute(priority);
        bindingRequest.putAttribute(attribute);
        return bindingRequest;
    }

    public static Request createBindingRequest(long priority, boolean controlling, long tieBreaker) throws StunException {
        Request bindingRequest = MessageFactory.createBindingRequest();
        PriorityAttribute attribute = AttributeFactory.createPriorityAttribute(priority);
        bindingRequest.putAttribute(attribute);
        if (controlling) {
            IceControllingAttribute iceControllingAttribute = AttributeFactory.createIceControllingAttribute(tieBreaker);
            bindingRequest.putAttribute(iceControllingAttribute);
        } else {
            IceControlledAttribute iceControlledAttribute = AttributeFactory.createIceControlledAttribute(tieBreaker);
            bindingRequest.putAttribute(iceControlledAttribute);
        }
        return bindingRequest;
    }

    public static Response create3489BindingResponse(TransportAddress mappedAddress, TransportAddress sourceAddress, TransportAddress changedAddress) throws IllegalArgumentException {
        Response bindingResponse = new Response();
        bindingResponse.setMessageType('\u0101');
        MappedAddressAttribute mappedAddressAttribute = AttributeFactory.createMappedAddressAttribute(mappedAddress);
        SourceAddressAttribute sourceAddressAttribute = null;
        if (sourceAddress != null) {
            sourceAddressAttribute = AttributeFactory.createSourceAddressAttribute(sourceAddress);
        }
        ChangedAddressAttribute changedAddressAttribute = null;
        if (changedAddress != null) {
            changedAddressAttribute = AttributeFactory.createChangedAddressAttribute(changedAddress);
        }
        bindingResponse.putAttribute(mappedAddressAttribute);
        if (sourceAddressAttribute != null) {
            bindingResponse.putAttribute(sourceAddressAttribute);
        }
        if (changedAddressAttribute != null) {
            bindingResponse.putAttribute(changedAddressAttribute);
        }
        return bindingResponse;
    }

    public static Response createBindingResponse(Request request, TransportAddress mappedAddress) throws IllegalArgumentException {
        Response bindingResponse = new Response();
        bindingResponse.setMessageType('\u0101');
        XorMappedAddressAttribute xorMappedAddressAttribute = AttributeFactory.createXorMappedAddressAttribute(mappedAddress, request.getTransactionID());
        bindingResponse.putAttribute(xorMappedAddressAttribute);
        return bindingResponse;
    }

    public static Response createBindingErrorResponse(char errorCode, String reasonPhrase, char[] unknownAttributes) throws IllegalArgumentException {
        Response bindingErrorResponse = new Response();
        bindingErrorResponse.setMessageType('\u0111');
        UnknownAttributesAttribute unknownAttributesAttribute = null;
        ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        bindingErrorResponse.putAttribute(errorCodeAttribute);
        if (unknownAttributes != null) {
            unknownAttributesAttribute = AttributeFactory.createUnknownAttributesAttribute();
            for (int i = 0; i < unknownAttributes.length; ++i) {
                unknownAttributesAttribute.addAttributeID(unknownAttributes[i]);
            }
            bindingErrorResponse.putAttribute(unknownAttributesAttribute);
        }
        return bindingErrorResponse;
    }

    public static Response createBindingErrorResponseUnknownAttributes(char[] unknownAttributes) throws StunException {
        return MessageFactory.createBindingErrorResponse('\u01a4', null, unknownAttributes);
    }

    public static Response createBindingErrorResponseUnknownAttributes(String reasonPhrase, char[] unknownAttributes) throws StunException {
        return MessageFactory.createBindingErrorResponse('\u01a4', reasonPhrase, unknownAttributes);
    }

    public static Response createBindingErrorResponse(char errorCode, String reasonPhrase) {
        return MessageFactory.createBindingErrorResponse(errorCode, reasonPhrase, null);
    }

    public static Response createBindingErrorResponse(char errorCode) {
        return MessageFactory.createBindingErrorResponse(errorCode, null, null);
    }

    public static Indication createBindingIndication() {
        Indication bindingIndication = new Indication();
        bindingIndication.setMessageType('\u0011');
        return bindingIndication;
    }

    public static Request createAllocateRequest() {
        Request allocateRequest = new Request();
        try {
            allocateRequest.setMessageType('\u0003');
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return allocateRequest;
    }

    public static Request createAllocateRequest(byte protocol, boolean rFlag) {
        Request allocateRequest = new Request();
        try {
            allocateRequest.setMessageType('\u0003');
            if (protocol != 6 && protocol != 17) {
                throw new StunException("Protocol not valid!");
            }
            allocateRequest.putAttribute(AttributeFactory.createRequestedTransportAttribute(protocol));
            if (rFlag) {
                allocateRequest.putAttribute(AttributeFactory.createEvenPortAttribute(rFlag));
            }
        }
        catch (StunException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return allocateRequest;
    }

    public static Response createAllocationResponse(Request request, TransportAddress mappedAddress, TransportAddress relayedAddress, int lifetime) throws IllegalArgumentException {
        return MessageFactory.createAllocationResponse(request, mappedAddress, relayedAddress, null, lifetime);
    }

    public static Response createAllocationResponse(Request request, TransportAddress mappedAddress, TransportAddress relayedAddress, byte[] token, int lifetime) throws IllegalArgumentException {
        Response allocationSuccessResponse = new Response();
        allocationSuccessResponse.setMessageType('\u0103');
        XorMappedAddressAttribute xorMappedAddressAttribute = AttributeFactory.createXorMappedAddressAttribute(mappedAddress, request.getTransactionID());
        allocationSuccessResponse.putAttribute(xorMappedAddressAttribute);
        XorRelayedAddressAttribute xorRelayedAddressAttribute = AttributeFactory.createXorRelayedAddressAttribute(relayedAddress, request.getTransactionID());
        allocationSuccessResponse.putAttribute(xorRelayedAddressAttribute);
        LifetimeAttribute lifetimeAttribute = AttributeFactory.createLifetimeAttribute(lifetime);
        allocationSuccessResponse.putAttribute(lifetimeAttribute);
        if (token != null) {
            ReservationTokenAttribute reservationTokenAttribute = AttributeFactory.createReservationTokenAttribute(token);
            allocationSuccessResponse.putAttribute(reservationTokenAttribute);
        }
        return allocationSuccessResponse;
    }

    public static Response createAllocationErrorResponse(char errorCode) {
        return MessageFactory.createAllocationErrorResponse(errorCode, null);
    }

    public static Response createAllocationErrorResponse(char errorCode, String reasonPhrase) {
        Response allocationErrorResponse = new Response();
        allocationErrorResponse.setMessageType('\u0113');
        ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        allocationErrorResponse.putAttribute(errorCodeAttribute);
        return allocationErrorResponse;
    }

    public static Request createGoogleAllocateRequest(String username) {
        Request allocateRequest = new Request();
        UsernameAttribute usernameAttr = AttributeFactory.createUsernameAttribute(username);
        MagicCookieAttribute magicCookieAttr = AttributeFactory.createMagicCookieAttribute();
        allocateRequest.setMessageType('\u0003');
        allocateRequest.putAttribute(magicCookieAttr);
        allocateRequest.putAttribute(usernameAttr);
        return allocateRequest;
    }

    public static void addLongTermCredentialAttributes(Request request, byte[] username, byte[] realm, byte[] nonce) throws StunException {
        MessageIntegrityAttribute messageIntegrityAttribute;
        UsernameAttribute usernameAttribute = AttributeFactory.createUsernameAttribute(username);
        RealmAttribute realmAttribute = AttributeFactory.createRealmAttribute(realm);
        NonceAttribute nonceAttribute = AttributeFactory.createNonceAttribute(nonce);
        request.putAttribute(usernameAttribute);
        request.putAttribute(realmAttribute);
        request.putAttribute(nonceAttribute);
        try {
            messageIntegrityAttribute = AttributeFactory.createMessageIntegrityAttribute(new String(username, "UTF-8"));
        }
        catch (UnsupportedEncodingException ueex) {
            throw new StunException("username", ueex);
        }
        request.putAttribute(messageIntegrityAttribute);
    }

    public static Request createRefreshRequest() {
        Request refreshRequest = new Request();
        try {
            refreshRequest.setMessageType('\u0004');
        }
        catch (IllegalArgumentException iaex) {
            logger.log(Level.FINE, "Failed to set message type.", iaex);
        }
        return refreshRequest;
    }

    public static Request createRefreshRequest(int lifetime) {
        Request refreshRequest = new Request();
        try {
            refreshRequest.setMessageType('\u0004');
            LifetimeAttribute lifetimeReq = AttributeFactory.createLifetimeAttribute(lifetime);
            refreshRequest.putAttribute(lifetimeReq);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return refreshRequest;
    }

    public static Response createRefreshResponse(int lifetime) {
        Response refreshSuccessResponse = new Response();
        try {
            refreshSuccessResponse.setMessageType('\u0104');
            LifetimeAttribute lifetimeAttribute = AttributeFactory.createLifetimeAttribute(lifetime);
            refreshSuccessResponse.putAttribute(lifetimeAttribute);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return refreshSuccessResponse;
    }

    public static Response createRefreshErrorResponse(char errorCode) {
        return MessageFactory.createRefreshErrorResponse(errorCode, null);
    }

    public static Response createRefreshErrorResponse(char errorCode, String reasonPhrase) {
        Response refreshErrorResponse = new Response();
        try {
            refreshErrorResponse.setMessageType('\u0114');
            ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
            refreshErrorResponse.putAttribute(errorCodeAttribute);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return refreshErrorResponse;
    }

    public static Request createChannelBindRequest(char channelNumber, TransportAddress peerAddress, byte[] tranID) {
        Request channelBindRequest = new Request();
        try {
            channelBindRequest.setMessageType('\t');
            ChannelNumberAttribute channelNumberAttribute = AttributeFactory.createChannelNumberAttribute(channelNumber);
            channelBindRequest.putAttribute(channelNumberAttribute);
            XorPeerAddressAttribute peerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, tranID);
            channelBindRequest.putAttribute(peerAddressAttribute);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return channelBindRequest;
    }

    public static Response createChannelBindResponse() {
        Response channelBindSuccessResponse = new Response();
        channelBindSuccessResponse.setMessageType('\u0109');
        return channelBindSuccessResponse;
    }

    public static Response createChannelBindErrorResponse(char errorCode) {
        return MessageFactory.createChannelBindErrorResponse(errorCode, null);
    }

    public static Response createChannelBindErrorResponse(char errorCode, String reasonPhrase) {
        Response channelBindErrorResponse = new Response();
        channelBindErrorResponse.setMessageType('\u0119');
        ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        channelBindErrorResponse.putAttribute(errorCodeAttribute);
        return channelBindErrorResponse;
    }

    public static Request createCreatePermissionRequest(TransportAddress peerAddress, byte[] transactionID) {
        Request createPermissionRequest = new Request();
        try {
            createPermissionRequest.setMessageType('\b');
        }
        catch (IllegalArgumentException iaex) {
            logger.log(Level.FINE, "Failed to set message type.", iaex);
        }
        createPermissionRequest.putAttribute(AttributeFactory.createXorPeerAddressAttribute(peerAddress, transactionID));
        return createPermissionRequest;
    }

    public static Response createCreatePermissionResponse() {
        Response permissionSuccessResponse = new Response();
        permissionSuccessResponse.setMessageType('\u0108');
        return permissionSuccessResponse;
    }

    public static Response createCreatePermissionErrorResponse(char errorCode) {
        return MessageFactory.createPermissionErrorResponse(errorCode, null);
    }

    public static Response createPermissionErrorResponse(char errorCode, String reasonPhrase) {
        Response createPermissionErrorResponse = new Response();
        createPermissionErrorResponse.setMessageType('\u0118');
        ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        createPermissionErrorResponse.putAttribute(errorCodeAttribute);
        return createPermissionErrorResponse;
    }

    public static Indication createSendIndication(TransportAddress peerAddress, byte[] data2, byte[] tranID) {
        Indication sendIndication = new Indication();
        try {
            sendIndication.setMessageType('\u0016');
            XorPeerAddressAttribute peerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, tranID);
            sendIndication.putAttribute(peerAddressAttribute);
            if (data2 != null && data2.length > 0) {
                DataAttribute dataAttribute = AttributeFactory.createDataAttribute(data2);
                sendIndication.putAttribute(dataAttribute);
            }
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return sendIndication;
    }

    public static Indication createDataIndication(TransportAddress peerAddress, byte[] data2, byte[] tranID) {
        Indication dataIndication = new Indication();
        try {
            dataIndication.setMessageType('\u0017');
            XorPeerAddressAttribute peerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, tranID);
            dataIndication.putAttribute(peerAddressAttribute);
            if (data2 != null && data2.length > 0) {
                DataAttribute dataAttribute = AttributeFactory.createDataAttribute(data2);
                dataIndication.putAttribute(dataAttribute);
            }
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return dataIndication;
    }

    public static Request createSendRequest(String username, TransportAddress peerAddress, byte[] data2) {
        Request sendRequest = new Request();
        try {
            sendRequest.setMessageType('\u0004');
            sendRequest.putAttribute(AttributeFactory.createMagicCookieAttribute());
            sendRequest.putAttribute(AttributeFactory.createUsernameAttribute(username));
            DestinationAddressAttribute peerAddressAttribute = AttributeFactory.createDestinationAddressAttribute(peerAddress);
            sendRequest.putAttribute(peerAddressAttribute);
            if (data2 != null && data2.length > 0) {
                DataAttribute dataAttribute = AttributeFactory.createDataAttributeWithoutPadding(data2);
                sendRequest.putAttribute(dataAttribute);
            }
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Failed to set message type.", ex);
        }
        return sendRequest;
    }

    public static Request createSharedSecretRequest() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently implemented");
    }

    public static Response createSharedSecretResponse() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently implemented");
    }

    public static Response createSharedSecretErrorResponse() {
        throw new UnsupportedOperationException("Shared Secret Support is not currently implemented");
    }

    public static Request createConnectRequest(TransportAddress peerAddress, Request request) throws IllegalArgumentException {
        Request connectRequest = new Request();
        connectRequest.setMessageType('\n');
        XorPeerAddressAttribute xorPeerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, request.getTransactionID());
        connectRequest.putAttribute(xorPeerAddressAttribute);
        return connectRequest;
    }

    public static Request createConnectRequest(TransportAddress peerAddress, byte[] transactionId) throws IllegalArgumentException {
        Request connectRequest = new Request();
        connectRequest.setMessageType('\n');
        XorPeerAddressAttribute xorPeerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, transactionId);
        connectRequest.putAttribute(xorPeerAddressAttribute);
        return connectRequest;
    }

    public static Response createConnectResponse(int connectionIdValue) throws IllegalArgumentException {
        Response connectSuccessResponse = new Response();
        connectSuccessResponse.setMessageType('\u010a');
        ConnectionIdAttribute connectionIdAttribute = AttributeFactory.createConnectionIdAttribute(connectionIdValue);
        connectSuccessResponse.putAttribute(connectionIdAttribute);
        return connectSuccessResponse;
    }

    public static Response createConnectErrorResponse(char errorCode) throws IllegalArgumentException {
        return MessageFactory.createConnectErrorResponse(errorCode, null);
    }

    public static Response createConnectErrorResponse(char errorCode, String reasonPhrase) throws IllegalArgumentException {
        Response connectionErrorResponse = new Response();
        connectionErrorResponse.setMessageType('\u011a');
        ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        connectionErrorResponse.putAttribute(errorCodeAttribute);
        return connectionErrorResponse;
    }

    public static Request createConnectionBindRequest(int connectionIdValue) throws IllegalArgumentException {
        Request connectionBindRequest = new Request();
        connectionBindRequest.setMessageType('\u000b');
        ConnectionIdAttribute connectionIdAttribute = AttributeFactory.createConnectionIdAttribute(connectionIdValue);
        connectionBindRequest.putAttribute(connectionIdAttribute);
        return connectionBindRequest;
    }

    public static Response createConnectionBindResponse() throws IllegalArgumentException {
        Response connectSuccessResponse = new Response();
        connectSuccessResponse.setMessageType('\u010b');
        return connectSuccessResponse;
    }

    public static Response createConnectionBindErrorResponse(char errorCode) throws IllegalArgumentException {
        return MessageFactory.createConnectionBindErrorResponse(errorCode, null);
    }

    public static Response createConnectionBindErrorResponse(char errorCode, String reasonPhrase) throws IllegalArgumentException {
        Response connectionBindErrorResponse = new Response();
        connectionBindErrorResponse.setMessageType('\u011b');
        ErrorCodeAttribute errorCodeAttribute = AttributeFactory.createErrorCodeAttribute(errorCode, reasonPhrase);
        connectionBindErrorResponse.putAttribute(errorCodeAttribute);
        return connectionBindErrorResponse;
    }

    public static Indication createConnectionAttemptIndication(int connectionIdValue, TransportAddress peerAddress) throws IllegalArgumentException {
        Indication connectionAttemptIndication = new Indication();
        connectionAttemptIndication.setMessageType('\u001c');
        ConnectionIdAttribute connectionIdAttribute = AttributeFactory.createConnectionIdAttribute(connectionIdValue);
        connectionAttemptIndication.putAttribute(connectionIdAttribute);
        XorPeerAddressAttribute xorPeerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, connectionAttemptIndication.getTransactionID());
        connectionAttemptIndication.putAttribute(xorPeerAddressAttribute);
        return connectionAttemptIndication;
    }

    public static Indication createConnectionAttemptIndication(int connectionIdValue, TransportAddress peerAddress, byte[] transactionId) throws IllegalArgumentException, StunException {
        Indication connectionAttemptIndication = new Indication();
        connectionAttemptIndication.setTransactionID(transactionId);
        connectionAttemptIndication.setMessageType('\u001c');
        ConnectionIdAttribute connectionIdAttribute = AttributeFactory.createConnectionIdAttribute(connectionIdValue);
        connectionAttemptIndication.putAttribute(connectionIdAttribute);
        XorPeerAddressAttribute xorPeerAddressAttribute = AttributeFactory.createXorPeerAddressAttribute(peerAddress, connectionAttemptIndication.getTransactionID());
        connectionAttemptIndication.putAttribute(xorPeerAddressAttribute);
        return connectionAttemptIndication;
    }
}

