/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Throwables;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.indices.InvalidIndexNameException;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public class MLSearchHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(MLSearchHandler.class);
    private final Client client;
    private NamedXContentRegistry xContentRegistry;
    private ModelAccessControlHelper modelAccessControlHelper;
    private ClusterService clusterService;

    public MLSearchHandler(Client client, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper, ClusterService clusterService) {
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
    }

    public void search(SearchRequest request, ActionListener<SearchResponse> actionListener) {
        User user = RestActionUtils.getUserContext(this.client);
        ActionListener<SearchResponse> listener = MLSearchHandler.wrapRestActionListener(actionListener, "Fail to search model version");
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> context.restore());
            List excludes = Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::excludes).map(x -> Arrays.stream(x).collect(Collectors.toList())).orElse(new ArrayList());
            excludes.add("connector.credential");
            FetchSourceContext rebuiltFetchSourceContext = new FetchSourceContext(Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::fetchSource).orElse(true).booleanValue(), (String[])Optional.ofNullable(request.source()).map(SearchSourceBuilder::fetchSource).map(FetchSourceContext::includes).orElse(null), excludes.toArray(new String[0]));
            request.source().fetchSource(rebuiltFetchSourceContext);
            if (this.modelAccessControlHelper.skipModelAccessControl(user)) {
                this.client.search(request, wrappedListener);
            } else if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-model-group")) {
                this.client.search(request, wrappedListener);
            } else {
                SearchSourceBuilder sourceBuilder = this.modelAccessControlHelper.createSearchSourceBuilder(user);
                SearchRequest modelGroupSearchRequest = new SearchRequest();
                sourceBuilder.fetchSource(new String[]{"model_group_id"}, null);
                sourceBuilder.size(10000);
                modelGroupSearchRequest.source(sourceBuilder);
                modelGroupSearchRequest.indices(new String[]{".plugins-ml-model-group"});
                ActionListener modelGroupSearchActionListener = ActionListener.wrap(r -> {
                    if (Optional.ofNullable(r).map(SearchResponse::getHits).map(SearchHits::getTotalHits).map(x -> x.value).orElse(0L) > 0L) {
                        ArrayList<String> modelGroupIds = new ArrayList<String>();
                        Arrays.stream(r.getHits().getHits()).forEach(hit -> modelGroupIds.add(hit.getId()));
                        request.source().query(this.rewriteQueryBuilder(request.source().query(), modelGroupIds));
                        this.client.search(request, wrappedListener);
                    } else {
                        log.debug("No model group found");
                        request.source().query(this.rewriteQueryBuilder(request.source().query(), null));
                        this.client.search(request, wrappedListener);
                    }
                }, e -> {
                    log.error("Fail to search model groups!", (Throwable)e);
                    wrappedListener.onFailure(e);
                });
                this.client.search(modelGroupSearchRequest, modelGroupSearchActionListener);
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    private QueryBuilder rewriteQueryBuilder(QueryBuilder queryBuilder, List<String> modelGroupIds) {
        ExistsQueryBuilder existsQueryBuilder = new ExistsQueryBuilder("model_group_id");
        BoolQueryBuilder modelGroupIdMustNotExistBoolQuery = new BoolQueryBuilder();
        modelGroupIdMustNotExistBoolQuery.mustNot((QueryBuilder)existsQueryBuilder);
        BoolQueryBuilder accessControlledBoolQuery = new BoolQueryBuilder();
        if (!CollectionUtils.isEmpty(modelGroupIds)) {
            TermsQueryBuilder modelGroupIdTermsQuery = new TermsQueryBuilder("model_group_id", modelGroupIds);
            accessControlledBoolQuery.should((QueryBuilder)modelGroupIdTermsQuery);
        }
        accessControlledBoolQuery.should((QueryBuilder)modelGroupIdMustNotExistBoolQuery);
        if (queryBuilder == null) {
            return accessControlledBoolQuery;
        }
        if (queryBuilder instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)queryBuilder).must((QueryBuilder)accessControlledBoolQuery);
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must(queryBuilder);
        boolQueryBuilder.must((QueryBuilder)modelGroupIdMustNotExistBoolQuery);
        return boolQueryBuilder;
    }

    public static <T> ActionListener<T> wrapRestActionListener(ActionListener<T> actionListener, String generalErrorMessage) {
        return ActionListener.wrap(r -> actionListener.onResponse(r), e -> {
            log.error("Wrap exception before sending back to user", (Throwable)e);
            Throwable cause = Throwables.getRootCause((Throwable)e);
            if (MLSearchHandler.isProperExceptionToReturn(e)) {
                actionListener.onFailure(e);
            } else if (MLSearchHandler.isProperExceptionToReturn(cause)) {
                actionListener.onFailure((Exception)cause);
            } else {
                RestStatus status = MLSearchHandler.isBadRequest(e) ? RestStatus.BAD_REQUEST : RestStatus.INTERNAL_SERVER_ERROR;
                String errorMessage = generalErrorMessage;
                if (MLSearchHandler.isBadRequest(e) || e instanceof MLException) {
                    errorMessage = e.getMessage();
                } else if (MLSearchHandler.isBadRequest(cause) || cause instanceof MLException) {
                    errorMessage = cause.getMessage();
                }
                actionListener.onFailure((Exception)new OpenSearchStatusException(errorMessage, status, new Object[0]));
            }
        });
    }

    public static boolean isProperExceptionToReturn(Throwable e) {
        return e instanceof OpenSearchStatusException || e instanceof IndexNotFoundException || e instanceof InvalidIndexNameException;
    }

    public static boolean isBadRequest(Throwable e) {
        return e instanceof IllegalArgumentException || e instanceof MLResourceNotFoundException;
    }
}

