/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.Diffable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public final class DiffableUtils {
    private DiffableUtils() {
    }

    public static KeySerializer<String> getStringKeySerializer() {
        return StringKeySerializer.INSTANCE;
    }

    public static KeySerializer<Integer> getIntKeySerializer() {
        return IntKeySerializer.INSTANCE;
    }

    public static KeySerializer<Integer> getVIntKeySerializer() {
        return VIntKeySerializer.INSTANCE;
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, Map<K, T>> diff(Map<K, T> before, Map<K, T> after, KeySerializer<K> keySerializer) {
        assert (after != null && before != null);
        return new JdkMapDiff<K, T>(before, after, keySerializer, DiffableValueSerializer.getWriteOnlyInstance());
    }

    public static <K, T> MapDiff<K, T, Map<K, T>> diff(Map<K, T> before, Map<K, T> after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
        assert (after != null && before != null);
        return new JdkMapDiff<K, T>(before, after, keySerializer, valueSerializer);
    }

    public static <K, T> MapDiff<K, T, Map<K, T>> readJdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
        return new JdkMapDiff<K, T>(in, keySerializer, valueSerializer);
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, Map<K, T>> readJdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, Writeable.Reader<T> reader, Writeable.Reader<Diff<T>> diffReader) throws IOException {
        return new JdkMapDiff<K, T>(in, keySerializer, new DiffableValueReader(reader, diffReader));
    }

    private static final class StringKeySerializer
    implements KeySerializer<String> {
        private static final StringKeySerializer INSTANCE = new StringKeySerializer();

        private StringKeySerializer() {
        }

        @Override
        public void writeKey(String key, StreamOutput out) throws IOException {
            out.writeString(key);
        }

        @Override
        public String readKey(StreamInput in) throws IOException {
            return in.readString();
        }
    }

    private static final class IntKeySerializer
    implements KeySerializer<Integer> {
        public static final IntKeySerializer INSTANCE = new IntKeySerializer();

        private IntKeySerializer() {
        }

        @Override
        public void writeKey(Integer key, StreamOutput out) throws IOException {
            out.writeInt(key.intValue());
        }

        @Override
        public Integer readKey(StreamInput in) throws IOException {
            return in.readInt();
        }
    }

    private static final class VIntKeySerializer
    implements KeySerializer<Integer> {
        public static final IntKeySerializer INSTANCE = new IntKeySerializer();

        private VIntKeySerializer() {
        }

        @Override
        public void writeKey(Integer key, StreamOutput out) throws IOException {
            if (key < 0) {
                throw new IllegalArgumentException("Map key [" + key + "] must be positive");
            }
            out.writeVInt(key.intValue());
        }

        @Override
        public Integer readKey(StreamInput in) throws IOException {
            return in.readVInt();
        }
    }

    private static class JdkMapDiff<K, T>
    extends MapDiff<K, T, Map<K, T>> {
        protected JdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
            super(in, keySerializer, valueSerializer);
        }

        JdkMapDiff(Map<K, T> before, Map<K, T> after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
            super(keySerializer, valueSerializer);
            assert (after != null && before != null);
            for (K k : before.keySet()) {
                if (after.containsKey(k)) continue;
                this.deletes.add(k);
            }
            for (Map.Entry entry : after.entrySet()) {
                T beforePart = before.get(entry.getKey());
                if (beforePart == null) {
                    this.upserts.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getValue().equals(beforePart)) continue;
                if (valueSerializer.supportsDiffableValues()) {
                    this.diffs.put(entry.getKey(), valueSerializer.diff(entry.getValue(), beforePart));
                    continue;
                }
                this.upserts.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Map<K, T> apply(Map<K, T> map) {
            HashMap builder = new HashMap(map);
            for (Object e : this.deletes) {
                builder.remove(e);
            }
            for (Map.Entry entry : this.diffs.entrySet()) {
                builder.put(entry.getKey(), ((Diff)entry.getValue()).apply(builder.get(entry.getKey())));
            }
            for (Map.Entry entry : this.upserts.entrySet()) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return builder;
        }
    }

    public static abstract class DiffableValueSerializer<K, V extends Diffable<V>>
    implements ValueSerializer<K, V> {
        private static final DiffableValueSerializer WRITE_ONLY_INSTANCE = new DiffableValueSerializer(){

            @Override
            public Object read(StreamInput in, Object key) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Diff<Object> readDiff(StreamInput in, Object key) throws IOException {
                throw new UnsupportedOperationException();
            }
        };

        private static <K, V extends Diffable<V>> DiffableValueSerializer<K, V> getWriteOnlyInstance() {
            return WRITE_ONLY_INSTANCE;
        }

        @Override
        public boolean supportsDiffableValues() {
            return true;
        }

        @Override
        public Diff<V> diff(V value, V beforePart) {
            return value.diff(beforePart);
        }

        @Override
        public void write(V value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }

        @Override
        public void writeDiff(Diff<V> value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }
    }

    public static interface KeySerializer<K> {
        public void writeKey(K var1, StreamOutput var2) throws IOException;

        public K readKey(StreamInput var1) throws IOException;
    }

    public static interface ValueSerializer<K, V> {
        public void write(V var1, StreamOutput var2) throws IOException;

        public V read(StreamInput var1, K var2) throws IOException;

        public boolean supportsDiffableValues();

        default public boolean supportsVersion(Diff<V> value, Version version) {
            return true;
        }

        default public boolean supportsVersion(V value, Version version) {
            return true;
        }

        public Diff<V> diff(V var1, V var2);

        public void writeDiff(Diff<V> var1, StreamOutput var2) throws IOException;

        public Diff<V> readDiff(StreamInput var1, K var2) throws IOException;
    }

    public static class DiffableValueReader<K, V extends Diffable<V>>
    extends DiffableValueSerializer<K, V> {
        private final Writeable.Reader<V> reader;
        private final Writeable.Reader<Diff<V>> diffReader;

        public DiffableValueReader(Writeable.Reader<V> reader, Writeable.Reader<Diff<V>> diffReader) {
            this.reader = reader;
            this.diffReader = diffReader;
        }

        @Override
        public V read(StreamInput in, K key) throws IOException {
            return (V)((Diffable)this.reader.read(in));
        }

        @Override
        public Diff<V> readDiff(StreamInput in, K key) throws IOException {
            return (Diff)this.diffReader.read(in);
        }
    }

    public static class StringSetValueSerializer<K>
    extends NonDiffableValueSerializer<K, Set<String>> {
        private static final StringSetValueSerializer INSTANCE = new StringSetValueSerializer();

        public static <K> StringSetValueSerializer<K> getInstance() {
            return INSTANCE;
        }

        @Override
        public void write(Set<String> value, StreamOutput out) throws IOException {
            out.writeStringCollection(value);
        }

        @Override
        public Set<String> read(StreamInput in, K key) throws IOException {
            return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(in.readStringArray())));
        }
    }

    public static abstract class NonDiffableValueSerializer<K, V>
    implements ValueSerializer<K, V> {
        @Override
        public boolean supportsDiffableValues() {
            return false;
        }

        @Override
        public Diff<V> diff(V value, V beforePart) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDiff(Diff<V> value, StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Diff<V> readDiff(StreamInput in, K key) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class MapDiff<K, T, M>
    implements Diff<M> {
        protected final List<K> deletes;
        protected final Map<K, Diff<T>> diffs;
        protected final Map<K, T> upserts;
        protected final KeySerializer<K> keySerializer;
        protected final ValueSerializer<K, T> valueSerializer;

        protected MapDiff(KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = new ArrayList<K>();
            this.diffs = new HashMap<K, Diff<T>>();
            this.upserts = new HashMap<K, T>();
        }

        protected MapDiff(KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer, List<K> deletes, Map<K, Diff<T>> diffs, Map<K, T> upserts) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = deletes;
            this.diffs = diffs;
            this.upserts = upserts;
        }

        protected MapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = in.readList(keySerializer::readKey);
            int diffsCount = in.readVInt();
            this.diffs = diffsCount == 0 ? Collections.emptyMap() : new HashMap(diffsCount);
            for (int i = 0; i < diffsCount; ++i) {
                K key = keySerializer.readKey(in);
                Diff<T> diff = valueSerializer.readDiff(in, key);
                this.diffs.put(key, diff);
            }
            int upsertsCount = in.readVInt();
            this.upserts = upsertsCount == 0 ? Collections.emptyMap() : new HashMap(upsertsCount);
            for (int i = 0; i < upsertsCount; ++i) {
                K key = keySerializer.readKey(in);
                T newValue = valueSerializer.read(in, key);
                this.upserts.put(key, newValue);
            }
        }

        public List<K> getDeletes() {
            return this.deletes;
        }

        public Map<K, Diff<T>> getDiffs() {
            return this.diffs;
        }

        public Map<K, T> getUpserts() {
            return this.upserts;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.deletes, (o, v) -> this.keySerializer.writeKey(v, o));
            Version version = out.getVersion();
            int diffCount = 0;
            for (Diff<T> diff : this.diffs.values()) {
                if (!this.valueSerializer.supportsVersion((T)diff, version)) continue;
                ++diffCount;
            }
            out.writeVInt(diffCount);
            for (Map.Entry entry : this.diffs.entrySet()) {
                if (!this.valueSerializer.supportsVersion((T)((Diff)entry.getValue()), version)) continue;
                this.keySerializer.writeKey(entry.getKey(), out);
                this.valueSerializer.writeDiff((Diff)entry.getValue(), out);
            }
            int upsertsCount = 0;
            for (T t : this.upserts.values()) {
                if (!this.valueSerializer.supportsVersion(t, version)) continue;
                ++upsertsCount;
            }
            out.writeVInt(upsertsCount);
            for (Map.Entry<K, T> entry : this.upserts.entrySet()) {
                if (!this.valueSerializer.supportsVersion(entry.getValue(), version)) continue;
                this.keySerializer.writeKey(entry.getKey(), out);
                this.valueSerializer.write(entry.getValue(), out);
            }
        }
    }
}

