/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.configs;

import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class HeapSizeIncreasePolicyConfig {
    private static final String POLICY_NAME = "heap-size-increase-policy";
    public static final int DEFAULT_UNHEALTHY_NODE_PERCENTAGE = 50;
    public static final int DEFAULT_MIN_UNHEALTHY_MINUTES = 2880;
    private static final int DEFAULT_DAY_BREACH_THRESHOLD = 8;
    private static final int DEFAULT_WEEK_BREACH_THRESHOLD = 3;
    private final int unhealthyNodePercentage;
    private final int dayBreachThreshold;
    private final int weekBreachThreshold;

    public HeapSizeIncreasePolicyConfig(RcaConf rcaConf) {
        this.unhealthyNodePercentage = rcaConf.readRcaConfig(POLICY_NAME, HeapSizeIncreasePolicyKeys.UNHEALTHY_NODE_PERCENTAGE_KEY.toString(), 50, Integer.class);
        this.dayBreachThreshold = rcaConf.readRcaConfig(POLICY_NAME, HeapSizeIncreasePolicyKeys.DAY_BREACH_THRESHOLD_KEY.toString(), 8, Integer.class);
        this.weekBreachThreshold = rcaConf.readRcaConfig(POLICY_NAME, HeapSizeIncreasePolicyKeys.WEEK_BREACH_THRESHOLD_KEY.toString(), 3, Integer.class);
    }

    public int getUnhealthyNodePercentage() {
        return this.unhealthyNodePercentage;
    }

    public int getDayBreachThreshold() {
        return this.dayBreachThreshold;
    }

    public int getWeekBreachThreshold() {
        return this.weekBreachThreshold;
    }

    static enum HeapSizeIncreasePolicyKeys {
        UNHEALTHY_NODE_PERCENTAGE_KEY("unhealthy-node-percentage"),
        DAY_BREACH_THRESHOLD_KEY("day-breach-threshold"),
        WEEK_BREACH_THRESHOLD_KEY("week-breach-threshold");

        private final String value;

        private HeapSizeIncreasePolicyKeys(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

