/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

public class CreateInteractionRequest
extends ActionRequest {
    private String conversationId;
    private String input;
    private String promptTemplate;
    private String response;
    private String origin;
    private String additionalInfo;

    public CreateInteractionRequest(StreamInput in) throws IOException {
        super(in);
        this.conversationId = in.readString();
        this.input = in.readString();
        this.promptTemplate = in.readString();
        this.response = in.readString();
        this.origin = in.readOptionalString();
        this.additionalInfo = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.conversationId);
        out.writeString(this.input);
        out.writeString(this.promptTemplate);
        out.writeString(this.response);
        out.writeOptionalString(this.origin);
        out.writeOptionalString(this.additionalInfo);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.conversationId == null) {
            exception = ValidateActions.addValidationError((String)"Interaction MUST belong to a conversation ID", exception);
        }
        return exception;
    }

    public static CreateInteractionRequest fromRestRequest(RestRequest request) throws IOException {
        Map body = request.contentParser().mapStrings();
        String cid = request.param("conversation_id");
        String inp = (String)body.get("input");
        String prmpt = (String)body.get("prompt_template");
        String rsp = (String)body.get("response");
        String ogn = (String)body.get("origin");
        String addinf = (String)body.get("additional_info");
        return new CreateInteractionRequest(cid, inp, prmpt, rsp, ogn, addinf);
    }

    @Generated
    public CreateInteractionRequest(String conversationId, String input, String promptTemplate, String response, String origin, String additionalInfo) {
        this.conversationId = conversationId;
        this.input = input;
        this.promptTemplate = promptTemplate;
        this.response = response;
        this.origin = origin;
        this.additionalInfo = additionalInfo;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }

    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public String getPromptTemplate() {
        return this.promptTemplate;
    }

    @Generated
    public String getResponse() {
        return this.response;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }
}

