/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.command;

import com.oracle.labs.mlrg.olcut.command.CommandCompleter;
import com.oracle.labs.mlrg.olcut.command.CommandInterface;
import com.oracle.labs.mlrg.olcut.command.CompleterCommandInterface;
import com.oracle.labs.mlrg.olcut.command.LayeredCommandInterpreter;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

class MultiCommandArgumentCompleter
implements Completer {
    private static final Logger logger = Logger.getLogger(MultiCommandArgumentCompleter.class.getName());
    protected final Map<String, CommandInterface> cmdMap;
    protected final Deque<LayeredCommandInterpreter> interpreters;
    protected final Map<String, Completer[]> compMap;
    protected final CommandCompleter commandCompleter;

    public MultiCommandArgumentCompleter(Map<String, CommandInterface> cmdMap, Deque<LayeredCommandInterpreter> interpreters) {
        this.cmdMap = cmdMap;
        this.interpreters = interpreters;
        this.commandCompleter = new CommandCompleter(cmdMap, interpreters);
        this.compMap = new HashMap<String, Completer[]>();
    }

    protected void updateCompleters() {
        logger.log(Level.FINER, "Updating all completers starting at base layer");
        this.updateCompleters(null, this.cmdMap);
        for (LayeredCommandInterpreter lci : this.interpreters) {
            logger.log(Level.FINER, "Updating compls for " + lci.getLayerName());
            this.updateCompleters(lci.getLayerTag(), lci.getCommands());
        }
    }

    protected void updateCompleters(String layerTag, Map<String, CommandInterface> commands) {
        for (Map.Entry<String, CommandInterface> command : commands.entrySet()) {
            Completer[] compToAdd;
            String lCommand = command.getKey();
            if (layerTag != null) {
                lCommand = lCommand + "." + layerTag;
            }
            logger.log(Level.FINER, "Checking for command " + lCommand);
            if (this.compMap.containsKey(lCommand)) continue;
            CommandInterface ci = command.getValue();
            logger.log(Level.FINER, "compMap does not yet contain " + lCommand);
            if (ci instanceof CompleterCommandInterface) {
                logger.log(Level.FINER, "Adding custom completer for " + lCommand);
                CompleterCommandInterface cci = (CompleterCommandInterface)ci;
                compToAdd = cci.getCompleters();
            } else {
                compToAdd = null;
                logger.log(Level.FINER, "Adding with no completer for " + lCommand);
            }
            this.compMap.put(lCommand, compToAdd);
            if (lCommand.equals(command.getKey()) || compToAdd == null) continue;
            if (!this.compMap.containsKey(command.getKey())) {
                logger.log(Level.FINER, "Adding non-qualified name for unambiguous command " + lCommand);
                this.compMap.put(command.getKey(), compToAdd);
                continue;
            }
            Completer[] nonQ = this.compMap.get(command.getKey());
            List qualifieds = this.compMap.keySet().stream().filter(c -> c.startsWith((String)command.getKey() + ".")).collect(Collectors.toList());
            if (qualifieds.stream().filter(c -> this.compMap.get(c) == compToAdd).count() <= 1L) continue;
            logger.log(Level.FINER, "Removing ambiguous non-qualified command " + command.getKey());
            this.compMap.remove(command.getKey());
        }
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        CommandCompleter comp;
        logger.log(Level.FINE, "\ncomplete invoked with " + line.line());
        logger.log(Level.FINE, "Line(wordCursor='" + line.wordCursor() + "',word='" + line.word() + "',wordIndex='" + line.wordIndex() + "',cursor='" + line.cursor() + "'");
        Objects.requireNonNull(line);
        Objects.requireNonNull(candidates);
        if (line.wordIndex() < 0) {
            return;
        }
        this.updateCompleters();
        if (line.wordIndex() == 0) {
            comp = this.commandCompleter;
        } else {
            String wholeBuff = line.line();
            Completer[] completers = this.compMap.get(wholeBuff.substring(0, wholeBuff.indexOf(" ")));
            if (completers == null) {
                logger.log(Level.FINE, "No completers found for #" + wholeBuff.substring(0, wholeBuff.indexOf(" ")) + "#");
                return;
            }
            comp = line.wordIndex() >= completers.length ? completers[completers.length - 1] : completers[line.wordIndex() - 1];
        }
        logger.log(Level.FINE, "evaluating " + line.word() + " with " + ((Object)((Object)comp)).getClass().getSimpleName() + " at " + line.wordCursor());
        comp.complete(reader, line, candidates);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Completing " + line.line() + "(pos=" + line.wordCursor() + ") with: " + candidates.stream().map(Candidate::value).collect(Collectors.joining(", ", "[", "]")));
        }
    }
}

