/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.action.GetFindingsRequest;
import org.opensearch.securityanalytics.action.GetFindingsResponse;
import org.opensearch.securityanalytics.action.SearchDetectorRequest;
import org.opensearch.securityanalytics.findings.FindingsService;
import org.opensearch.securityanalytics.logtype.LogTypeService;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.transport.TransportSearchDetectorAction;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.DetectorUtils;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetFindingsAction
extends HandledTransportAction<GetFindingsRequest, GetFindingsResponse>
implements SecureTransportAction {
    private final TransportSearchDetectorAction transportSearchDetectorAction;
    private final NamedXContentRegistry xContentRegistry;
    private final FindingsService findingsService;
    private final DetectorIndices detectorIndices;
    private final ClusterService clusterService;
    private final Settings settings;
    private final ThreadPool threadPool;
    private final LogTypeService logTypeService;
    private volatile Boolean filterByEnabled;
    private static final Logger log = LogManager.getLogger(TransportGetFindingsAction.class);

    @Inject
    public TransportGetFindingsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, DetectorIndices detectorIndices, Settings settings, TransportSearchDetectorAction transportSearchDetectorAction, NamedXContentRegistry xContentRegistry, Client client, LogTypeService logTypeService) {
        super("cluster:admin/opensearch/securityanalytics/findings/get", transportService, actionFilters, GetFindingsRequest::new);
        this.xContentRegistry = xContentRegistry;
        this.transportSearchDetectorAction = transportSearchDetectorAction;
        this.detectorIndices = detectorIndices;
        this.clusterService = clusterService;
        this.logTypeService = logTypeService;
        this.threadPool = detectorIndices.getThreadPool();
        this.settings = settings;
        this.findingsService = new FindingsService(client);
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, final GetFindingsRequest request, final ActionListener<GetFindingsResponse> actionListener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            actionListener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        if (request.getLogType() == null) {
            this.findingsService.getFindingsByDetectorId(request.getDetectorId(), request.getTable(), actionListener);
        } else {
            NestedQueryBuilder queryBuilder = QueryBuilders.nestedQuery((String)"detector", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"detector.detector_type", (Object)request.getLogType())), (ScoreMode)ScoreMode.None);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)queryBuilder);
            searchSourceBuilder.fetchSource(true);
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.indices(new String[]{".opensearch-sap-detectors-config"});
            searchRequest.source(searchSourceBuilder);
            searchRequest.preference(Preference.PRIMARY_FIRST.type());
            this.transportSearchDetectorAction.execute(new SearchDetectorRequest(searchRequest), (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    try {
                        List<Detector> detectors = DetectorUtils.getDetectors(searchResponse, TransportGetFindingsAction.this.xContentRegistry);
                        if (detectors.size() == 0) {
                            actionListener.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("No detectors found for provided type", RestStatus.NOT_FOUND, new Object[0])));
                            return;
                        }
                        TransportGetFindingsAction.this.findingsService.getFindings(detectors, request.getLogType(), request.getTable(), (ActionListener<GetFindingsResponse>)actionListener);
                    }
                    catch (IOException e) {
                        actionListener.onFailure((Exception)e);
                    }
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

