/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.securityanalytics.action.SearchDetectorRequest;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.DetectorIndices;
import org.opensearch.securityanalytics.util.DetectorUtils;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportSearchDetectorAction
extends HandledTransportAction<SearchDetectorRequest, SearchResponse>
implements SecureTransportAction {
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final DetectorIndices detectorIndices;
    private final Settings settings;
    private final ThreadPool threadPool;
    private volatile Boolean filterByEnabled;
    private static final Logger log = LogManager.getLogger(TransportSearchDetectorAction.class);

    @Inject
    public TransportSearchDetectorAction(TransportService transportService, ClusterService clusterService, DetectorIndices detectorIndices, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, Settings settings, Client client) {
        super("cluster:admin/opensearch/securityanalytics/detector/search", transportService, actionFilters, SearchDetectorRequest::new);
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.detectorIndices = detectorIndices;
        this.clusterService = clusterService;
        this.threadPool = this.detectorIndices.getThreadPool();
        this.settings = settings;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, SearchDetectorRequest searchDetectorRequest, final ActionListener<SearchResponse> actionListener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        if (this.doFilterForUser(user, this.filterByEnabled)) {
            log.info("Filtering result by: {}", (Object)user.getBackendRoles());
            this.addFilter(user, searchDetectorRequest.searchRequest().source(), "detector.user.backend_roles.keyword");
        }
        this.threadPool.getThreadContext().stashContext();
        if (!this.detectorIndices.detectorIndexExists()) {
            actionListener.onResponse((Object)DetectorUtils.getEmptySearchResponse());
            return;
        }
        this.client.search(searchDetectorRequest.searchRequest(), (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                actionListener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

