/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestResponse;

public class SecurityResponse {
    public static final Map<String, String> CONTENT_TYPE_APP_JSON = Map.of("Content-Type", "application/json");
    private final int status;
    private Map<String, List<String>> headers;
    private final String body;
    private final String contentType;

    public SecurityResponse(int status, Exception e) {
        this.status = status;
        this.populateHeaders(CONTENT_TYPE_APP_JSON);
        this.body = this.generateFailureMessage(e);
        this.contentType = XContentType.JSON.mediaType();
    }

    public SecurityResponse(int status, String body) {
        this.status = status;
        this.body = body;
        this.contentType = null;
    }

    public SecurityResponse(int status, Map<String, String> headers, String body) {
        this.status = status;
        this.populateHeaders(headers);
        this.body = body;
        this.contentType = null;
    }

    public SecurityResponse(int status, Map<String, String> headers, String body, String contentType) {
        this.status = status;
        this.body = body;
        this.contentType = contentType;
        this.populateHeaders(headers);
    }

    private void populateHeaders(Map<String, String> headers) {
        if (headers != null) {
            headers.entrySet().forEach(entry -> this.addHeader((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    public void addHeader(String name, String value) {
        List<String> header;
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>(2);
        }
        if ((header = this.headers.get(name)) == null) {
            header = new ArrayList<String>();
            this.headers.put(name, header);
        }
        header.add(value);
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public RestResponse asRestResponse() {
        BytesRestResponse restResponse = this.contentType != null ? new BytesRestResponse(RestStatus.fromCode((int)this.getStatus()), this.contentType, this.getBody()) : new BytesRestResponse(RestStatus.fromCode((int)this.getStatus()), this.getBody());
        if (this.getHeaders() != null) {
            this.getHeaders().entrySet().forEach(arg_0 -> SecurityResponse.lambda$asRestResponse$2((RestResponse)restResponse, arg_0));
        }
        return restResponse;
    }

    protected String generateFailureMessage(Exception e) {
        try {
            return XContentFactory.jsonBuilder().startObject().startObject("error").field("status", "error").field("reason", e.getMessage()).endObject().endObject().toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static /* synthetic */ void lambda$asRestResponse$2(RestResponse restResponse, Map.Entry entry) {
        ((List)entry.getValue()).forEach(value -> restResponse.addHeader((String)entry.getKey(), value));
    }
}

