/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.transport;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.inject.Injector;
import org.opensearch.common.inject.Module;
import org.opensearch.common.inject.ModulesBuilder;
import org.opensearch.core.action.ActionListener;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.datasource.DataSourceService;
import org.opensearch.sql.datasources.service.DataSourceServiceImpl;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.sql.opensearch.security.SecurityAccess;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.plugin.config.OpenSearchPluginModule;
import org.opensearch.sql.plugin.transport.TransportPPLQueryRequest;
import org.opensearch.sql.plugin.transport.TransportPPLQueryResponse;
import org.opensearch.sql.ppl.PPLService;
import org.opensearch.sql.ppl.domain.PPLQueryRequest;
import org.opensearch.sql.protocol.response.QueryResult;
import org.opensearch.sql.protocol.response.format.CsvResponseFormatter;
import org.opensearch.sql.protocol.response.format.Format;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;
import org.opensearch.sql.protocol.response.format.RawResponseFormatter;
import org.opensearch.sql.protocol.response.format.ResponseFormatter;
import org.opensearch.sql.protocol.response.format.SimpleJsonResponseFormatter;
import org.opensearch.sql.protocol.response.format.VisualizationResponseFormatter;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportPPLQueryAction
extends HandledTransportAction<ActionRequest, TransportPPLQueryResponse> {
    private final Injector injector;

    @Inject
    public TransportPPLQueryAction(TransportService transportService, ActionFilters actionFilters, NodeClient client, ClusterService clusterService, DataSourceServiceImpl dataSourceService) {
        super("cluster:admin/opensearch/ppl", transportService, actionFilters, TransportPPLQueryRequest::new);
        ModulesBuilder modules = new ModulesBuilder();
        modules.add(new Module[]{new OpenSearchPluginModule()});
        modules.add(new Module[]{b -> {
            b.bind(NodeClient.class).toInstance((Object)client);
            b.bind(Settings.class).toInstance((Object)new OpenSearchSettings(clusterService.getClusterSettings()));
            b.bind(DataSourceService.class).toInstance((Object)dataSourceService);
        }});
        this.injector = modules.createInjector();
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<TransportPPLQueryResponse> listener) {
        Metrics.getInstance().getNumericalMetric(MetricName.PPL_REQ_TOTAL).increment();
        Metrics.getInstance().getNumericalMetric(MetricName.PPL_REQ_COUNT_TOTAL).increment();
        QueryContext.addRequestId();
        PPLService pplService = (PPLService)SecurityAccess.doPrivileged(() -> (PPLService)this.injector.getInstance(PPLService.class));
        TransportPPLQueryRequest transportRequest = TransportPPLQueryRequest.fromActionRequest(request);
        PPLQueryRequest transformedRequest = transportRequest.toPPLQueryRequest();
        if (transformedRequest.isExplainRequest()) {
            pplService.explain(transformedRequest, this.createExplainResponseListener(listener));
        } else {
            pplService.execute(transformedRequest, this.createListener(transformedRequest, listener));
        }
    }

    private ResponseListener<ExecutionEngine.ExplainResponse> createExplainResponseListener(final ActionListener<TransportPPLQueryResponse> listener) {
        return new ResponseListener<ExecutionEngine.ExplainResponse>(){

            public void onResponse(ExecutionEngine.ExplainResponse response) {
                String responseContent = new JsonResponseFormatter<ExecutionEngine.ExplainResponse>(JsonResponseFormatter.Style.PRETTY){

                    protected Object buildJsonObject(ExecutionEngine.ExplainResponse response) {
                        return response;
                    }
                }.format((Object)response);
                listener.onResponse((Object)new TransportPPLQueryResponse(responseContent));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
    }

    private ResponseListener<ExecutionEngine.QueryResponse> createListener(PPLQueryRequest pplRequest, ActionListener<TransportPPLQueryResponse> listener) {
        Format format = this.format(pplRequest);
        Object formatter = format.equals((Object)Format.CSV) ? new CsvResponseFormatter(pplRequest.sanitize()) : (format.equals((Object)Format.RAW) ? new RawResponseFormatter() : (format.equals((Object)Format.VIZ) ? new VisualizationResponseFormatter(pplRequest.style()) : new SimpleJsonResponseFormatter(JsonResponseFormatter.Style.PRETTY)));
        return new ResponseListener<ExecutionEngine.QueryResponse>(){
            final /* synthetic */ ResponseFormatter val$formatter;
            final /* synthetic */ ActionListener val$listener;
            {
                this.val$formatter = responseFormatter;
                this.val$listener = actionListener;
            }

            public void onResponse(ExecutionEngine.QueryResponse response) {
                String responseContent = this.val$formatter.format((Object)new QueryResult(response.getSchema(), (Collection)response.getResults(), response.getCursor()));
                this.val$listener.onResponse((Object)new TransportPPLQueryResponse(responseContent));
            }

            public void onFailure(Exception e) {
                this.val$listener.onFailure(e);
            }
        };
    }

    private Format format(PPLQueryRequest pplRequest) {
        String format = pplRequest.getFormat();
        Optional optionalFormat = Format.of((String)format);
        if (optionalFormat.isPresent()) {
            return (Format)optionalFormat.get();
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "response in %s format is not supported.", format));
    }
}

