/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class LootCargoMessage
extends ObjectMessage {
    public static final String TAG = "lootCargo";
    private static final String LOSER_TAG = "loser";
    private static final String WINNER_TAG = "winner";

    public LootCargoMessage(Unit winner, String loserId, List<Goods> goods) {
        super(TAG, WINNER_TAG, winner.getId(), LOSER_TAG, loserId);
        this.appendChildren(goods);
    }

    public LootCargoMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, WINNER_TAG, LOSER_TAG);
        ArrayList<Goods> goods = new ArrayList<Goods>();
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if ("goods".equals(tag)) {
                Goods g = xr.readFreeColObject(game, Goods.class);
                if (g != null) {
                    goods.add(g);
                }
            } else {
                this.expected("goods", tag);
            }
            xr.expectTag(tag);
        }
        xr.expectTag(TAG);
        this.appendChildren(goods);
    }

    private Unit getWinner(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(WINNER_TAG), Unit.class);
    }

    private String getLoserId() {
        return this.getStringAttribute(LOSER_TAG);
    }

    private List<Goods> getGoods() {
        return this.getChildren(Goods.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        ServerGame game = freeColServer.getGame();
        Unit winner = this.getWinner(game);
        List<Goods> initialGoods = this.getGoods();
        String loserId = this.getLoserId();
        aiPlayer.lootCargoHandler(winner, initialGoods, loserId);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Unit unit = this.getWinner(game);
        String loserId = this.getLoserId();
        List<Goods> goods = this.getGoods();
        if (unit == null) {
            return;
        }
        this.igc(freeColClient).lootCargoHandler(unit, goods, loserId);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit winner;
        ServerGame game = freeColServer.getGame();
        try {
            winner = this.getWinner(game);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        return this.igc(freeColServer).lootCargo(serverPlayer, winner, this.getLoserId(), this.getGoods());
    }
}

