/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class ExpireLeasesJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 60000L;

    public ExpireLeasesJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(ExpireLeasesJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Expire Lease Sets Job";
    }

    @Override
    public void runJob() {
        List<Hash> toExpire = this.selectKeysToExpire();
        this._log.info("Leases to expire: " + toExpire);
        for (Hash key : toExpire) {
            this._facade.fail(key);
        }
        this.requeue(60000L);
    }

    private List<Hash> selectKeysToExpire() {
        ArrayList<Hash> toExpire = new ArrayList<Hash>(128);
        for (Map.Entry<Hash, DatabaseEntry> entry : this._facade.getDataStore().getMapEntries()) {
            DatabaseEntry obj = entry.getValue();
            if (!obj.isLeaseSet()) continue;
            LeaseSet ls = (LeaseSet)obj;
            if (!ls.isCurrent(60000L)) {
                toExpire.add(entry.getKey());
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Lease " + ls.getDestination().calculateHash() + " is current, no need to expire");
        }
        return toExpire;
    }
}

