/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.RuntimeContainer;
import biz.paluch.logging.StackTraceFilter;
import biz.paluch.logging.gelf.GelfMessageBuilder;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.PropertyProvider;
import biz.paluch.logging.gelf.StaticMessageField;
import biz.paluch.logging.gelf.Values;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.HostAndPortProvider;
import biz.paluch.logging.gelf.intern.PoolingGelfMessageBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class GelfMessageAssembler
implements HostAndPortProvider {
    @Deprecated
    public static final String PROPERTY_USE_POOLING = "logstash-gelf.message.pooling";
    public static final String FIELD_MESSAGE_PARAM = "MessageParam";
    public static final String FIELD_STACK_TRACE = "StackTrace";
    private static final int MAX_SHORT_MESSAGE_LENGTH = 250;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int MAX_MESSAGE_SIZE = Integer.MAX_VALUE;
    private static final Set<LogMessageField.NamedLogField> SOURCE_FIELDS = EnumSet.of(LogMessageField.NamedLogField.SourceClassName, LogMessageField.NamedLogField.SourceSimpleClassName, LogMessageField.NamedLogField.SourceMethodName, LogMessageField.NamedLogField.SourceLineNumber);
    private String host;
    private String version = "1.0";
    private String originHost;
    private int port;
    private String facility;
    private boolean includeLogMessageParameters = true;
    private boolean includeLocation = true;
    private StackTraceExtraction stackTraceExtraction = StackTraceExtraction.access$000();
    private int maximumMessageSize = 8192;
    private List<MessageField> fields = new ArrayList<MessageField>();
    private Map<String, String> additionalFieldTypes = new HashMap<String, String>();
    private Map<Pattern, String> dynamicMdcFieldTypes = new LinkedHashMap<Pattern, String>();
    private String timestampPattern = "yyyy-MM-dd HH:mm:ss,SSS";
    private final ThreadLocal<PoolingGelfMessageBuilder> builders = PoolingGelfMessageBuilder.usePooling() ? new ThreadLocal<PoolingGelfMessageBuilder>(){

        @Override
        protected PoolingGelfMessageBuilder initialValue() {
            return PoolingGelfMessageBuilder.newInstance();
        }
    } : null;

    public void initialize(PropertyProvider propertyProvider) {
        String timestampPattern;
        String messageSize;
        String port;
        this.host = propertyProvider.getProperty("host");
        if (this.host == null) {
            this.host = propertyProvider.getProperty("graylogHost");
        }
        if ((port = propertyProvider.getProperty("port")) == null) {
            port = propertyProvider.getProperty("graylogPort");
        }
        if (port != null && !"".equals(port)) {
            this.port = Integer.parseInt(port);
        }
        this.originHost = propertyProvider.getProperty("originHost");
        this.setExtractStackTrace(propertyProvider.getProperty("extractStackTrace"));
        this.setFilterStackTrace("true".equalsIgnoreCase(propertyProvider.getProperty("filterStackTrace")));
        String includeLogMessageParameters = propertyProvider.getProperty("includeLogMessageParameters");
        if (includeLogMessageParameters != null && !includeLogMessageParameters.trim().equals("")) {
            this.setIncludeLogMessageParameters("true".equalsIgnoreCase(includeLogMessageParameters));
        }
        this.setupStaticFields(propertyProvider);
        this.setupAdditionalFieldTypes(propertyProvider);
        this.setupDynamicMdcFieldTypes(propertyProvider);
        this.facility = propertyProvider.getProperty("facility");
        String version = propertyProvider.getProperty("version");
        if (version != null && !"".equals(version)) {
            this.version = version;
        }
        if ((messageSize = propertyProvider.getProperty("maximumMessageSize")) != null) {
            this.maximumMessageSize = Integer.parseInt(messageSize);
        }
        if ((timestampPattern = propertyProvider.getProperty("timestampPattern")) != null && !"".equals(timestampPattern)) {
            this.timestampPattern = timestampPattern;
        }
    }

    public GelfMessage createGelfMessage(LogEvent logEvent) {
        GelfMessageBuilder builder = this.builders != null ? this.builders.get().recycle() : GelfMessageBuilder.newInstance();
        Throwable throwable = logEvent.getThrowable();
        String message = logEvent.getMessage();
        if (GelfMessage.isEmpty(message) && throwable != null) {
            message = throwable.toString();
        }
        String shortMessage = message;
        if (message.length() > 250) {
            shortMessage = message.substring(0, 249);
        }
        builder.withShortMessage(shortMessage).withFullMessage(message).withJavaTimestamp(logEvent.getLogTimestamp());
        builder.withLevel(logEvent.getSyslogLevel());
        builder.withVersion(this.getVersion());
        builder.withAdditionalFieldTypes(this.additionalFieldTypes);
        builder.withDynamicMdcFieldTypes(this.dynamicMdcFieldTypes);
        for (MessageField field : this.fields) {
            Values values;
            LogMessageField messageField;
            if (!this.isIncludeLocation() && field instanceof LogMessageField && SOURCE_FIELDS.contains((Object)(messageField = (LogMessageField)field).getNamedLogField()) || (values = this.getValues(logEvent, field)) == null || !values.hasValues()) continue;
            for (String entryName : values.getEntryNames()) {
                String value = (String)values.getValue(entryName);
                if (value == null) continue;
                builder.withField(entryName, value);
            }
        }
        if (this.stackTraceExtraction.isEnabled() && throwable != null) {
            this.addStackTrace(throwable, builder);
        }
        if (this.includeLogMessageParameters && logEvent.getParameters() != null) {
            for (int i = 0; i < logEvent.getParameters().length; ++i) {
                Object param = logEvent.getParameters()[i];
                builder.withField(FIELD_MESSAGE_PARAM + i, "" + param);
            }
        }
        builder.withHost(this.getOriginHost());
        if (null != this.facility) {
            builder.withFacility(this.facility);
        }
        builder.withMaximumMessageSize(this.maximumMessageSize);
        return builder.build();
    }

    private Values getValues(LogEvent logEvent, MessageField field) {
        if (field instanceof StaticMessageField) {
            return new Values(field.getName(), this.getValue((StaticMessageField)field));
        }
        if (field instanceof LogMessageField) {
            LogMessageField logMessageField = (LogMessageField)field;
            if (logMessageField.getNamedLogField() == LogMessageField.NamedLogField.Time) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.timestampPattern);
                return new Values(field.getName(), dateFormat.format(new Date(logEvent.getLogTimestamp())));
            }
            if (logMessageField.getNamedLogField() == LogMessageField.NamedLogField.Server) {
                return new Values(field.getName(), this.getOriginHost());
            }
        }
        return logEvent.getValues(field);
    }

    private String getValue(StaticMessageField field) {
        return field.getValue();
    }

    private void addStackTrace(Throwable thrown, GelfMessageBuilder builder) {
        if (this.stackTraceExtraction.isFilter()) {
            builder.withField(FIELD_STACK_TRACE, StackTraceFilter.getFilteredStackTrace(thrown, this.stackTraceExtraction.getRef()));
        } else {
            StringWriter sw = new StringWriter();
            StackTraceFilter.getThrowable(thrown, this.stackTraceExtraction.getRef()).printStackTrace(new PrintWriter(sw));
            builder.withField(FIELD_STACK_TRACE, sw.toString());
        }
    }

    private void setupStaticFields(PropertyProvider propertyProvider) {
        String property;
        int fieldNumber = 0;
        while (null != (property = propertyProvider.getProperty("additionalField." + fieldNumber))) {
            int index = property.indexOf(61);
            if (-1 != index) {
                StaticMessageField field = new StaticMessageField(property.substring(0, index), property.substring(index + 1));
                this.addField(field);
            }
            ++fieldNumber;
        }
    }

    private void setupAdditionalFieldTypes(PropertyProvider propertyProvider) {
        String property;
        int fieldNumber = 0;
        while (null != (property = propertyProvider.getProperty("additionalFieldType." + fieldNumber))) {
            int index = property.indexOf(61);
            if (-1 != index) {
                String field = property.substring(0, index);
                String type = property.substring(index + 1);
                this.setAdditionalFieldType(field, type);
            }
            ++fieldNumber;
        }
    }

    private void setupDynamicMdcFieldTypes(PropertyProvider propertyProvider) {
        String property;
        int fieldNumber = 0;
        while (null != (property = propertyProvider.getProperty("dynamicMdcFieldTypes" + fieldNumber))) {
            int index = property.indexOf(61);
            if (-1 != index) {
                String field = property.substring(0, index);
                String type = property.substring(index + 1);
                this.setDynamicMdcFieldType(field, type);
            }
            ++fieldNumber;
        }
    }

    public void setAdditionalFieldType(String field, String type) {
        this.additionalFieldTypes.put(field, type);
    }

    public void setDynamicMdcFieldType(String fieldPattern, String type) {
        Pattern pattern = Pattern.compile(fieldPattern);
        this.setDynamicMdcFieldType(pattern, type);
    }

    public void setDynamicMdcFieldType(Pattern fieldPattern, String type) {
        this.dynamicMdcFieldTypes.put(fieldPattern, type);
    }

    public void addField(MessageField field) {
        if (!this.fields.contains(field)) {
            this.fields.add(field);
        }
    }

    public void addFields(Collection<? extends MessageField> fields) {
        this.fields.addAll(fields);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOriginHost() {
        if (null == this.originHost) {
            this.originHost = RuntimeContainer.FQDN_HOSTNAME;
        }
        return this.originHost;
    }

    public void setOriginHost(String originHost) {
        this.originHost = originHost;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port > 65535 || port < 1) {
            throw new IllegalArgumentException("Invalid port number: " + port + ", supported range: 1-" + 65535);
        }
        this.port = port;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public boolean isExtractStackTrace() {
        return this.stackTraceExtraction.isEnabled();
    }

    public String getExtractStackTrace() {
        if (this.stackTraceExtraction.isEnabled()) {
            if (this.stackTraceExtraction.getRef() == 0) {
                return "true";
            }
            return Integer.toString(this.stackTraceExtraction.getRef());
        }
        return "false";
    }

    public void setExtractStackTrace(boolean extractStackTrace) {
        this.stackTraceExtraction = this.stackTraceExtraction.applyExtaction("" + extractStackTrace);
    }

    public void setExtractStackTrace(String value) {
        this.stackTraceExtraction = this.stackTraceExtraction.applyExtaction(value);
    }

    public boolean isFilterStackTrace() {
        return this.stackTraceExtraction.isEnabled();
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.stackTraceExtraction = this.stackTraceExtraction.applyFilter(filterStackTrace);
    }

    public boolean isIncludeLogMessageParameters() {
        return this.includeLogMessageParameters;
    }

    public void setIncludeLogMessageParameters(boolean includeLogMessageParameters) {
        this.includeLogMessageParameters = includeLogMessageParameters;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public void setIncludeLocation(boolean includeLocation) {
        this.includeLocation = includeLocation;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        if (maximumMessageSize > Integer.MAX_VALUE || maximumMessageSize < 1) {
            throw new IllegalArgumentException("Invalid maximum message size: " + maximumMessageSize + ", supported range: 1-" + Integer.MAX_VALUE);
        }
        this.maximumMessageSize = maximumMessageSize;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (!"1.0".equals(version) && !"1.1".equals(version)) {
            throw new IllegalArgumentException("Invalid GELF version: " + version + ", supported range: " + "1.0" + ", " + "1.1");
        }
        this.version = version;
    }

    static class StackTraceExtraction {
        private static final StackTraceExtraction OFF = new StackTraceExtraction(false, false, 0);
        private static final StackTraceExtraction ON = new StackTraceExtraction(true, false, 0);
        private static final StackTraceExtraction FILTERED = new StackTraceExtraction(true, true, 0);
        private final boolean enabled;
        private final boolean filter;
        private final int ref;

        private StackTraceExtraction(boolean enabled, boolean filter, int ref) {
            this.enabled = enabled;
            this.filter = filter;
            this.ref = ref;
        }

        public static StackTraceExtraction from(String value, boolean filter) {
            if (value == null) {
                return OFF;
            }
            boolean enabled = Boolean.parseBoolean(value);
            int ref = 0;
            if (!value.equalsIgnoreCase("false") && !value.trim().isEmpty()) {
                try {
                    ref = Integer.parseInt(value);
                    enabled = true;
                }
                catch (NumberFormatException e) {
                    ref = 0;
                }
            }
            return new StackTraceExtraction(enabled, filter, ref);
        }

        public StackTraceExtraction applyExtaction(String value) {
            StackTraceExtraction parsed = StackTraceExtraction.from(value, this.isFilter());
            return new StackTraceExtraction(parsed.isEnabled(), parsed.isFilter(), parsed.getRef());
        }

        public StackTraceExtraction applyFilter(boolean filterStackTrace) {
            return new StackTraceExtraction(this.isEnabled(), filterStackTrace, this.getRef());
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isFilter() {
            return this.filter;
        }

        public int getRef() {
            return this.ref;
        }

        static /* synthetic */ StackTraceExtraction access$000() {
            return OFF;
        }
    }
}

