/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.component.SubComponentFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.models.utils.StripSecretsUtils;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ComponentResource {
    protected static final Logger logger = Logger.getLogger(ComponentResource.class);
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    protected final ClientConnection clientConnection;
    protected final KeycloakSession session;
    protected final HttpHeaders headers;

    public ComponentResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.adminEvent = adminEvent.resource(ResourceType.COMPONENT);
        this.clientConnection = session.getContext().getConnection();
        this.headers = session.getContext().getRequestHeaders();
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Component")
    @Operation
    public Stream<ComponentRepresentation> getComponents(@QueryParam(value="parent") String parent, @QueryParam(value="type") String type, @QueryParam(value="name") String name) {
        this.auth.realm().requireViewRealm();
        Stream components = parent == null && type == null ? this.realm.getComponentsStream() : (type == null ? this.realm.getComponentsStream(parent) : (parent == null ? this.realm.getComponentsStream(this.realm.getId(), type) : this.realm.getComponentsStream(parent, type)));
        return components.filter(component -> Objects.isNull(name) || Objects.equals(component.getName(), name)).map(component -> {
            try {
                return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (ComponentModel)component, (boolean)false);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get component list for component model" + component.getName() + "of realm " + this.realm.getName()));
                return ModelToRepresentation.toRepresentationWithoutConfig((ComponentModel)component);
            }
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Component")
    @Operation
    public Response create(ComponentRepresentation rep) {
        this.auth.realm().requireManageRealm();
        try {
            ComponentModel model = RepresentationToModel.toModel((KeycloakSession)this.session, (ComponentRepresentation)rep);
            if (model.getParentId() == null) {
                model.setParentId(this.realm.getId());
            }
            model = this.realm.addComponentModel(model);
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), model.getId()).representation(StripSecretsUtils.strip((KeycloakSession)this.session, (ComponentRepresentation)rep)).success();
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
        }
        catch (ComponentValidationException e) {
            return this.localizedErrorResponse(e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Component")
    @Operation
    public ComponentRepresentation getComponent(@PathParam(value="id") String id) {
        this.auth.realm().requireViewRealm();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        ComponentRepresentation rep = ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (ComponentModel)model, (boolean)false);
        return rep;
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Tag(name="Component")
    @Operation
    public Response updateComponent(@PathParam(value="id") String id, ComponentRepresentation rep) {
        this.auth.realm().requireManageRealm();
        try {
            ComponentModel model = this.realm.getComponent(id);
            if (model == null) {
                throw new NotFoundException("Could not find component");
            }
            RepresentationToModel.updateComponent((KeycloakSession)this.session, (ComponentRepresentation)rep, (ComponentModel)model, (boolean)false);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(StripSecretsUtils.strip((KeycloakSession)this.session, (ComponentRepresentation)rep)).success();
            this.realm.updateComponent(model);
            return Response.noContent().build();
        }
        catch (ComponentValidationException e) {
            return this.localizedErrorResponse(e);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException();
        }
    }

    @DELETE
    @Path(value="{id}")
    @Tag(name="Component")
    @Operation
    public void removeComponent(@PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        this.realm.removeComponent(model);
    }

    private Response localizedErrorResponse(ComponentValidationException cve) {
        Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale(), "admin-messages", "messages");
        Object[] localizedParameters = cve.getParameters() == null ? null : Arrays.asList(cve.getParameters()).stream().map(parameter -> {
            if (parameter instanceof String) {
                String paramStr = (String)parameter;
                return messages.getProperty(paramStr, paramStr);
            }
            return parameter;
        }).toArray();
        String message = MessageFormat.format(messages.getProperty(cve.getMessage(), cve.getMessage()), localizedParameters);
        throw ErrorResponse.error(message, Response.Status.BAD_REQUEST);
    }

    @GET
    @Path(value="{id}/sub-component-types")
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Component")
    @Operation(summary="List of subcomponent types that are available to configure for a particular parent component.")
    public Stream<ComponentTypeRepresentation> getSubcomponentConfig(@PathParam(value="id") String parentId, @QueryParam(value="type") String subtype) {
        Class<?> providerClass;
        this.auth.realm().requireViewRealm();
        ComponentModel parent = this.realm.getComponent(parentId);
        if (parent == null) {
            throw new NotFoundException("Could not find parent component");
        }
        if (subtype == null) {
            throw new BadRequestException("must specify a subtype");
        }
        try {
            providerClass = Class.forName(subtype);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(providerClass).filter(ComponentFactory.class::isInstance).map(factory -> this.toComponentTypeRepresentation((ProviderFactory)factory, parent));
    }

    private ComponentTypeRepresentation toComponentTypeRepresentation(ProviderFactory factory, ComponentModel parent) {
        Map metadata;
        List props;
        ComponentTypeRepresentation rep = new ComponentTypeRepresentation();
        rep.setId(factory.getId());
        ComponentFactory componentFactory = (ComponentFactory)factory;
        rep.setHelpText(componentFactory.getHelpText());
        if (factory instanceof SubComponentFactory) {
            props = ((SubComponentFactory)factory).getConfigProperties(this.realm, parent);
            metadata = ((SubComponentFactory)factory).getTypeMetadata(this.realm, parent);
        } else {
            props = componentFactory.getConfigProperties();
            metadata = componentFactory.getTypeMetadata();
        }
        List propReps = ModelToRepresentation.toRepresentation((List)props);
        rep.setProperties(propReps);
        rep.setMetadata(metadata);
        return rep;
    }
}

