/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.util;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.entityprovider.JpaEntityProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.utils.ProxyClassLoader;

public class JpaUtils {
    public static final String HIBERNATE_DEFAULT_SCHEMA = "hibernate.default_schema";
    public static final String QUERY_NATIVE_SUFFIX = "[native]";
    public static final String QUERY_JPQL_SUFFIX = "[jpql]";
    private static final Logger logger = Logger.getLogger(JpaUtils.class);

    public static String getTableNameForNativeQuery(String tableName, EntityManager em) {
        String schema = (String)em.getEntityManagerFactory().getProperties().get(HIBERNATE_DEFAULT_SCHEMA);
        return schema == null ? tableName : "\"" + schema + "\"." + tableName;
    }

    public static EntityManagerFactory createEntityManagerFactory(KeycloakSession session, String unitName, Map<String, Object> properties, boolean jta) {
        PersistenceUnitTransactionType txType = jta ? PersistenceUnitTransactionType.JTA : PersistenceUnitTransactionType.RESOURCE_LOCAL;
        ArrayList<ParsedPersistenceXmlDescriptor> persistenceUnits = new ArrayList<ParsedPersistenceXmlDescriptor>(PersistenceXmlParser.locatePersistenceUnits(properties));
        persistenceUnits.add(PersistenceXmlParser.locateIndividualPersistenceUnit((URL)JpaUtils.class.getClassLoader().getResource("default-persistence.xml")));
        for (ParsedPersistenceXmlDescriptor persistenceUnit : persistenceUnits) {
            if (!persistenceUnit.getName().equals(unitName)) continue;
            List<Class<?>> providedEntities = JpaUtils.getProvidedEntities(session);
            for (Class<?> entityClass : providedEntities) {
                persistenceUnit.addClasses(new String[]{entityClass.getName()});
            }
            persistenceUnit.setTransactionType(txType);
            persistenceUnit.setValidationMode(ValidationMode.NONE.name());
            return Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitDescriptor)persistenceUnit, properties, (ClassLoader)new ProxyClassLoader(providedEntities)).build();
        }
        throw new RuntimeException("Persistence unit '" + unitName + "' not found");
    }

    public static List<Class<?>> getProvidedEntities(KeycloakSession session) {
        ArrayList providedEntityClasses = new ArrayList();
        Set entityProviders = session.getAllProviders(JpaEntityProvider.class);
        for (JpaEntityProvider entityProvider : entityProviders) {
            providedEntityClasses.addAll(entityProvider.getEntities());
        }
        return providedEntityClasses;
    }

    public static String getCustomChangelogTableName(String jpaEntityProviderFactoryId) {
        String upperCased = jpaEntityProviderFactoryId.toUpperCase();
        upperCased = upperCased.replaceAll("-", "_");
        upperCased = upperCased.replaceAll("[^A-Z_]", "");
        return "DATABASECHANGELOG_" + upperCased.substring(0, Math.min(10, upperCased.length()));
    }

    public static Properties loadSqlProperties(URL url) {
        if (url == null) {
            return null;
        }
        Properties props = new Properties();
        try (InputStream is = url.openStream();){
            props.load(is);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return props;
    }

    private static String getQueryFromProperties(String name, Properties queries) {
        if (queries == null) {
            return null;
        }
        String nameFull = name + QUERY_NATIVE_SUFFIX;
        if (queries.containsKey(nameFull)) {
            return nameFull;
        }
        nameFull = name + QUERY_JPQL_SUFFIX;
        if (queries.containsKey(nameFull)) {
            return nameFull;
        }
        nameFull = name;
        if (queries.containsKey(nameFull)) {
            return nameFull;
        }
        return null;
    }

    private static String getQueryShortName(String name) {
        if (name.endsWith(QUERY_NATIVE_SUFFIX)) {
            return name.substring(0, name.length() - QUERY_NATIVE_SUFFIX.length());
        }
        if (name.endsWith(QUERY_JPQL_SUFFIX)) {
            return name.substring(0, name.length() - QUERY_JPQL_SUFFIX.length());
        }
        return name;
    }

    public static Properties loadSpecificNamedQueries(String databaseType) {
        URL specificUrl = JpaUtils.class.getClassLoader().getResource("META-INF/queries-" + databaseType + ".properties");
        URL defaultUrl = JpaUtils.class.getClassLoader().getResource("META-INF/queries-default.properties");
        if (defaultUrl == null) {
            throw new IllegalStateException("META-INF/queries-default.properties was not found in the classpath");
        }
        Properties specificQueries = JpaUtils.loadSqlProperties(specificUrl);
        Properties defaultQueries = JpaUtils.loadSqlProperties(defaultUrl);
        Properties queries = new Properties();
        for (String queryNameFull : defaultQueries.stringPropertyNames()) {
            String querySql = defaultQueries.getProperty(queryNameFull);
            String queryName = JpaUtils.getQueryShortName(queryNameFull);
            String specificQueryNameFull = JpaUtils.getQueryFromProperties(queryName, specificQueries);
            if (specificQueryNameFull != null) {
                queryNameFull = specificQueryNameFull;
                querySql = specificQueries.getProperty(queryNameFull);
            }
            queries.put(queryNameFull, querySql);
        }
        return queries;
    }

    public static void configureNamedQuery(String queryName, String querySql, EntityManager entityManager) {
        boolean isNative = queryName.endsWith(QUERY_NATIVE_SUFFIX);
        queryName = JpaUtils.getQueryShortName(queryName);
        logger.tracef("adding query from properties files native=%b %s:%s", (Object)isNative, (Object)queryName, (Object)querySql);
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)entityManager.getEntityManagerFactory().unwrap(SessionFactoryImplementor.class);
        if (isNative) {
            sessionFactory.addNamedQuery(queryName, entityManager.createNativeQuery(querySql));
        } else {
            sessionFactory.addNamedQuery(queryName, entityManager.createQuery(querySql));
        }
    }

    public static String getDatabaseType(String productName) {
        switch (productName) {
            case "Microsoft SQL Server": 
            case "SQLOLEDB": {
                return "mssql";
            }
            case "EnterpriseDB": {
                return "postgresql";
            }
        }
        return productName.toLowerCase();
    }

    public static void closeEntityManager(EntityManager em) {
        if (em != null) {
            try {
                em.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close entity manager", (Throwable)e);
            }
        }
    }
}

