/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.EscapeStrategy;
import org.keycloak.storage.ldap.idm.query.internal.EqualCondition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.TxAwareLDAPUserModelDelegate;

public class FullNameLDAPStorageMapper
extends AbstractLDAPStorageMapper {
    public static final String LDAP_FULL_NAME_ATTRIBUTE = "ldap.full.name.attribute";
    public static final String READ_ONLY = "read.only";
    public static final String WRITE_ONLY = "write.only";

    public FullNameLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
        if (this.isWriteOnly()) {
            return;
        }
        String ldapFullNameAttrName = this.getLdapFullNameAttrName();
        String fullName = ldapUser.getAttributeAsString(ldapFullNameAttrName);
        if (fullName == null) {
            return;
        }
        if (!(fullName = fullName.trim()).isEmpty()) {
            int lastSpaceIndex = fullName.lastIndexOf(" ");
            if (lastSpaceIndex == -1) {
                user.setLastName(fullName);
            } else {
                user.setFirstName(fullName.substring(0, lastSpaceIndex));
                user.setLastName(fullName.substring(lastSpaceIndex + 1));
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
        String ldapFullNameAttrName = this.getLdapFullNameAttrName();
        String fullName = this.getFullNameForWriteToLDAP(localUser.getFirstName(), localUser.getLastName(), localUser.getUsername());
        ldapUser.setSingleAttribute(ldapFullNameAttrName, fullName);
        if (this.isReadOnly()) {
            ldapUser.addReadOnlyAttributeName(ldapFullNameAttrName);
        }
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, RealmModel realm) {
        if (this.ldapProvider.getEditMode() == UserStorageProvider.EditMode.WRITABLE && !this.isReadOnly()) {
            TxAwareLDAPUserModelDelegate txDelegate = new TxAwareLDAPUserModelDelegate(delegate, this.ldapProvider, ldapUser){
                private String firstName;
                private String lastName;

                public String getFirstName() {
                    return this.firstName != null ? this.firstName : super.getFirstName();
                }

                public String getLastName() {
                    return this.lastName != null ? this.lastName : super.getLastName();
                }

                public Stream<String> getAttributeStream(String name) {
                    if ("firstName".equals(name)) {
                        return this.firstName != null ? Stream.of(this.firstName) : super.getAttributeStream(name);
                    }
                    if ("lastName".equals(name)) {
                        return this.lastName != null ? Stream.of(this.lastName) : super.getAttributeStream(name);
                    }
                    return super.getAttributeStream(name);
                }

                public String getFirstAttribute(String name) {
                    if ("firstName".equals(name)) {
                        return this.firstName != null ? this.firstName : super.getFirstAttribute(name);
                    }
                    if ("lastName".equals(name)) {
                        return this.lastName != null ? this.lastName : super.getFirstAttribute(name);
                    }
                    return super.getFirstAttribute(name);
                }

                public void setSingleAttribute(String name, String value) {
                    if ("firstName".equals(name)) {
                        this.firstName = value;
                        this.setFullNameToLDAPObject();
                    } else if ("lastName".equals(name)) {
                        this.lastName = value;
                        this.setFullNameToLDAPObject();
                    }
                    super.setSingleAttribute(name, value);
                }

                public void setAttribute(String name, List<String> values) {
                    String valueToSet;
                    String string = valueToSet = values != null && !values.isEmpty() ? values.get(0) : null;
                    if ("firstName".equals(name)) {
                        this.firstName = valueToSet;
                        this.setFullNameToLDAPObject();
                    } else if ("lastName".equals(name)) {
                        this.lastName = valueToSet;
                        this.setFullNameToLDAPObject();
                    }
                    super.setAttribute(name, values);
                }

                public Map<String, List<String>> getAttributes() {
                    Map attributes = this.delegate.getAttributes();
                    if (this.firstName != null) {
                        attributes.put("firstName", Collections.singletonList(this.firstName));
                    } else if (this.lastName != null) {
                        attributes.put("firstName", Collections.singletonList(this.lastName));
                    }
                    return attributes;
                }

                private void setFullNameToLDAPObject() {
                    String fullName = FullNameLDAPStorageMapper.this.getFullNameForWriteToLDAP(this.getFirstName(), this.getLastName(), this.getUsername());
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Pushing full name attribute to LDAP. Full name: %s", (Object)fullName);
                    }
                    this.markUpdatedAttributeInTransaction("firstName");
                    this.markUpdatedAttributeInTransaction("lastName");
                    String ldapFullNameAttrName = FullNameLDAPStorageMapper.this.getLdapFullNameAttrName();
                    this.ldapUser.setSingleAttribute(ldapFullNameAttrName, fullName);
                }
            };
            return txDelegate;
        }
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        if (this.isWriteOnly()) {
            return;
        }
        String ldapFullNameAttrName = this.getLdapFullNameAttrName();
        query.addReturningLdapAttribute(ldapFullNameAttrName);
        EqualCondition firstNameCondition = null;
        EqualCondition lastNameCondition = null;
        HashSet<Condition> conditionsCopy = new HashSet<Condition>(query.getConditions());
        for (Condition condition : conditionsCopy) {
            String paramName = condition.getParameterName();
            if (paramName == null) continue;
            if (paramName.equals("firstName")) {
                firstNameCondition = (EqualCondition)condition;
                query.getConditions().remove(condition);
                continue;
            }
            if (paramName.equals("lastName")) {
                lastNameCondition = (EqualCondition)condition;
                query.getConditions().remove(condition);
                continue;
            }
            if (paramName.equals("givenName")) {
                firstNameCondition = (EqualCondition)condition;
                continue;
            }
            if (!paramName.equals("sn")) continue;
            lastNameCondition = (EqualCondition)condition;
        }
        Object fullName = null;
        if (firstNameCondition != null && lastNameCondition != null) {
            fullName = firstNameCondition.getValue() + " " + lastNameCondition.getValue();
        } else if (firstNameCondition != null) {
            fullName = (String)firstNameCondition.getValue();
        } else if (lastNameCondition != null) {
            fullName = (String)lastNameCondition.getValue();
        } else {
            return;
        }
        EscapeStrategy escapeStrategy = firstNameCondition != null ? firstNameCondition.getEscapeStrategy() : lastNameCondition.getEscapeStrategy();
        EqualCondition fullNameCondition = new EqualCondition(ldapFullNameAttrName, fullName, escapeStrategy);
        query.addWhereCondition(fullNameCondition);
    }

    protected String getLdapFullNameAttrName() {
        String ldapFullNameAttrName = (String)this.mapperModel.getConfig().getFirst((Object)LDAP_FULL_NAME_ATTRIBUTE);
        return ldapFullNameAttrName == null ? "cn" : ldapFullNameAttrName;
    }

    protected String getFullNameForWriteToLDAP(String firstName, String lastName, String username) {
        if (!this.isBlank(firstName) && !this.isBlank(lastName)) {
            return firstName + " " + lastName;
        }
        if (!this.isBlank(firstName)) {
            return firstName;
        }
        if (!this.isBlank(lastName)) {
            return lastName;
        }
        if (this.isFallbackToUsername()) {
            return username;
        }
        return " ";
    }

    private boolean isBlank(String attr) {
        return attr == null || attr.trim().isEmpty();
    }

    private boolean isReadOnly() {
        return FullNameLDAPStorageMapper.parseBooleanParameter(this.mapperModel, READ_ONLY);
    }

    private boolean isWriteOnly() {
        return FullNameLDAPStorageMapper.parseBooleanParameter(this.mapperModel, WRITE_ONLY);
    }

    private boolean isFallbackToUsername() {
        String rdnLdapAttrConfig = this.getLdapProvider().getLdapIdentityStore().getConfig().getRdnLdapAttribute();
        return !this.isReadOnly() && this.getLdapFullNameAttrName().equalsIgnoreCase(rdnLdapAttrConfig);
    }
}

