/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.userprofile.UserProfileProvider;

public class MigrateTo23_0_0
implements Migration {
    private static final Logger LOG = Logger.getLogger(MigrateTo23_0_0.class);
    public static final ModelVersion VERSION = new ModelVersion("23.0.0");
    private static final String USER_PROFILE_ENABLED_PROP = "userProfileEnabled";
    private static final String UP_PIECES_COUNT_COMPONENT_CONFIG_KEY = "config-pieces-count";
    private static final String UP_PIECE_COMPONENT_CONFIG_KEY_BASE = "config-piece-";
    private static final String UP_COMPONENT_CONFIG_KEY = "kc.user.profile.config";

    public void migrate(KeycloakSession session) {
        session.realms().getRealmsStream().forEach(realm -> {
            KeycloakContext context = session.getContext();
            try {
                context.setRealm(realm);
                this.migrateRealm((RealmModel)realm);
            }
            finally {
                context.setRealm(null);
            }
        });
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(realm);
    }

    private void migrateRealm(RealmModel realm) {
        this.updateUserProfileConfig(realm);
        this.removeRegistrationProfileFormExecution(realm);
    }

    private void updateUserProfileConfig(RealmModel realm) {
        Optional component;
        if (realm.getAttribute(USER_PROFILE_ENABLED_PROP, Boolean.FALSE).booleanValue() && (component = realm.getComponentsStream(realm.getId(), UserProfileProvider.class.getName()).findAny()).isPresent()) {
            String configuration;
            ComponentModel userProfileComponent = (ComponentModel)component.get();
            int count = userProfileComponent.get(UP_PIECES_COUNT_COMPONENT_CONFIG_KEY, 0);
            userProfileComponent.getConfig().remove((Object)UP_PIECES_COUNT_COMPONENT_CONFIG_KEY);
            if (count < 1) {
                return;
            }
            if (count == 1) {
                configuration = userProfileComponent.get("config-piece-0");
                userProfileComponent.getConfig().remove((Object)"config-piece-0");
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < count; ++i) {
                    String v = userProfileComponent.get(UP_PIECE_COMPONENT_CONFIG_KEY_BASE + i);
                    userProfileComponent.getConfig().remove((Object)(UP_PIECE_COMPONENT_CONFIG_KEY_BASE + i));
                    if (v == null) continue;
                    sb.append(v);
                }
                configuration = sb.toString();
            }
            userProfileComponent.getConfig().putSingle((Object)UP_COMPONENT_CONFIG_KEY, (Object)configuration);
            realm.updateComponent(userProfileComponent);
        }
    }

    private void removeRegistrationProfileFormExecution(RealmModel realm) {
        realm.getAuthenticationFlowsStream().filter(flow -> "form-flow".equals(flow.getProviderId())).forEach(registrationFlow -> realm.getAuthenticationExecutionsStream(registrationFlow.getId()).filter(authExecution -> "registration-profile-action".equals(authExecution.getAuthenticator())).forEach(registrationProfileExecution -> {
            realm.removeAuthenticatorExecution(registrationProfileExecution);
            LOG.debugf("Removed 'registration-profile-action' form action from authentication flow '%s' in the realm '%s'.", (Object)registrationFlow.getAlias(), (Object)realm.getName());
        }));
    }

    public ModelVersion getVersion() {
        return VERSION;
    }
}

