/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.LockMode;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.AbstractNonLazyEntityFetch;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityJoinedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityResultImpl;

public class EntityFetchJoinedImpl
extends AbstractNonLazyEntityFetch {
    private final EntityResultImpl entityResult;
    private final DomainResult<?> keyResult;
    private final NotFoundAction notFoundAction;
    private final String sourceAlias;

    public EntityFetchJoinedImpl(FetchParent fetchParent, ToOneAttributeMapping toOneMapping, TableGroup tableGroup, DomainResult<?> keyResult, NavigablePath navigablePath, DomainResultCreationState creationState) {
        super(fetchParent, toOneMapping, navigablePath);
        this.keyResult = keyResult;
        this.notFoundAction = toOneMapping.getNotFoundAction();
        this.sourceAlias = tableGroup.getSourceAlias();
        this.entityResult = new EntityResultImpl(navigablePath, toOneMapping, tableGroup, null);
        this.entityResult.afterInitialize(this, creationState);
    }

    public EntityFetchJoinedImpl(FetchParent fetchParent, EntityCollectionPart collectionPart, TableGroup tableGroup, NavigablePath navigablePath, DomainResultCreationState creationState) {
        super(fetchParent, collectionPart, navigablePath);
        this.notFoundAction = null;
        this.keyResult = null;
        this.sourceAlias = tableGroup.getSourceAlias();
        this.entityResult = new EntityResultImpl(navigablePath, collectionPart, tableGroup, null);
        this.entityResult.afterInitialize(this, creationState);
    }

    protected EntityFetchJoinedImpl(EntityFetchJoinedImpl original) {
        super(original.getFetchParent(), original.getReferencedModePart(), original.getNavigablePath());
        this.entityResult = original.entityResult;
        this.keyResult = original.keyResult;
        this.notFoundAction = original.notFoundAction;
        this.sourceAlias = original.sourceAlias;
    }

    @Override
    protected EntityInitializer getEntityInitializer(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> this.buildEntityJoinedFetchInitializer(this.entityResult, this.getReferencedModePart(), this.getNavigablePath(), creationState.determineEffectiveLockMode(this.sourceAlias), this.notFoundAction, this.keyResult, this.entityResult.getRowIdResult(), this.entityResult.getIdentifierFetch(), this.entityResult.getDiscriminatorFetch(), creationState)).asEntityInitializer();
    }

    protected Initializer buildEntityJoinedFetchInitializer(EntityResultGraphNode resultDescriptor, EntityValuedFetchable referencedFetchable, NavigablePath navigablePath, LockMode lockMode, NotFoundAction notFoundAction, DomainResult<?> keyResult, DomainResult<Object> rowIdResult, Fetch identifierFetch, Fetch discriminatorFetch, AssemblerCreationState creationState) {
        return new EntityJoinedFetchInitializer(resultDescriptor, referencedFetchable, navigablePath, lockMode, notFoundAction, keyResult, rowIdResult, identifierFetch, discriminatorFetch, creationState);
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    @Override
    public boolean containsCollectionFetches() {
        return this.entityResult.containsCollectionFetches();
    }

    public EntityResultImpl getEntityResult() {
        return this.entityResult;
    }
}

