/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.resources;

import io.quarkus.resteasy.reactive.server.EndpointDisabled;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.services.resources.ConstantsDebugHostname;
import org.keycloak.services.Urls;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.Theme;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.urls.UrlType;

@Path(value="/realms")
@EndpointDisabled(name="kc.hostname-debug", stringValue="false", disableIfMissing=true)
public class DebugHostnameSettingsResource {
    public static final String DEFAULT_PATH_SUFFIX = "hostname-debug";
    public static final String PATH_FOR_TEST_CORS_IN_HEADERS = "test";
    @Context
    KeycloakSession keycloakSession;
    private final Map<String, String> allConfigPropertiesMap = new LinkedHashMap<String, String>();

    public DebugHostnameSettingsResource() {
        for (String key : ConstantsDebugHostname.RELEVANT_OPTIONS) {
            this.addOption(key);
        }
    }

    @GET
    @Path(value="/{realmName}/hostname-debug")
    @Produces(value={"text/html"})
    public String debug(@PathParam(value="realmName") String realmName) throws IOException, FreeMarkerException {
        RealmModel realmModel = this.keycloakSession.realms().getRealmByName(realmName);
        if (realmModel == null) {
            throw new NotFoundException();
        }
        FreeMarkerProvider freeMarkerProvider = (FreeMarkerProvider)this.keycloakSession.getProvider(FreeMarkerProvider.class);
        URI frontendUri = this.keycloakSession.getContext().getUri(UrlType.FRONTEND).getBaseUri();
        URI backendUri = this.keycloakSession.getContext().getUri(UrlType.BACKEND).getBaseUri();
        URI adminUri = this.keycloakSession.getContext().getUri(UrlType.ADMIN).getBaseUri();
        String frontendTestUrl = this.getTest(realmModel, frontendUri);
        String backendTestUrl = this.getTest(realmModel, backendUri);
        String adminTestUrl = this.getTest(realmModel, adminUri);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("frontendUrl", frontendUri.toString());
        attributes.put("backendUrl", backendUri.toString());
        attributes.put("adminUrl", adminUri.toString());
        attributes.put("realm", realmModel.getName());
        attributes.put("realmUrl", realmModel.getAttribute("frontendUrl"));
        attributes.put("frontendTestUrl", frontendTestUrl);
        attributes.put("backendTestUrl", backendTestUrl);
        attributes.put("adminTestUrl", adminTestUrl);
        attributes.put("serverMode", Environment.isDevMode() ? "dev [start-dev]" : "production [start]");
        attributes.put("config", this.allConfigPropertiesMap);
        attributes.put("headers", this.getHeaders());
        return freeMarkerProvider.processTemplate(attributes, "debug-hostname-settings.ftl", this.keycloakSession.theme().getTheme("base", Theme.Type.LOGIN));
    }

    @GET
    @Path(value="/{realmName}/hostname-debug/test")
    @Produces(value={"text/plain"})
    public Response test(@PathParam(value="realmName") String realmName) {
        Response.ResponseBuilder builder = Response.ok((Object)"test-OK");
        String origin = this.keycloakSession.getContext().getRequestHeaders().getHeaderString("Origin");
        builder.header("Access-Control-Allow-Origin", (Object)origin);
        builder.header("Access-Control-Allow-Methods", (Object)"GET");
        return builder.build();
    }

    private void addOption(String key) {
        String rawValue = Configuration.getRawValue((String)("kc." + key));
        if (rawValue != null && !rawValue.isEmpty()) {
            this.allConfigPropertiesMap.put(key, rawValue);
        }
    }

    private Map<String, String> getHeaders() {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        HttpHeaders requestHeaders = this.keycloakSession.getContext().getRequestHeaders();
        for (String h : ConstantsDebugHostname.RELEVANT_HEADERS) {
            this.addProxyHeader(h, headers, requestHeaders);
        }
        return headers;
    }

    private void addProxyHeader(String header, Map<String, String> proxyHeaders, HttpHeaders requestHeaders) {
        String value = requestHeaders.getHeaderString(header);
        if (value != null && !value.isEmpty()) {
            proxyHeaders.put(header, value);
        }
    }

    private String getTest(RealmModel realmModel, URI baseUri) {
        return Urls.realmBase((URI)baseUri).path("/{realmName}/{debugHostnameSettingsPath}/{pathForTestCORSInHeaders}").build(new Object[]{realmModel.getName(), DEFAULT_PATH_SUFFIX, PATH_FOR_TEST_CORS_IN_HEADERS}).toString();
    }
}

