/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics;

import java.time.Duration;

interface FlowMetricRetentionPolicy {
    public String policyName();

    public long resolutionNanos();

    public long retentionNanos();

    public long forceCompactionNanos();

    public boolean reportBeforeSatisfied();

    public static enum BuiltInRetentionPolicy implements FlowMetricRetentionPolicy
    {
        CURRENT(Duration.ofSeconds(10L), Duration.ofSeconds(1L), true),
        LAST_1_MINUTE(Duration.ofMinutes(1L), Duration.ofSeconds(3L)),
        LAST_5_MINUTES(Duration.ofMinutes(5L), Duration.ofSeconds(15L)),
        LAST_15_MINUTES(Duration.ofMinutes(15L), Duration.ofSeconds(30L)),
        LAST_1_HOUR(Duration.ofHours(1L), Duration.ofMinutes(1L)),
        LAST_24_HOURS(Duration.ofHours(24L), Duration.ofMinutes(15L));

        final long resolutionNanos;
        final long retentionNanos;
        final long forceCompactionNanos;
        final boolean reportBeforeSatisfied;
        final transient String nameLower;

        private BuiltInRetentionPolicy(Duration maximumRetention, Duration minimumResolution, boolean reportBeforeSatisfied) {
            this.retentionNanos = maximumRetention.toNanos();
            this.resolutionNanos = minimumResolution.toNanos();
            this.reportBeforeSatisfied = reportBeforeSatisfied;
            long forceCompactionMargin = Math.max(Duration.ofSeconds(30L).toNanos(), Math.multiplyExact(this.resolutionNanos, 8));
            this.forceCompactionNanos = Math.addExact(this.retentionNanos, forceCompactionMargin);
            this.nameLower = this.name().toLowerCase();
        }

        private BuiltInRetentionPolicy(Duration maximumRetention, Duration minimumResolution) {
            this(maximumRetention, minimumResolution, false);
        }

        @Override
        public String policyName() {
            return this.nameLower;
        }

        @Override
        public long resolutionNanos() {
            return this.resolutionNanos;
        }

        @Override
        public long retentionNanos() {
            return this.retentionNanos;
        }

        @Override
        public long forceCompactionNanos() {
            return this.forceCompactionNanos;
        }

        @Override
        public boolean reportBeforeSatisfied() {
            return this.reportBeforeSatisfied;
        }
    }
}

