/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.config.provider;

import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryConfigProvider.class);
    private static final int DEFAULT_CACHE_CAPACITY = 1000;
    private SchemaRegistryClient schemaRegistry;

    public void configure(Map<String, ?> configs) {
        String urlString = (String)configs.get("schema.registry.url");
        if (urlString == null) {
            throw new IllegalArgumentException("Missing schema.registry.url");
        }
        List<String> urls = Arrays.asList(urlString.split(","));
        if (this.schemaRegistry == null) {
            this.schemaRegistry = SchemaRegistryClientFactory.newClient(urls, 1000, Collections.emptyList(), configs, Collections.emptyMap());
        }
    }

    public ConfigData get(String path) {
        return new ConfigData(this.getData(path));
    }

    public ConfigData get(String path, Set<String> keys) {
        Map<String, String> data = this.getData(path).entrySet().stream().filter(s -> keys.contains(s.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new ConfigData(data);
    }

    public Map<String, String> getData(String path) {
        try {
            int version;
            if (path == null) {
                return Collections.emptyMap();
            }
            String[] parts = this.getSubjectAndVersion(path);
            String subject = parts[0];
            if (subject == null) {
                return Collections.emptyMap();
            }
            String versionStr = parts[1];
            if ("latest".equals(versionStr)) {
                version = -1;
            } else {
                try {
                    version = Integer.parseInt(versionStr);
                }
                catch (NumberFormatException e) {
                    return Collections.emptyMap();
                }
            }
            SchemaMetadata schema = version >= 0 ? this.schemaRegistry.getSchemaMetadata(subject, version, true) : this.schemaRegistry.getLatestSchemaMetadata(subject);
            Metadata metadata = schema.getMetadata();
            if (metadata == null) {
                return Collections.emptyMap();
            }
            SortedMap<String, String> props = metadata.getProperties();
            return props != null ? props : Collections.emptyMap();
        }
        catch (RestClientException | IOException e) {
            log.error("Could not obtain config data", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String[] getSubjectAndVersion(String path) {
        String context = null;
        String subject = null;
        String version = "-1";
        boolean contextPathFound = false;
        boolean subjectPathFound = false;
        boolean versionPathFound = false;
        for (String uriPathStr : path.split("/")) {
            if (contextPathFound) {
                context = uriPathStr;
                contextPathFound = false;
                continue;
            }
            if (uriPathStr.equals("contexts")) {
                contextPathFound = true;
                continue;
            }
            if (subjectPathFound) {
                subject = uriPathStr;
                subjectPathFound = false;
                continue;
            }
            if (uriPathStr.equals("subjects")) {
                subjectPathFound = true;
                continue;
            }
            if (versionPathFound) {
                version = uriPathStr;
                versionPathFound = false;
                continue;
            }
            if (!uriPathStr.equals("versions")) continue;
            versionPathFound = true;
        }
        String delimitedContext = context != null ? ":" + context + ":" : "";
        return new String[]{subject != null ? delimitedContext + subject : null, version};
    }

    public void close() {
        this.schemaRegistry.reset();
    }
}

