"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

var _constants = require("../../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    indexService
  } = services;
  router.post({
    path: _constants.NODE_API._SEARCH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.search);
  router.get({
    path: _constants.NODE_API._INDICES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        terms: _configSchema.schema.maybe(_configSchema.schema.any()),
        indices: _configSchema.schema.maybe(_configSchema.schema.any()),
        dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
        showDataStreams: _configSchema.schema.boolean(),
        expandWildcards: _configSchema.schema.maybe(_configSchema.schema.string()),
        exactSearch: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, indexService.getIndices);
  router.post({
    path: _constants.NODE_API.APPLY_POLICY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.applyPolicy);
  router.post({
    path: _constants.NODE_API.EDIT_ROLLOVER_ALIAS,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.editRolloverAlias);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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