"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addRulesMethods = addRulesMethods;

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function addRulesMethods(securityAnalytics, createAction) {
  securityAnalytics[_constants.METHOD_NAMES.CREATE_RULE] = createAction({
    url: {
      fmt: `${_constants.API.RULES_BASE}?category=<%=category%>`,
      req: {
        category: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.GET_RULES] = createAction({
    url: {
      fmt: `${_constants.API.RULES_BASE}/_search?pre_packaged=<%=prePackaged%>`,
      req: {
        prePackaged: {
          type: 'boolean',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  securityAnalytics[_constants.METHOD_NAMES.DELETE_RULE] = createAction({
    url: {
      fmt: `${_constants.API.RULES_BASE}/<%=ruleId%>?forced=true`,
      req: {
        ruleId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: false,
    method: 'DELETE'
  });
  securityAnalytics[_constants.METHOD_NAMES.UPDATE_RULE] = createAction({
    url: {
      fmt: `${_constants.API.RULES_BASE}/<%=ruleId%>?category=<%=category%>&forced=true`,
      req: {
        ruleId: {
          type: 'string',
          required: true
        },
        category: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'PUT'
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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