"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupLogTypeRoutes = setupLogTypeRoutes;

var _configSchema = require("@osd/config-schema");

var _constants = require("../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupLogTypeRoutes(services, router) {
  const {
    logTypeService
  } = services;
  router.post({
    path: _constants.API.LOGTYPE_BASE,
    validate: {
      body: _configSchema.schema.any()
    }
  }, logTypeService.createLogType);
  router.post({
    path: `${_constants.API.LOGTYPE_BASE}/_search`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, logTypeService.searchLogTypes);
  router.put({
    path: `${_constants.API.LOGTYPE_BASE}/{logTypeId}`,
    validate: {
      params: _configSchema.schema.object({
        logTypeId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, logTypeService.updateLogType);
  router.delete({
    path: `${_constants.API.LOGTYPE_BASE}/{logTypeId}`,
    validate: {
      params: _configSchema.schema.object({
        logTypeId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, logTypeService.deleteLogType);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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