"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JwtAuthentication = void 0;

var _authentication_type = require("../authentication_type");

var _routes = require("./routes");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   *   Copyright OpenSearch Contributors
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   *   Licensed under the Apache License, Version 2.0 (the "License").
                                                                                                                                                                                                                   *   You may not use this file except in compliance with the License.
                                                                                                                                                                                                                   *   A copy of the License is located at
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   *       http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   *   or in the "license" file accompanying this file. This file is distributed
                                                                                                                                                                                                                   *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
                                                                                                                                                                                                                   *   express or implied. See the License for the specific language governing
                                                                                                                                                                                                                   *   permissions and limitations under the License.
                                                                                                                                                                                                                   */

class JwtAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    var _this$config$jwt;

    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);

    _defineProperty(this, "type", 'jwt');

    _defineProperty(this, "authHeaderName", void 0);

    this.authHeaderName = ((_this$config$jwt = this.config.jwt) === null || _this$config$jwt === void 0 ? void 0 : _this$config$jwt.header.toLowerCase()) || 'authorization';
  }

  async init() {
    const routes = new _routes.JwtAuthRoutes(this.router, this.sessionStorageFactory);
    routes.setupRoutes();
  }

  getTokenFromUrlParam(request) {
    var _this$config$jwt2;

    const urlParamName = (_this$config$jwt2 = this.config.jwt) === null || _this$config$jwt2 === void 0 ? void 0 : _this$config$jwt2.url_param;

    if (urlParamName) {
      const token = request.url.searchParams.get(urlParamName);
      return token || undefined;
    }

    return undefined;
  }

  getBearerToken(request) {
    const token = this.getTokenFromUrlParam(request);

    if (token) {
      return `Bearer ${token}`;
    } // no token in url parameter, try to get token from header


    return request.headers[this.authHeaderName] || undefined;
  }

  requestIncludesAuthInfo(request) {
    var _this$config$jwt3;

    if (request.headers[this.authHeaderName]) {
      return true;
    }

    const urlParamName = (_this$config$jwt3 = this.config.jwt) === null || _this$config$jwt3 === void 0 ? void 0 : _this$config$jwt3.url_param;

    if (urlParamName && request.url.searchParams.get(urlParamName)) {
      return true;
    }

    return false;
  }

  async getAdditionalAuthHeader(request) {
    const header = {};
    const token = this.getTokenFromUrlParam(request);

    if (token) {
      header[this.authHeaderName] = `Bearer ${token}`;
    }

    return header;
  }

  getCookie(request, authInfo) {
    return {
      username: authInfo.user_name,
      credentials: {
        authHeaderValue: this.getBearerToken(request)
      },
      authType: this.type,
      expiryTime: Date.now() + this.config.session.ttl
    };
  }

  async isValidCookie(cookie) {
    var _cookie$credentials;

    return cookie.authType === this.type && cookie.username && cookie.expiryTime && ((_cookie$credentials = cookie.credentials) === null || _cookie$credentials === void 0 ? void 0 : _cookie$credentials.authHeaderValue);
  }

  handleUnauthedRequest(request, response, toolkit) {
    return response.unauthorized();
  }

  buildAuthHeaderFromCookie(cookie) {
    var _cookie$credentials2;

    const header = {};
    const authHeaderValue = (_cookie$credentials2 = cookie.credentials) === null || _cookie$credentials2 === void 0 ? void 0 : _cookie$credentials2.authHeaderValue;

    if (authHeaderValue) {
      header[this.authHeaderName] = authHeaderValue;
    }

    return header;
  }

}

exports.JwtAuthentication = JwtAuthentication;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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