/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.calendar;

import au.com.trgtd.tr.calendar.prefs.CalendarPrefs;
import au.com.trgtd.tr.calendar.spi.CalendarSynchronizer;
import org.openide.util.Lookup;

public class Calendar {
    private static final Lookup.Result<CalendarSynchronizer> lookup = Lookup.getDefault().lookupResult(CalendarSynchronizer.class);

    public static void syncToCalendar() {
        CalendarSynchronizer synchronizer = Calendar.getSynchronizer();
        if (synchronizer != null) {
            synchronizer.syncToCalendar();
        }
    }

    public static void syncToCalendar(String icsFile) {
        CalendarSynchronizer synchronizer = Calendar.getSynchronizer();
        if (synchronizer != null) {
            synchronizer.syncToCalendar(icsFile);
        }
    }

    public static void syncFromCalendar() {
        CalendarSynchronizer synchronizer = Calendar.getSynchronizer();
        if (synchronizer != null) {
            synchronizer.syncFromCalendar();
        }
    }

    private static CalendarSynchronizer getSynchronizer() {
        String id = CalendarPrefs.getSynchronizerID();
        if (id == null) {
            return null;
        }
        for (CalendarSynchronizer synchronizer : lookup.allInstances()) {
            if (!id.equals(synchronizer.getID())) continue;
            return synchronizer;
        }
        return null;
    }
}

