/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.script;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaInspectionApplication;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaRunContext;
import org.jetbrains.qodana.staticAnalysis.script.QodanaApplicationScript;
import org.jetbrains.qodana.staticAnalysis.script.QodanaApplicationScriptFactory;
import org.jetbrains.qodana.staticAnalysis.script.TeamcityChangeStatus;
import org.jetbrains.qodana.staticAnalysis.script.TeamcityChangesRecord;
import org.jetbrains.qodana.staticAnalysis.script.TeamcityChangesScript;
import org.jetbrains.qodana.staticAnalysis.script.UnvalidatedParameters;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\t\u001a\u00020\fH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/script/TeamCityChangesApplicationScriptFactory;", "Lorg/jetbrains/qodana/staticAnalysis/script/QodanaApplicationScriptFactory;", "()V", "createScript", "Lorg/jetbrains/qodana/staticAnalysis/script/QodanaApplicationScript;", "qodanaApplication", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaInspectionApplication;", "runContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaRunContext;", "parameters", "Lorg/jetbrains/qodana/staticAnalysis/script/UnvalidatedParameters;", "getScriptName", "", "parseChangesFile", "", "Lorg/jetbrains/qodana/staticAnalysis/script/TeamcityChangesRecord;", "changesPath", "parseLine", "line", "parseParameters", "", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nteamcity-changes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 teamcity-changes.kt\norg/jetbrains/qodana/staticAnalysis/script/TeamCityChangesApplicationScriptFactory\n+ 2 UnvalidatedParameters.kt\norg/jetbrains/qodana/staticAnalysis/script/UnvalidatedParametersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n41#2:84\n1549#3:85\n1620#3,3:86\n*S KotlinDebug\n*F\n+ 1 teamcity-changes.kt\norg/jetbrains/qodana/staticAnalysis/script/TeamCityChangesApplicationScriptFactory\n*L\n30#1:84\n40#1:85\n40#1:86,3\n*E\n"})
public final class TeamCityChangesApplicationScriptFactory
implements QodanaApplicationScriptFactory {
    @Override
    @NotNull
    public String getScriptName() {
        return "teamcity-changes";
    }

    @Override
    @NotNull
    public Map<String, String> parseParameters(@NotNull String parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return ((CharSequence)parameters).length() == 0 ? MapsKt.emptyMap() : MapsKt.mapOf((Pair)TuplesKt.to((Object)"path", (Object)parameters));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public QodanaApplicationScript createScript(@NotNull QodanaInspectionApplication qodanaApplication, @NotNull QodanaRunContext runContext, @NotNull UnvalidatedParameters parameters) {
        void $this$optional$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)qodanaApplication), (String)"qodanaApplication");
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        UnvalidatedParameters unvalidatedParameters = parameters;
        String name$iv = "path";
        boolean $i$f$optional = false;
        String string = (String)$this$optional$iv.optional(name$iv, Reflection.getOrCreateKotlinClass(String.class));
        if (string == null) {
            string = "teamcity-changes.txt";
        }
        String path = string;
        List<TeamcityChangesRecord> changes = this.parseChangesFile(path, runContext);
        return new TeamcityChangesScript(qodanaApplication, runContext, changes);
    }

    /*
     * WARNING - void declaration
     */
    private final List<TeamcityChangesRecord> parseChangesFile(String changesPath, QodanaRunContext runContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path path = Paths.get(changesPath, new String[0]);
        Path effectivePath = path.isAbsolute() ? path : runContext.getConfig().getProjectPath().resolve(path);
        Intrinsics.checkNotNull((Object)effectivePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(effectivePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object[] objectArray = new Object[]{((Object)effectivePath.toAbsolutePath()).toString()};
            String string = QodanaBundle.message("teamcity.changes.file.is.absent", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw new QodanaException(string);
        }
        Iterable<Path> iterable = effectivePath;
        List<String> list2 = Files.readAllLines(iterable, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
        iterable = list2;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.parseLine((String)it));
        }
        return (List)destination$iv$iv;
    }

    private final TeamcityChangesRecord parseLine(String line) {
        TeamcityChangeStatus teamcityChangeStatus;
        String[] stringArray = new String[]{":"};
        List split = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() != 3) {
            Object[] objectArray = new Object[]{line};
            String string = QodanaBundle.message("wrong.teamcity.changes.file.line.format", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw new QodanaException(string);
        }
        try {
            teamcityChangeStatus = TeamcityChangeStatus.valueOf((String)split.get(1));
        }
        catch (IllegalArgumentException ignored) {
            Object[] objectArray = new Object[]{line};
            String string = QodanaBundle.message("wrong.teamcity.changes.file.line.format", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw new QodanaException(string);
        }
        TeamcityChangeStatus status2 = teamcityChangeStatus;
        return new TeamcityChangesRecord((String)split.get(0), status2, (String)split.get(2));
    }
}

