/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator25;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamData;
import org.jetbrains.plugins.groovy.transformations.impl.namedVariant.NamedParamsUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/GroovyAnnotator25;", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyElementVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "checkRequiredNamedArguments", "", "callExpression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "immutableCheck", "field", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrField;", "visitCallExpression", "visitField", "visitMethod", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nGroovyAnnotator25.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyAnnotator25.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotator25\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1477#2:75\n1502#2,3:76\n1505#2,3:86\n1549#2:97\n1620#2,3:98\n766#2:115\n857#2,2:116\n372#3,7:79\n526#3:89\n511#3,6:90\n215#4:96\n216#4:101\n11383#5,9:102\n13309#5:111\n13310#5:113\n11392#5:114\n1#6:112\n*S KotlinDebug\n*F\n+ 1 GroovyAnnotator25.kt\norg/jetbrains/plugins/groovy/annotator/GroovyAnnotator25\n*L\n25#1:75\n25#1:76,3\n25#1:86,3\n27#1:97\n27#1:98,3\n65#1:115\n65#1:116,2\n25#1:79,7\n25#1:89\n25#1:90,6\n25#1:96\n25#1:101\n56#1:102,9\n56#1:111\n56#1:113\n56#1:114\n56#1:112\n*E\n"})
public final class GroovyAnnotator25
extends GroovyElementVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public GroovyAnnotator25(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitMethod(@NotNull GrMethod method) {
        void $this$filterTo$iv$iv;
        Object it;
        Object element$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Iterable $this$groupBy$iv = NamedParamsUtil.collectAllParamsFromNamedVariantMethod(method);
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            element$iv$iv = iterator2.next();
            it = (Pair)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it = element$iv$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            List parameters2 = (List)entry.getValue();
            String parametersList2 = CollectionsKt.joinToString$default((Iterable)parameters2, null, null, null, (int)0, null, (Function1)visitMethod.3.parametersList.1.INSTANCE, (int)31, null);
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)parameters2, (int)1);
            boolean $i$f$map = false;
            Iterable $i$f$getOrPut = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                PsiParameter parameter = (PsiParameter)pair.component2();
                collection.add(parameter);
            }
            List duplicatingParameters = (List)destination$iv$iv2;
            for (PsiParameter parameter : duplicatingParameters) {
                Object[] objectArray = parameter.getNameIdentifier();
                if (objectArray == null) continue;
                Object[] objectArray2 = objectArray;
                Intrinsics.checkNotNull((Object)objectArray2);
                Object[] nameIdentifier = objectArray2;
                objectArray2 = new Object[]{name, parametersList2};
                this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("duplicating.named.parameter", objectArray2)).range((PsiElement)nameIdentifier).create();
            }
        }
        super.visitMethod(method);
    }

    @Override
    public void visitField(@NotNull GrField field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        super.visitField(field);
        this.immutableCheck(field);
    }

    private final void immutableCheck(GrField field) {
        PsiClass psiClass = field.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        if (!field.hasModifierProperty("static") && GrImmutableUtils.hasImmutableAnnotation((PsiModifierListOwner)containingClass) && !GrImmutableUtils.isImmutable(field)) {
            Object[] objectArray = new Object[]{field.getName()};
            this.holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("field.should.be.immutable", objectArray)).range(field.getNameIdentifierGroovy()).create();
        }
    }

    @Override
    public void visitCallExpression(@NotNull GrCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        this.checkRequiredNamedArguments(callExpression);
        super.visitCallExpression(callExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRequiredNamedArguments(GrCallExpression callExpression) {
        void $this$filterTo$iv$iv;
        Object it;
        void $this$mapNotNullTo$iv$iv;
        if (!CompileStaticUtil.isCompileStatic(callExpression)) {
            return;
        }
        GrNamedArgument[] grNamedArgumentArray = callExpression.getNamedArguments();
        Intrinsics.checkNotNullExpressionValue((Object)grNamedArgumentArray, (String)"getNamedArguments(...)");
        Object[] $this$mapNotNull$iv = grNamedArgumentArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            it = (GrNamedArgument)element$iv$iv;
            boolean bl2 = false;
            if (it.getLabelName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set namedArguments = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (namedArguments.isEmpty()) {
            return;
        }
        GroovyResolveResult groovyResolveResult = callExpression.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
        GroovyResolveResult resolveResult2 = groovyResolveResult;
        destination$iv$iv = resolveResult2.getElement();
        PsiMethod psiMethod = destination$iv$iv instanceof PsiMethod ? (PsiMethod)destination$iv$iv : null;
        if (psiMethod == null) {
            return;
        }
        PsiMethod method = psiMethod;
        Object[] objectArray2 = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getParameters(...)");
        Object[] parameters2 = objectArray2;
        PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])parameters2);
        if (psiParameter == null) {
            return;
        }
        PsiParameter mapParameter = psiParameter;
        Iterable $this$filter$iv = NamedParamsUtil.collectNamedParams(mapParameter);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NamedParamData)element$iv$iv;
            boolean bl = false;
            if (!((NamedParamData)it).getRequired()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List requiredNamedParams = (List)destination$iv$iv2;
        for (NamedParamData namedParam : requiredNamedParams) {
            String message;
            if (namedArguments.contains(namedParam.getName())) continue;
            Object[] objectArray3 = new Object[]{namedParam.getName()};
            Intrinsics.checkNotNullExpressionValue((Object)GroovyBundle.message("missing.required.named.parameter", objectArray3), (String)"message(...)");
            this.holder.newAnnotation(HighlightSeverity.ERROR, message).create();
        }
    }
}

