/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.checkers;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;

public class BaseScriptAnnotationChecker
extends CustomAnnotationChecker {
    @Override
    public boolean checkApplicability(@NotNull AnnotationHolder holder, @NotNull GrAnnotation annotation) {
        if (holder == null) {
            BaseScriptAnnotationChecker.$$$reportNull$$$0(0);
        }
        if (annotation == null) {
            BaseScriptAnnotationChecker.$$$reportNull$$$0(1);
        }
        if ("groovy.transform.BaseScript".equals(annotation.getQualifiedName())) {
            PsiClass clazz;
            PsiFile file = annotation.getContainingFile();
            if (file instanceof GroovyFile && !((GroovyFile)file).isScript()) {
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("base.script.annotation.is.allowed.only.inside.scripts", new Object[0])).range((PsiElement)annotation).create();
                return true;
            }
            PsiElement pparent = annotation.getParent().getParent();
            if (pparent instanceof GrVariableDeclaration) {
                String thisScriptQualifiedName;
                PsiType type2;
                GrTypeElement typeElement = ((GrVariableDeclaration)pparent).getTypeElementGroovy();
                PsiType psiType = type2 = typeElement != null ? typeElement.getType() : null;
                if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"groovy.lang.Script")) {
                    String typeText = type2 != null ? type2.getCanonicalText() : "java.lang.Object";
                    holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("declared.type.0.have.to.extend.script", typeText)).range((PsiElement)annotation).create();
                    return true;
                }
                if (file instanceof GroovyFile && ((GroovyFile)file).isScript() && (thisScriptQualifiedName = Objects.requireNonNull(((GroovyFile)file).getScriptClass()).getQualifiedName()) != null && InheritanceUtil.isInheritor((PsiType)type2, (String)thisScriptQualifiedName)) {
                    String typeText = type2.getCanonicalText();
                    holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("declared.type.0.extends.1.which.is.circular.inheritance", typeText, thisScriptQualifiedName)).range((PsiElement)annotation).create();
                }
            } else if ((pparent instanceof GrPackageDefinition || pparent instanceof GrImportStatement) && !InheritanceUtil.isInheritor((PsiClass)(clazz = GrAnnotationUtil.inferClassAttribute(annotation, "value")), (String)"groovy.lang.Script")) {
                String typeText = this.getTypeText(clazz);
                holder.newAnnotation(HighlightSeverity.ERROR, GroovyBundle.message("declared.type.0.have.to.extend.script", typeText)).range((PsiElement)annotation).create();
            }
        }
        return false;
    }

    @NotNull
    @NlsSafe
    public String getTypeText(@Nullable PsiClass clazz) {
        if (clazz == null) {
            return "java.lang.Object";
        }
        String fqn = clazz.getQualifiedName();
        if (fqn != null) {
            String string = fqn;
            if (string == null) {
                BaseScriptAnnotationChecker.$$$reportNull$$$0(2);
            }
            return string;
        }
        String name = clazz.getName();
        if (name != null) {
            String string = name;
            if (string == null) {
                BaseScriptAnnotationChecker.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "java.lang.Object";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/checkers/BaseScriptAnnotationChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/checkers/BaseScriptAnnotationChecker";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkApplicability";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

