/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;

public class GroovyInfiniteLoopStatementInspection
extends BaseInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.ref.statement.cannot.complete.without.throwing.exception", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
            if (whileStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(whileStatement);
            if (ControlFlowUtils.statementMayCompleteNormally(whileStatement)) {
                return;
            }
            if (ControlFlowUtils.statementContainsReturn(whileStatement)) {
                return;
            }
            this.registerStatementError(whileStatement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyInfiniteLoopStatementInspection$Visitor", "visitWhileStatement"));
        }
    }
}

