/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.wsl;

import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.target.HostPort;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.util.PathMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.IncorrectGradleJdkIssue;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.service.execution.GradleServerConfigurationProvider;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;
import org.jetbrains.plugins.gradle.service.execution.wsl.WslBuildLayoutParameters;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\bH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/wsl/GradleOnWslExecutionAware;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionAware;", "()V", "getBuildLayoutParameters", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "", "getDefaultBuildLayoutParameters", "getEnvironmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "runConfiguration", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfiguration;", "isPreviewMode", "", "getTargetPathMapper", "Lcom/intellij/util/PathMapper;", "wslDistribution", "Lcom/intellij/execution/wsl/WSLDistribution;", "getWslEnvironmentProvider", "Lorg/jetbrains/plugins/gradle/service/execution/GradleServerConfigurationProvider;", "path", "targetName", "isGradleInstallationHomeDir", "homePath", "isRemoteRun", "prepareExecution", "", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "externalProjectPath", "taskNotificationListener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "resolveWslDistribution", "intellij.gradle.common"})
@ApiStatus.Internal
public final class GradleOnWslExecutionAware
implements GradleExecutionAware {
    public void prepareExecution(@NotNull ExternalSystemTask task2, @NotNull String externalProjectPath2, boolean isPreviewMode, @NotNull ExternalSystemTaskNotificationListener taskNotificationListener, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath2, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)taskNotificationListener, (String)"taskNotificationListener");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (isPreviewMode) {
            return;
        }
        WSLDistribution wSLDistribution = this.resolveWslDistribution(externalProjectPath2);
        if (wSLDistribution == null) {
            return;
        }
        WSLDistribution wslDistribution = wSLDistribution;
        SdkLookupProvider.SdkInfo sdkInfo2 = new LocalGradleExecutionAware().prepareJvmForExecution(task2, externalProjectPath2, taskNotificationListener, project);
        if (!(sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolved)) {
            return;
        }
        String string2 = ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo2).getHomePath();
        if (string2 == null) {
            return;
        }
        String homePath = string2;
        WSLDistribution jdkWslDistribution = WslPath.Companion.getDistributionByWindowsUncPath(homePath);
        WSLDistribution wSLDistribution2 = jdkWslDistribution;
        if (!Intrinsics.areEqual((Object)wslDistribution.getId(), (Object)(wSLDistribution2 != null ? wSLDistribution2.getId() : null))) {
            boolean isResolveProjectTask = task2 instanceof ExternalSystemResolveProjectTask;
            String distributionPath = ((Object)wslDistribution.getUNCRootPath()).toString();
            String string3 = wslDistribution.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPresentableName(...)");
            String distributionName = string3;
            Object[] objectArray = new Object[]{distributionName, distributionPath};
            String message = GradleBundle.message("gradle.incorrect.jvm.wsl.issue.description", objectArray);
            Intrinsics.checkNotNull((Object)message);
            throw new BuildIssueException((BuildIssue)new IncorrectGradleJdkIssue(externalProjectPath2, homePath, message, isResolveProjectTask));
        }
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String projectPath = runConfiguration.getSettings().getExternalProjectPath();
        GradleRunConfiguration gradleRunConfiguration = runConfiguration instanceof GradleRunConfiguration ? (GradleRunConfiguration)runConfiguration : null;
        if (gradleRunConfiguration == null) {
            return null;
        }
        GradleRunConfiguration gradleRunConfiguration2 = gradleRunConfiguration;
        String targetName = gradleRunConfiguration2.getOptions().getRemoteTarget();
        Intrinsics.checkNotNull((Object)projectPath);
        return this.getWslEnvironmentProvider(project, projectPath, targetName);
    }

    @Nullable
    public TargetEnvironmentConfigurationProvider getEnvironmentConfigurationProvider(@NotNull String projectPath, boolean isPreviewMode, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getWslEnvironmentProvider(project, projectPath, null);
    }

    public boolean isRemoteRun(@NotNull ExternalSystemRunConfiguration runConfiguration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String projectPath = runConfiguration.getSettings().getExternalProjectPath();
        Intrinsics.checkNotNull((Object)projectPath);
        return this.resolveWslDistribution(projectPath) != null;
    }

    @Override
    @Nullable
    public BuildLayoutParameters getDefaultBuildLayoutParameters(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object projectLocation = object;
        WSLDistribution wSLDistribution = this.resolveWslDistribution((String)projectLocation);
        if (wSLDistribution == null) {
            return null;
        }
        WSLDistribution wslDistribution = wSLDistribution;
        return new WslBuildLayoutParameters(wslDistribution, project, null);
    }

    @Override
    @Nullable
    public BuildLayoutParameters getBuildLayoutParameters(@NotNull Project project, @NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        WSLDistribution wSLDistribution = this.resolveWslDistribution(projectPath);
        if (wSLDistribution == null) {
            return null;
        }
        WSLDistribution wslDistribution = wSLDistribution;
        return new WslBuildLayoutParameters(wslDistribution, project, projectPath);
    }

    @Override
    public boolean isGradleInstallationHomeDir(@NotNull Project project, @NotNull String homePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        String string2 = project.getBasePath();
        if (string2 == null) {
            return false;
        }
        WSLDistribution wSLDistribution = this.resolveWslDistribution(string2);
        if (wSLDistribution == null) {
            return false;
        }
        WSLDistribution wslDistribution = wSLDistribution;
        String string3 = wslDistribution.getWindowsPath(homePath);
        if (string3 == null) {
            return false;
        }
        String windowsPath = string3;
        return new LocalGradleExecutionAware().isGradleInstallationHomeDir(project, windowsPath);
    }

    private final PathMapper getTargetPathMapper(WSLDistribution wslDistribution) {
        return new PathMapper(wslDistribution){
            final /* synthetic */ WSLDistribution $wslDistribution;
            {
                this.$wslDistribution = $wslDistribution;
            }

            public boolean isEmpty() {
                return false;
            }

            public boolean canReplaceLocal(@NotNull String localPath) {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                return true;
            }

            @NotNull
            public String convertToLocal(@NotNull String remotePath) {
                Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
                String string2 = this.$wslDistribution.getWindowsPath(remotePath);
                if (string2 == null) {
                    string2 = remotePath;
                }
                return string2;
            }

            public boolean canReplaceRemote(@NotNull String remotePath) {
                Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
                return true;
            }

            @NotNull
            public String convertToRemote(@NotNull String localPath) {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                String string2 = this.$wslDistribution.getWslPath(localPath);
                if (string2 == null) {
                    string2 = localPath;
                }
                return string2;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<String> convertToRemote(@NotNull Collection<String> paths) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Iterable $this$map$iv = paths;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.convertToRemote((String)it));
                }
                return (List)destination$iv$iv;
            }
        };
    }

    private final GradleServerConfigurationProvider getWslEnvironmentProvider(Project project, String path, String targetName) {
        WslTargetEnvironmentConfiguration wslEnvironmentConfiguration;
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration;
        TargetEnvironmentConfiguration targetEnvironmentConfiguration;
        String string2 = targetName;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            v1 = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.Companion.getInstance(project).getTargets().findByName(it);
        } else {
            v1 = targetEnvironmentConfiguration = null;
        }
        if (((wslTargetEnvironmentConfiguration = (wslEnvironmentConfiguration = targetEnvironmentConfiguration instanceof WslTargetEnvironmentConfiguration ? (WslTargetEnvironmentConfiguration)targetEnvironmentConfiguration : null)) == null || (wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.getDistribution()) == null) && (wslTargetEnvironmentConfiguration = this.resolveWslDistribution(path)) == null) {
            return null;
        }
        WslTargetEnvironmentConfiguration wslDistribution = wslTargetEnvironmentConfiguration;
        return new GradleServerConfigurationProvider(this, (WSLDistribution)wslDistribution, wslEnvironmentConfiguration){
            @NotNull
            private final Lazy environmentConfiguration$delegate;
            @NotNull
            private final PathMapper pathMapper;
            final /* synthetic */ WSLDistribution $wslDistribution;
            {
                this.$wslDistribution = $wslDistribution;
                this.environmentConfiguration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WslTargetEnvironmentConfiguration>($wslEnvironmentConfiguration, $wslDistribution){
                    final /* synthetic */ WslTargetEnvironmentConfiguration $wslEnvironmentConfiguration;
                    final /* synthetic */ WSLDistribution $wslDistribution;
                    {
                        this.$wslEnvironmentConfiguration = $wslEnvironmentConfiguration;
                        this.$wslDistribution = $wslDistribution;
                        super(0);
                    }

                    @NotNull
                    public final WslTargetEnvironmentConfiguration invoke() {
                        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration = this.$wslEnvironmentConfiguration;
                        if (wslTargetEnvironmentConfiguration == null) {
                            wslTargetEnvironmentConfiguration = new WslTargetEnvironmentConfiguration(this.$wslDistribution);
                        }
                        return wslTargetEnvironmentConfiguration;
                    }
                }));
                this.pathMapper = GradleOnWslExecutionAware.access$getTargetPathMapper($receiver, $wslDistribution);
            }

            @NotNull
            public WslTargetEnvironmentConfiguration getEnvironmentConfiguration() {
                Lazy lazy = this.environmentConfiguration$delegate;
                return (WslTargetEnvironmentConfiguration)lazy.getValue();
            }

            @NotNull
            public PathMapper getPathMapper() {
                return this.pathMapper;
            }

            @NotNull
            public HostPort getServerBindingAddress(@NotNull TargetEnvironmentConfiguration targetEnvironmentConfiguration) {
                Intrinsics.checkNotNullParameter((Object)targetEnvironmentConfiguration, (String)"targetEnvironmentConfiguration");
                String string2 = this.$wslDistribution.getWslIpAddress().getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHostAddress(...)");
                return new HostPort(string2, 0);
            }
        };
    }

    private final WSLDistribution resolveWslDistribution(String path) {
        if (!WSLUtil.isSystemCompatible()) {
            return null;
        }
        return WslPath.Companion.getDistributionByWindowsUncPath(path);
    }

    public static final /* synthetic */ PathMapper access$getTargetPathMapper(GradleOnWslExecutionAware $this, WSLDistribution wslDistribution) {
        return $this.getTargetPathMapper(wslDistribution);
    }
}

