/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.config;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/config/MavenConfigAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "isConfigFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenConfigAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenConfigAnnotator.kt\norg/jetbrains/idea/maven/config/MavenConfigAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n288#2,2:34\n*S KotlinDebug\n*F\n+ 1 MavenConfigAnnotator.kt\norg/jetbrains/idea/maven/config/MavenConfigAnnotator\n*L\n23#1:34,2\n*E\n"})
public final class MavenConfigAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof PsiPlainTextFileImpl) {
            Object v2;
            block6: {
                VirtualFile elementFile = ((PsiPlainTextFileImpl)element).getContainingFile().getVirtualFile();
                if (!this.isConfigFile(elementFile)) {
                    return;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(element.getProject());
                if (!manager.isMavenizedProject()) {
                    return;
                }
                List<MavenProject> list = manager.getRootProjects();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRootProjects(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MavenProject it = (MavenProject)element$iv;
                    boolean bl = false;
                    VirtualFile virtualFile = elementFile.getParent();
                    if (!Intrinsics.areEqual((Object)it.getDirectoryFile(), (Object)(virtualFile != null ? virtualFile.getParent() : null))) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            MavenProject mavenProject2 = v2;
            if (mavenProject2 == null) {
                return;
            }
            MavenProject mavenProject3 = mavenProject2;
            String string = mavenProject3.getConfigFileError();
            if (string == null) {
                return;
            }
            String error = string;
            holder.newAnnotation(HighlightSeverity.ERROR, error).create();
        }
    }

    private final boolean isConfigFile(VirtualFile file) {
        VirtualFile virtualFile = file;
        Object object = virtualFile != null ? virtualFile.getParent() : null;
        if (object == null) {
            return false;
        }
        VirtualFile parent = object;
        return Intrinsics.areEqual((Object)file.getName(), (Object)"maven.config") && Intrinsics.areEqual((Object)parent.getName(), (Object)".mvn");
    }
}

