/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenImportStatsKt;
import org.jetbrains.idea.maven.importing.MavenLegacyModuleImporter;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.statistics.MavenImportCollector;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b'\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0004R\u0010\u0010\b\u001a\u00020\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterBase;", "Lorg/jetbrains/idea/maven/importing/MavenProjectImporter;", "myProject", "Lcom/intellij/openapi/project/Project;", "myProjectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "myImportingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "myIdeModifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lorg/jetbrains/idea/maven/project/MavenImportingSettings;Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;)V", "myModelsProvider", "selectProjectsToImport", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "originalProjects", "", "shouldCreateModuleFor", "", "project", "Companion", "RefreshingFilesTask", "intellij.maven"})
@ApiStatus.Internal
public abstract class MavenProjectImporterBase
implements MavenProjectImporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Project myProject;
    @JvmField
    @NotNull
    protected final MavenProjectsTree myProjectsTree;
    @JvmField
    @NotNull
    protected final MavenImportingSettings myImportingSettings;
    @JvmField
    @NotNull
    protected final IdeModifiableModelsProvider myIdeModifiableModelsProvider;
    @JvmField
    @NotNull
    protected final IdeModifiableModelsProvider myModelsProvider;

    public MavenProjectImporterBase(@NotNull Project myProject, @NotNull MavenProjectsTree myProjectsTree, @NotNull MavenImportingSettings myImportingSettings, @NotNull IdeModifiableModelsProvider myIdeModifiableModelsProvider) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myProjectsTree, (String)"myProjectsTree");
        Intrinsics.checkNotNullParameter((Object)myImportingSettings, (String)"myImportingSettings");
        Intrinsics.checkNotNullParameter((Object)myIdeModifiableModelsProvider, (String)"myIdeModifiableModelsProvider");
        this.myProject = myProject;
        this.myProjectsTree = myProjectsTree;
        this.myImportingSettings = myImportingSettings;
        this.myModelsProvider = this.myIdeModifiableModelsProvider = myIdeModifiableModelsProvider;
    }

    @NotNull
    protected final Set<MavenProject> selectProjectsToImport(@NotNull Collection<? extends MavenProject> originalProjects) {
        Intrinsics.checkNotNullParameter(originalProjects, (String)"originalProjects");
        Set result2 = new HashSet();
        for (MavenProject mavenProject2 : originalProjects) {
            if (!this.shouldCreateModuleFor(mavenProject2)) continue;
            result2.add(mavenProject2);
        }
        return result2;
    }

    protected final boolean shouldCreateModuleFor(@NotNull MavenProject project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.myProjectsTree.isIgnored(project2) ? false : !project2.isAggregator() || this.myImportingSettings.isCreateModulesForAggregators();
    }

    @JvmStatic
    public static final void importExtensions(@NotNull Project project2, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<MavenLegacyModuleImporter.ExtensionImporter> extensionImporters, @NotNull List<? extends MavenProjectsProcessorTask> postTasks, @NotNull StructuredIdeActivity activity) {
        Companion.importExtensions(project2, modifiableModelsProvider, extensionImporters, postTasks, activity);
    }

    @JvmStatic
    public static final void scheduleRefreshResolvedArtifacts(@NotNull List<MavenProjectsProcessorTask> postTasks, @NotNull Iterable<? extends MavenProject> projectsToRefresh) {
        Companion.scheduleRefreshResolvedArtifacts(postTasks, projectsToRefresh);
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void removeOutdatedCompilerConfigSettings(@NotNull Project project2) {
        Companion.removeOutdatedCompilerConfigSettings(project2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0004J<\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u0015\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0007\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterBase$Companion;", "", "()V", "doRefreshFiles", "", "files", "", "Ljava/io/File;", "importExtensions", "project", "Lcom/intellij/openapi/project/Project;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "extensionImporters", "", "Lorg/jetbrains/idea/maven/importing/MavenLegacyModuleImporter$ExtensionImporter;", "postTasks", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "activity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "removeOutdatedCompilerConfigSettings", "scheduleRefreshResolvedArtifacts", "", "projectsToRefresh", "", "Lorg/jetbrains/idea/maven/project/MavenProject;", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenProjectImporterBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectImporterBase.kt\norg/jetbrains/idea/maven/importing/MavenProjectImporterBase$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n766#2:146\n857#2,2:147\n*S KotlinDebug\n*F\n+ 1 MavenProjectImporterBase.kt\norg/jetbrains/idea/maven/importing/MavenProjectImporterBase$Companion\n*L\n68#1:146\n68#1:147,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        public final void importExtensions(@NotNull Project project2, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<MavenLegacyModuleImporter.ExtensionImporter> extensionImporters, @NotNull List<? extends MavenProjectsProcessorTask> postTasks, @NotNull StructuredIdeActivity activity) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
            Intrinsics.checkNotNullParameter(extensionImporters, (String)"extensionImporters");
            Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Iterable $this$filter$iv = extensionImporters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MavenLegacyModuleImporter.ExtensionImporter it = (MavenLegacyModuleImporter.ExtensionImporter)element$iv$iv;
                boolean bl = false;
                if (!(!it.isModuleDisposed())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List importers = (List)destination$iv$iv;
            if (importers.isEmpty()) {
                return;
            }
            long beforeBridgesCreation = System.nanoTime();
            IdeUIModifiableModelsProvider ideUIModifiableModelsProvider = modifiableModelsProvider instanceof IdeUIModifiableModelsProvider ? (IdeUIModifiableModelsProvider)modifiableModelsProvider : null;
            destination$iv$iv = ideUIModifiableModelsProvider != null ? (IdeModifiableModelsProvider)ideUIModifiableModelsProvider : ProjectDataManager.getInstance().createModifiableModelsProvider(project2);
            Intrinsics.checkNotNull((Object)destination$iv$iv);
            Collection provider = destination$iv$iv;
            long bridgesCreationNano = System.nanoTime() - beforeBridgesCreation;
            try {
                long beforeInitInit = System.nanoTime();
                importers.forEach(arg_0 -> Companion.importExtensions$lambda$1((IdeModifiableModelsProvider)provider, arg_0));
                bridgesCreationNano += System.nanoTime() - beforeInitInit;
                Map counters = new HashMap();
                importers.forEach(arg_0 -> Companion.importExtensions$lambda$2(counters, arg_0));
                importers.forEach(arg_0 -> Companion.importExtensions$lambda$3(postTasks, counters, arg_0));
                importers.forEach(arg_0 -> Companion.importExtensions$lambda$4(counters, arg_0));
                for (Map.Entry eventPairArray2 : counters.entrySet()) {
                    Class key = (Class)eventPairArray2.getKey();
                    MavenLegacyModuleImporter.ExtensionImporter.CountAndTime value = (MavenLegacyModuleImporter.ExtensionImporter.CountAndTime)eventPairArray2.getValue();
                    EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.IMPORTER_CLASS.with((Object)key), MavenImportCollector.NUMBER_OF_MODULES.with((Object)value.getCount()), MavenImportCollector.TOTAL_DURATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(value.getTimeNano()))};
                    MavenImportCollector.IMPORTER_RUN.log(project2, eventPairArray);
                }
            }
            catch (Throwable throwable) {
                long beforeCommit = System.nanoTime();
                MavenUtil.invokeAndWaitWriteAction(project2, () -> Companion.importExtensions$lambda$6(project2, (IdeModifiableModelsProvider)provider));
                long afterCommit = System.nanoTime();
                EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_CREATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(bridgesCreationNano)), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_COMMIT_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(afterCommit - beforeCommit))};
                MavenImportCollector.LEGACY_IMPORTERS_STATS.log(project2, eventPairArray);
                throw throwable;
            }
            long beforeCommit = System.nanoTime();
            MavenUtil.invokeAndWaitWriteAction(project2, () -> Companion.importExtensions$lambda$6(project2, (IdeModifiableModelsProvider)provider));
            long afterCommit = System.nanoTime();
            EventPair[] eventPairArray = new EventPair[]{MavenImportCollector.ACTIVITY_ID.with((Object)activity), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_CREATION_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(bridgesCreationNano)), MavenImportCollector.DURATION_OF_LEGACY_BRIDGES_COMMIT_MS.with((Object)TimeUnit.NANOSECONDS.toMillis(afterCommit - beforeCommit))};
            MavenImportCollector.LEGACY_IMPORTERS_STATS.log(project2, eventPairArray);
        }

        @JvmStatic
        public final void scheduleRefreshResolvedArtifacts(@NotNull List<MavenProjectsProcessorTask> postTasks, @NotNull Iterable<? extends MavenProject> projectsToRefresh) {
            Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
            Intrinsics.checkNotNullParameter(projectsToRefresh, (String)"projectsToRefresh");
            HashSet<File> files2 = new HashSet<File>();
            for (MavenProject mavenProject2 : projectsToRefresh) {
                for (MavenArtifact dependency : mavenProject2.getDependencies()) {
                    files2.add(dependency.getFile());
                }
            }
            if (MavenUtil.isMavenUnitTestModeEnabled()) {
                this.doRefreshFiles((Set<? extends File>)files2);
            } else {
                postTasks.add(new RefreshingFilesTask((Set<? extends File>)files2));
            }
        }

        @JvmStatic
        @ApiStatus.Internal
        public final void removeOutdatedCompilerConfigSettings(@NotNull Project project2) {
            String options;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            JpsJavaCompilerOptions javacOptions = JavacConfiguration.getOptions((Project)project2, JavacConfiguration.class);
            CharSequence charSequence = options = javacOptions.ADDITIONAL_OPTIONS_STRING;
            Intrinsics.checkNotNull((Object)charSequence);
            charSequence = charSequence;
            Regex regex = new Regex("(-target (\\S+))");
            String string = "";
            javacOptions.ADDITIONAL_OPTIONS_STRING = options = regex.replaceFirst(charSequence, string);
        }

        protected final void doRefreshFiles(@NotNull Set<? extends File> files2) {
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            LocalFileSystem.getInstance().refreshIoFiles((Iterable)files2);
        }

        private static final void importExtensions$lambda$1(IdeModifiableModelsProvider $provider, MavenLegacyModuleImporter.ExtensionImporter importer) {
            Intrinsics.checkNotNullParameter((Object)$provider, (String)"$provider");
            Intrinsics.checkNotNullParameter((Object)importer, (String)"importer");
            importer.init($provider);
        }

        private static final void importExtensions$lambda$2(Map $counters, MavenLegacyModuleImporter.ExtensionImporter it) {
            Intrinsics.checkNotNullParameter((Object)$counters, (String)"$counters");
            it.preConfig($counters);
        }

        private static final void importExtensions$lambda$3(List $postTasks, Map $counters, MavenLegacyModuleImporter.ExtensionImporter it) {
            Intrinsics.checkNotNullParameter((Object)$postTasks, (String)"$postTasks");
            Intrinsics.checkNotNullParameter((Object)$counters, (String)"$counters");
            it.config($postTasks, $counters);
        }

        private static final void importExtensions$lambda$4(Map $counters, MavenLegacyModuleImporter.ExtensionImporter it) {
            Intrinsics.checkNotNullParameter((Object)$counters, (String)"$counters");
            it.postConfig($counters);
        }

        private static final void importExtensions$lambda$6$lambda$5(IdeModifiableModelsProvider $provider) {
            Intrinsics.checkNotNullParameter((Object)$provider, (String)"$provider");
            $provider.commit();
        }

        private static final void importExtensions$lambda$6(Project $project, IdeModifiableModelsProvider $provider) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$provider, (String)"$provider");
            ProjectRootManagerEx.getInstanceEx((Project)$project).mergeRootsChangesDuring(() -> Companion.importExtensions$lambda$6$lambda$5($provider));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenProjectImporterBase$RefreshingFilesTask;", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "myFiles", "", "Ljava/io/File;", "(Ljava/util/Set;)V", "doPerform", "", "indicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "perform", "project", "Lcom/intellij/openapi/project/Project;", "embeddersManager", "Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "console", "Lorg/jetbrains/idea/maven/project/MavenConsole;", "intellij.maven"})
    protected static final class RefreshingFilesTask
    implements MavenProjectsProcessorTask {
        @NotNull
        private final Set<File> myFiles;

        public RefreshingFilesTask(@NotNull Set<? extends File> myFiles) {
            Intrinsics.checkNotNullParameter(myFiles, (String)"myFiles");
            this.myFiles = myFiles;
        }

        @Override
        public void perform(@NotNull Project project2, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull MavenProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)embeddersManager, (String)"embeddersManager");
            Intrinsics.checkNotNullParameter((Object)console, (String)"console");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
            MavenImportStatsKt.runImportActivitySync(project2, projectSystemId, RefreshingFilesTask.class, (Function0)new Function0<Unit>(this, indicator){
                final /* synthetic */ RefreshingFilesTask this$0;
                final /* synthetic */ MavenProgressIndicator $indicator;
                {
                    this.this$0 = $receiver;
                    this.$indicator = $indicator;
                    super(0);
                }

                public final void invoke() {
                    RefreshingFilesTask.access$doPerform(this.this$0, this.$indicator);
                }
            });
        }

        private final void doPerform(MavenProgressIndicator indicator) {
            indicator.setText(MavenProjectBundle.message("progress.text.refreshing.files", new Object[0]));
            Companion.doRefreshFiles(this.myFiles);
        }

        public static final /* synthetic */ void access$doPerform(RefreshingFilesTask $this, MavenProgressIndicator indicator) {
            $this.doPerform(indicator);
        }
    }
}

