/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.build.issue.BuildIssue;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.issue.BuildIssueException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.MavenVersionSupportUtil;
import org.jetbrains.idea.maven.buildtool.quickfix.InstallMaven2BuildIssue;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.slf4j.Logger;
import org.slf4j.jul.JDK14LoggerFactory;

public class MavenServerCMDState
extends CommandLineState {
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance(MavenServerCMDState.class);
    private static boolean setupThrowMainClass = false;
    @NonNls
    private static final String MAIN_CLASS = "org.jetbrains.idea.maven.server.RemoteMavenServer";
    @NonNls
    private static final String MAIN_CLASS36 = "org.jetbrains.idea.maven.server.RemoteMavenServer36";
    @NonNls
    private static final String MAIN_CLASS40 = "com.intellij.maven.server.m40.RemoteMavenServer40";
    @NonNls
    private static final String MAIN_CLASS_WITH_EXCEPTION_FOR_TESTS = "org.jetbrains.idea.maven.server.RemoteMavenServerThrowsExceptionForTests";
    protected final Sdk myJdk;
    protected final String myVmOptions;
    protected final MavenDistribution myDistribution;
    protected final Integer myDebugPort;

    public MavenServerCMDState(@NotNull Sdk jdk2, @Nullable String vmOptions, @NotNull MavenDistribution mavenDistribution, @Nullable Integer debugPort) {
        if (jdk2 == null) {
            MavenServerCMDState.$$$reportNull$$$0(0);
        }
        if (mavenDistribution == null) {
            MavenServerCMDState.$$$reportNull$$$0(1);
        }
        super(null);
        this.myJdk = jdk2;
        this.myVmOptions = vmOptions;
        this.myDistribution = mavenDistribution;
        this.myDebugPort = debugPort;
    }

    protected SimpleJavaParameters createJavaParameters() {
        String mavenEmbedderCliOptions;
        SimpleJavaParameters params = new SimpleJavaParameters();
        params.setJdk(this.myJdk);
        params.setWorkingDirectory(this.getWorkingDirectory());
        HashMap<String, String> defs = new HashMap<String, String>(this.getMavenOpts());
        MavenServerCMDState.configureSslRelatedOptions(defs);
        defs.put("java.awt.headless", "true");
        for (Map.Entry each : defs.entrySet()) {
            params.getVMParametersList().defineProperty((String)each.getKey(), (String)each.getValue());
        }
        params.getVMParametersList().addProperty("maven.defaultProjectBuilder.disableGlobalModelCache", "true");
        if (this.myDebugPort != null) {
            params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=*:" + this.myDebugPort);
            params.getProgramParametersList().add("runWithDebugger");
        }
        params.getVMParametersList().addProperty("maven.defaultProjectBuilder.disableGlobalModelCache", "true");
        if (Registry.is((String)"maven.collect.local.stat")) {
            params.getVMParametersList().addProperty("maven.collect.local.stat", "true");
        }
        Object xmxProperty = null;
        String xmsProperty = null;
        if (this.myVmOptions != null) {
            ParametersList mavenOptsList = new ParametersList();
            mavenOptsList.addParametersString(this.myVmOptions);
            for (String param : mavenOptsList.getParameters()) {
                if (param.startsWith("-Xmx")) {
                    xmxProperty = param;
                    continue;
                }
                if (param.startsWith("-Xms")) {
                    xmsProperty = param;
                    continue;
                }
                if (Registry.is((String)"maven.server.vm.remove.javaagent") && param.startsWith("-javaagent")) continue;
                params.getVMParametersList().add(param);
            }
        }
        params.getVMParametersList().add("-Didea.version=" + MavenUtil.getIdeaVersionToPassToMavenProcess());
        MavenServerCMDState.setupMainClass(params, this.myDistribution.getVersion());
        params.getVMParametersList().addProperty("idea.maven.embedder.version", this.myDistribution.getVersion());
        params.getClassPath().addAllFiles(MavenServerCMDState.collectClassPathAndLibsFolder(this.myDistribution));
        Collection<String> classPath = this.collectRTLibraries(this.myDistribution.getVersion());
        for (String s : classPath) {
            params.getClassPath().add(s);
        }
        String embedderXmx = System.getProperty("idea.maven.embedder.xmx");
        if (embedderXmx != null) {
            xmxProperty = "-Xmx" + embedderXmx;
        } else if (xmxProperty == null) {
            xmxProperty = MavenServerCMDState.getMaxXmxStringValue("-Xmx768m", xmsProperty);
        }
        params.getVMParametersList().add(xmsProperty);
        params.getVMParametersList().add((String)xmxProperty);
        String mavenEmbedderParameters = System.getProperty("idea.maven.embedder.parameters");
        if (mavenEmbedderParameters != null) {
            params.getProgramParametersList().addParametersString(mavenEmbedderParameters);
        }
        if ((mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args")) != null) {
            params.getVMParametersList().addProperty("idea.maven.embedder.ext.cli.args", mavenEmbedderCliOptions);
        }
        this.setupMainExt(params);
        return params;
    }

    @NotNull
    public static List<File> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            MavenServerCMDState.$$$reportNull$$$0(2);
        }
        if (!distribution.isValid()) {
            MavenLog.LOG.warn("Maven Distribution " + distribution + " is not valid");
            throw new IllegalArgumentException("Maven distribution at" + distribution.getMavenHome().toAbsolutePath() + " is not valid");
        }
        MavenVersionAwareSupportExtension extension = MavenVersionSupportUtil.getExtensionFor(distribution);
        if (extension == null) {
            if (StringUtil.compareVersionNumbers((String)distribution.getVersion(), (String)"3") < 0) {
                throw new BuildIssueException((BuildIssue)new InstallMaven2BuildIssue());
            }
            throw new IllegalStateException("Maven distribution at" + distribution.getMavenHome().toAbsolutePath() + " is not supported");
        }
        MavenLog.LOG.info("Using extension " + extension + " to start MavenServer");
        List<File> list = extension.collectClassPathAndLibsFolder(distribution);
        if (list == null) {
            MavenServerCMDState.$$$reportNull$$$0(3);
        }
        return list;
    }

    private void setupMainExt(SimpleJavaParameters params) {
        MavenUtil.addEventListener(this.myDistribution.getVersion(), params);
    }

    private static void configureSslRelatedOptions(Map<String, String> defs) {
        for (Map.Entry<Object, Object> each : System.getProperties().entrySet()) {
            Object key = each.getKey();
            Object value = each.getValue();
            if (!(key instanceof String) || !(value instanceof String) || !((String)key).startsWith("javax.net.ssl")) continue;
            defs.put((String)key, (String)value);
        }
    }

    protected Map<String, String> getMavenOpts() {
        return MavenUtil.getPropertiesFromMavenOpts();
    }

    @NotNull
    protected String getWorkingDirectory() {
        String string = PathManager.getBinPath();
        if (string == null) {
            MavenServerCMDState.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected Collection<String> collectRTLibraries(String mavenVersion) {
        LinkedHashSet<String> classPath = new LinkedHashSet<String>();
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
            classPath.add(PathUtil.getJarPathForClass(Logger.class));
            classPath.add(PathUtil.getJarPathForClass(JDK14LoggerFactory.class));
        }
        classPath.add(PathUtil.getJarPathForClass(StringUtilRt.class));
        classPath.add(PathUtil.getJarPathForClass(NotNull.class));
        classPath.add(PathUtil.getJarPathForClass(Element.class));
        LinkedHashSet<String> linkedHashSet = classPath;
        if (linkedHashSet == null) {
            MavenServerCMDState.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    private static void setupMainClass(SimpleJavaParameters params, String mavenVersion) {
        if (setupThrowMainClass && MavenUtil.isMavenUnitTestModeEnabled()) {
            setupThrowMainClass = false;
            params.setMainClass(MAIN_CLASS_WITH_EXCEPTION_FOR_TESTS);
        } else if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"4.0") >= 0) {
            params.setMainClass(MAIN_CLASS40);
        } else if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
            params.setMainClass(MAIN_CLASS36);
        } else {
            params.setMainClass(MAIN_CLASS);
        }
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (executor == null) {
            MavenServerCMDState.$$$reportNull$$$0(6);
        }
        if (runner == null) {
            MavenServerCMDState.$$$reportNull$$$0(7);
        }
        ProcessHandler processHandler = this.startProcess();
        return new DefaultExecutionResult(processHandler);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        SimpleJavaParameters params = this.createJavaParameters();
        GeneralCommandLine commandLine = params.toCommandLine();
        OSProcessHandler.Silent processHandler = new OSProcessHandler.Silent(commandLine);
        processHandler.setShouldDestroyProcessRecursively(false);
        OSProcessHandler.Silent silent = processHandler;
        if (silent == null) {
            MavenServerCMDState.$$$reportNull$$$0(8);
        }
        return silent;
    }

    @TestOnly
    public static void setThrowExceptionOnNextServerStart() {
        setupThrowMainClass = true;
    }

    @TestOnly
    public static void resetThrowExceptionOnNextServerStart() {
        setupThrowMainClass = false;
    }

    @Nullable
    static String getMaxXmxStringValue(@Nullable String memoryValueA, @Nullable String memoryValueB) {
        MemoryProperty propertyA = MemoryProperty.valueOf(memoryValueA);
        MemoryProperty propertyB = MemoryProperty.valueOf(memoryValueB);
        if (propertyA != null && propertyB != null) {
            MemoryProperty maxMemoryProperty = propertyA.valueBytes > propertyB.valueBytes ? propertyA : propertyB;
            return MemoryProperty.of(MemoryProperty.MemoryPropertyType.XMX, maxMemoryProperty.valueBytes).toString(maxMemoryProperty.unit);
        }
        return Optional.ofNullable(propertyA).or(() -> Optional.ofNullable(propertyB)).map(property -> MemoryProperty.of(MemoryProperty.MemoryPropertyType.XMX, property.valueBytes).toString(property.unit)).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDistribution";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerCMDState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerCMDState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPathAndLibsFolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRTLibraries";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8 -> new IllegalStateException(string);
        };
    }

    private static class MemoryProperty {
        private static final Pattern MEMORY_PROPERTY_PATTERN = Pattern.compile("^(-Xmx|-Xms)(\\d+)([kK]|[mM]|[gG])?$");
        final String type;
        final long valueBytes;
        final MemoryUnit unit;

        /*
         * WARNING - void declaration
         */
        private MemoryProperty(@NotNull String type2, long value, @Nullable String string) {
            void unit;
            if (type2 == null) {
                MemoryProperty.$$$reportNull$$$0(0);
            }
            this.type = type2;
            this.unit = unit != null ? MemoryUnit.valueOf(unit.toUpperCase()) : MemoryUnit.B;
            this.valueBytes = value * (long)this.unit.ratio;
        }

        @NotNull
        public static MemoryProperty of(@NotNull MemoryPropertyType propertyType, long bytes) {
            if (propertyType == null) {
                MemoryProperty.$$$reportNull$$$0(1);
            }
            return new MemoryProperty(propertyType.type, bytes, MemoryUnit.B.name());
        }

        @Nullable
        public static MemoryProperty valueOf(@Nullable String value) {
            if (value == null) {
                return null;
            }
            Matcher matcher = MEMORY_PROPERTY_PATTERN.matcher(value);
            if (matcher.find()) {
                return new MemoryProperty(matcher.group(1), Long.parseLong(matcher.group(2)), matcher.group(3));
            }
            LOG.warn(value + " not match " + MEMORY_PROPERTY_PATTERN);
            return null;
        }

        public String toString() {
            return this.toString(this.unit);
        }

        public String toString(MemoryUnit unit) {
            return this.type + this.valueBytes / (long)unit.ratio + unit.name().toLowerCase();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerCMDState$MemoryProperty";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "of";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum MemoryUnit {
            B(1),
            K(MemoryUnit.B.ratio * 1024),
            M(MemoryUnit.K.ratio * 1024),
            G(MemoryUnit.M.ratio * 1024);

            final int ratio;

            private MemoryUnit(int ratio) {
                this.ratio = ratio;
            }
        }

        private static enum MemoryPropertyType {
            XMX("-Xmx"),
            XMS("-Xms");

            private final String type;

            private MemoryPropertyType(String type2) {
                this.type = type2;
            }
        }
    }
}

