/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards.archetype;

import com.intellij.openapi.ui.validation.DialogValidation;
import com.intellij.openapi.ui.validation.ValidationUtilKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.StringKt;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.archetype.MavenCatalog;
import org.jetbrains.idea.maven.indices.archetype.MavenCatalogManager;
import org.jetbrains.idea.maven.wizards.MavenWizardBundle;
import org.jetbrains.idea.maven.wizards.archetype.CatalogUiUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\"\u001d\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"CHECK_MAVEN_CATALOG", "Lcom/intellij/openapi/ui/validation/DialogValidation$WithParameter;", "Lkotlin/Function0;", "", "getCHECK_MAVEN_CATALOG", "()Lcom/intellij/openapi/ui/validation/DialogValidation$WithParameter;", "createCatalog", "Lorg/jetbrains/idea/maven/indices/archetype/MavenCatalog;", "location", "name", "getPathOrError", "Lkotlin/Result;", "Ljava/nio/file/Path;", "(Ljava/lang/String;)Ljava/lang/Object;", "getPathOrNull", "getUrlOrError", "Ljava/net/URL;", "getUrlOrNull", "suggestCatalogNameByLocation", "validateLocalLocation", "validateRemoteLocation", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nCatalogUiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatalogUiUtil.kt\norg/jetbrains/idea/maven/wizards/archetype/CatalogUiUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class CatalogUiUtilKt {
    @NotNull
    private static final DialogValidation.WithParameter<Function0<String>> CHECK_MAVEN_CATALOG = ValidationUtilKt.validationErrorFor((Function1)CHECK_MAVEN_CATALOG.1.INSTANCE);

    @Nullable
    public static final MavenCatalog createCatalog(@NotNull String name, @NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (MavenCatalogManager.Companion.isLocal(location)) {
            Path path2 = CatalogUiUtilKt.getPathOrNull(location);
            if (path2 == null) {
                return null;
            }
            Path path3 = path2;
            return new MavenCatalog.Local(name, path3);
        }
        URL uRL = CatalogUiUtilKt.getUrlOrNull(location);
        if (uRL == null) {
            return null;
        }
        URL url = uRL;
        return new MavenCatalog.Remote(name, url);
    }

    @Nullable
    public static final MavenCatalog createCatalog(@NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (((CharSequence)location).length() > 0) {
            String name = CatalogUiUtilKt.suggestCatalogNameByLocation(location);
            return CatalogUiUtilKt.createCatalog(name, location);
        }
        return null;
    }

    @NotNull
    public static final Object getPathOrError(@NotNull String location) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        try {
            boolean bl = false;
            String string = FileUtil.expandUserHome((String)location);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expandUserHome(...)");
            Path path2 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            object = Result.constructor-impl((Object)path2);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    @NotNull
    public static final Object getUrlOrError(@NotNull String location) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)new URL(location));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    @Nullable
    public static final Path getPathOrNull(@NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Object object = CatalogUiUtilKt.getPathOrError(location);
        return (Path)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @Nullable
    public static final URL getUrlOrNull(@NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Object object = CatalogUiUtilKt.getUrlOrError(location);
        return (URL)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @NotNull
    public static final String suggestCatalogNameByLocation(@NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (MavenCatalogManager.Companion.isLocal(location)) {
            Object object = CatalogUiUtilKt.getPathOrNull(location);
            if (object == null || (object = PathsKt.getName((Path)object)) == null || (object = StringKt.nullize$default((String)object, (boolean)false, (int)1, null)) == null) {
                object = location;
            }
            return object;
        }
        Object object = CatalogUiUtilKt.getUrlOrNull(location);
        if (object == null || (object = ((URL)object).getHost()) == null || (object = StringKt.nullize$default((String)object, (boolean)false, (int)1, null)) == null) {
            object = location;
        }
        return object;
    }

    @NotNull
    public static final DialogValidation.WithParameter<Function0<String>> getCHECK_MAVEN_CATALOG() {
        return CHECK_MAVEN_CATALOG;
    }

    private static final String validateLocalLocation(String location) {
        Object pathOrError = CatalogUiUtilKt.getPathOrError(location);
        Throwable exception = Result.exceptionOrNull-impl((Object)pathOrError);
        if (exception != null) {
            String message = exception.getMessage();
            Object[] objectArray = new Object[]{message};
            return MavenWizardBundle.message("maven.new.project.wizard.archetype.catalog.dialog.location.error.invalid", objectArray);
        }
        Object object = pathOrError;
        ResultKt.throwOnFailure((Object)object);
        Path path2 = (Path)object;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return MavenWizardBundle.message("maven.new.project.wizard.archetype.catalog.dialog.location.error.not.exists", new Object[0]);
        }
        return null;
    }

    private static final String validateRemoteLocation(String location) {
        Throwable exception = Result.exceptionOrNull-impl((Object)CatalogUiUtilKt.getUrlOrError(location));
        if (exception != null) {
            String message = exception.getMessage();
            Object[] objectArray = new Object[]{message};
            return MavenWizardBundle.message("maven.new.project.wizard.archetype.catalog.dialog.location.error.invalid", objectArray);
        }
        return null;
    }

    public static final /* synthetic */ String access$validateLocalLocation(String location) {
        return CatalogUiUtilKt.validateLocalLocation(location);
    }

    public static final /* synthetic */ String access$validateRemoteLocation(String location) {
        return CatalogUiUtilKt.validateRemoteLocation(location);
    }
}

