/*
 * Decompiled with CFR 0.152.
 */
package training.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.learn.CourseManager;
import training.learn.course.Lesson;
import training.statistic.LessonStartingWay;
import training.statistic.StatisticBase;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Ltraining/actions/PreviousLessonAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.featuresTrainer"})
final class PreviousLessonAction
extends AnAction {
    public PreviousLessonAction() {
        super(AllIcons.Actions.Back);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (UtilsKt.getLearnToolWindowForProject(project2) == null) {
            return;
        }
        Lesson previousLesson = UtilsKt.getPreviousLessonForCurrent();
        StatisticBase.Companion.logLessonStopped(StatisticBase.LessonStopReason.OPEN_NEXT_OR_PREV_LESSON);
        CourseManager.openLesson$default(CourseManager.Companion.getInstance(), project2, previousLesson, LessonStartingWay.PREV_BUTTON, false, false, 24, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Lesson lesson = UtilsKt.lessonOpenedInProject(project);
        e.getPresentation().setEnabled(lesson != null && !Intrinsics.areEqual((Object)CollectionsKt.firstOrNull(CourseManager.Companion.getInstance().getLessonsForModules()), (Object)lesson));
    }
}

