/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.embeddings.search.services;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ml.embeddings.search.indices.EmbeddingSearchIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002J'\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager;", "", "()V", "freeMemoryWithoutIndices", "", "getFreeMemoryWithoutIndices", "()J", "freeMemoryWithoutIndices$delegate", "Lkotlin/Lazy;", "mutex", "Ljava/util/concurrent/locks/ReentrantLock;", "trackedIndices", "", "Lcom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager$IndexMemoryInfo;", "estimateTotalEmbeddingsMemoryUsage", "registerIndex", "", "index", "Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;", "weight", "", "strongLimit", "(Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;ILjava/lang/Integer;)V", "shouldRestrictMemoryUsage", "", "totalMemoryLimitForEmbeddings", "Companion", "IndexMemoryInfo", "intellij.platform.ml.embeddings"})
@SourceDebugExtension(value={"SMAP\nEmbeddingIndexMemoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddingIndexMemoryManager.kt\ncom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n1747#2,3:56\n1855#2,2:60\n1#3:59\n12#4,5:62\n*S KotlinDebug\n*F\n+ 1 EmbeddingIndexMemoryManager.kt\ncom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager\n*L\n32#1:56,3\n35#1:60,2\n39#1:62,5\n*E\n"})
public final class EmbeddingIndexMemoryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<IndexMemoryInfo> trackedIndices = new ArrayList();
    @NotNull
    private final Lazy freeMemoryWithoutIndices$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
        final /* synthetic */ EmbeddingIndexMemoryManager this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Long invoke() {
            return Runtime.getRuntime().freeMemory() + EmbeddingIndexMemoryManager.access$estimateTotalEmbeddingsMemoryUsage(this.this$0);
        }
    }));
    @NotNull
    private final ReentrantLock mutex = new ReentrantLock();
    @NotNull
    private static final Logger logger;

    private final long getFreeMemoryWithoutIndices() {
        Lazy lazy = this.freeMemoryWithoutIndices$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void registerIndex(@NotNull EmbeddingSearchIndex index, int weight, @Nullable Integer strongLimit) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Lock lock = this.mutex;
        lock.lock();
        try {
            IndexMemoryInfo it;
            Object element$iv2;
            boolean bl;
            block11: {
                boolean bl2 = false;
                Iterable $this$any$iv = this.trackedIndices;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        it = (IndexMemoryInfo)element$iv2;
                        boolean bl3 = false;
                        if (!(it.getIndex() == index)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl || !this.shouldRestrictMemoryUsage()) {
                return;
            }
            this.trackedIndices.add(new IndexMemoryInfo(index, weight, strongLimit));
            Iterable $i$f$any = this.trackedIndices;
            int n = 0;
            element$iv2 = $i$f$any.iterator();
            while (element$iv2.hasNext()) {
                void it2;
                IndexMemoryInfo bl3 = it = element$iv2.next();
                int n2 = n;
                boolean bl4 = false;
                int n3 = it2.getWeight();
                n = n2 + n3;
            }
            int totalWeight = n;
            Iterable $this$forEach$iv = this.trackedIndices;
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                IndexMemoryInfo it3 = (IndexMemoryInfo)element$iv3;
                boolean bl5 = false;
                int estimatedLimit = it3.getIndex().estimateLimitByMemory(this.totalMemoryLimitForEmbeddings() * (long)it3.getWeight() / (long)totalWeight);
                it3.getIndex().setLimit(it3.getStrongLimit() != null ? Integer.valueOf(Math.min(estimatedLimit, it3.getStrongLimit())) : Integer.valueOf(estimatedLimit));
            }
            Logger $this$debug_u24default$iv = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl6 = false;
                logger.debug("Registered index in memory manager, weight: " + weight + ", strong limit: " + strongLimit, e$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void registerIndex$default(EmbeddingIndexMemoryManager embeddingIndexMemoryManager, EmbeddingSearchIndex embeddingSearchIndex, int n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        embeddingIndexMemoryManager.registerIndex(embeddingSearchIndex, n, n2);
    }

    private final boolean shouldRestrictMemoryUsage() {
        return Registry.is((String)"search.everywhere.ml.semantic.indexing.restrict.memory.usage");
    }

    private final long totalMemoryLimitForEmbeddings() {
        return this.getFreeMemoryWithoutIndices() / (long)4;
    }

    /*
     * WARNING - void declaration
     */
    private final long estimateTotalEmbeddingsMemoryUsage() {
        Iterable iterable = this.trackedIndices;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            IndexMemoryInfo indexMemoryInfo = (IndexMemoryInfo)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getIndex().estimateMemoryUsage();
            l = l2 + l3;
        }
        return l;
    }

    public static final /* synthetic */ long access$estimateTotalEmbeddingsMemoryUsage(EmbeddingIndexMemoryManager $this) {
        return $this.estimateTotalEmbeddingsMemoryUsage();
    }

    static {
        Logger logger = Logger.getInstance(EmbeddingIndexMemoryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EmbeddingIndexMemoryManager.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager;", "intellij.platform.ml.embeddings"})
    @SourceDebugExtension(value={"SMAP\nEmbeddingIndexMemoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddingIndexMemoryManager.kt\ncom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,55:1\n43#2,3:56\n*S KotlinDebug\n*F\n+ 1 EmbeddingIndexMemoryManager.kt\ncom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager$Companion\n*L\n53#1:56,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EmbeddingIndexMemoryManager getInstance() {
            boolean $i$f$service = false;
            Class<EmbeddingIndexMemoryManager> serviceClass$iv = EmbeddingIndexMemoryManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (EmbeddingIndexMemoryManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ.\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager$IndexMemoryInfo;", "", "index", "Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;", "weight", "", "strongLimit", "(Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;ILjava/lang/Integer;)V", "getIndex", "()Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;", "getStrongLimit", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getWeight", "()I", "component1", "component2", "component3", "copy", "(Lcom/intellij/platform/ml/embeddings/search/indices/EmbeddingSearchIndex;ILjava/lang/Integer;)Lcom/intellij/platform/ml/embeddings/search/services/EmbeddingIndexMemoryManager$IndexMemoryInfo;", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ml.embeddings"})
    public static final class IndexMemoryInfo {
        @NotNull
        private final EmbeddingSearchIndex index;
        private final int weight;
        @Nullable
        private final Integer strongLimit;

        public IndexMemoryInfo(@NotNull EmbeddingSearchIndex index, int weight, @Nullable Integer strongLimit) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            this.index = index;
            this.weight = weight;
            this.strongLimit = strongLimit;
        }

        @NotNull
        public final EmbeddingSearchIndex getIndex() {
            return this.index;
        }

        public final int getWeight() {
            return this.weight;
        }

        @Nullable
        public final Integer getStrongLimit() {
            return this.strongLimit;
        }

        @NotNull
        public final EmbeddingSearchIndex component1() {
            return this.index;
        }

        public final int component2() {
            return this.weight;
        }

        @Nullable
        public final Integer component3() {
            return this.strongLimit;
        }

        @NotNull
        public final IndexMemoryInfo copy(@NotNull EmbeddingSearchIndex index, int weight, @Nullable Integer strongLimit) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            return new IndexMemoryInfo(index, weight, strongLimit);
        }

        public static /* synthetic */ IndexMemoryInfo copy$default(IndexMemoryInfo indexMemoryInfo, EmbeddingSearchIndex embeddingSearchIndex, int n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                embeddingSearchIndex = indexMemoryInfo.index;
            }
            if ((n3 & 2) != 0) {
                n = indexMemoryInfo.weight;
            }
            if ((n3 & 4) != 0) {
                n2 = indexMemoryInfo.strongLimit;
            }
            return indexMemoryInfo.copy(embeddingSearchIndex, n, n2);
        }

        @NotNull
        public String toString() {
            return "IndexMemoryInfo(index=" + this.index + ", weight=" + this.weight + ", strongLimit=" + this.strongLimit + ")";
        }

        public int hashCode() {
            int result2 = this.index.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.weight);
            result2 = result2 * 31 + (this.strongLimit == null ? 0 : ((Object)this.strongLimit).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IndexMemoryInfo)) {
                return false;
            }
            IndexMemoryInfo indexMemoryInfo = (IndexMemoryInfo)other;
            if (!Intrinsics.areEqual((Object)this.index, (Object)indexMemoryInfo.index)) {
                return false;
            }
            if (this.weight != indexMemoryInfo.weight) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.strongLimit, (Object)indexMemoryInfo.strongLimit);
        }
    }
}

