/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.training.promoter;

import com.intellij.java.ift.JavaLessonsBundle;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.wm.StartPagePromoter;
import com.intellij.ui.components.JBOptionButton;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.training.ift.KotlinLessonsBundle;
import training.statistic.StatisticBase;
import training.ui.welcomeScreen.OnboardingLessonPromoter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/training/promoter/JavaOrKotlinOnboardingTourPromoter;", "Ltraining/ui/welcomeScreen/OnboardingLessonPromoter;", "()V", "promoImage", "Ljavax/swing/Icon;", "getPromoImage", "()Ljavax/swing/Icon;", "createButton", "Ljavax/swing/JComponent;", "getPriorityLevel", "", "StartOnboardingAction", "intellij.kotlin.onboarding-promoter"})
public final class JavaOrKotlinOnboardingTourPromoter
extends OnboardingLessonPromoter {
    public JavaOrKotlinOnboardingTourPromoter() {
        super("idea.onboarding", "kotlin", JavaLessonsBundle.INSTANCE.message("java.onboarding.lesson.name", new Object[0]));
    }

    public int getPriorityLevel() {
        return StartPagePromoter.PRIORITY_LEVEL_NORMAL + 10;
    }

    @NotNull
    protected Icon getPromoImage() {
        ClassLoader classLoader = JavaLessonsBundle.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return IconLoader.getIcon((String)"img/idea-onboarding-tour.png", (ClassLoader)classLoader);
    }

    @NotNull
    protected JComponent createButton() {
        StartOnboardingAction javaOnboardingAction = new StartOnboardingAction("JAVA", KotlinLessonsBundle.INSTANCE.message("welcome.promo.start.tour.java", new Object[0]));
        StartOnboardingAction kotlinOnboardingAction = new StartOnboardingAction("kotlin", KotlinLessonsBundle.INSTANCE.message("welcome.promo.start.tour.kotlin", new Object[0]));
        Action[] actionArray = new Action[]{javaOnboardingAction, kotlinOnboardingAction};
        Action[] it = actionArray = new JBOptionButton((Action)javaOnboardingAction, actionArray);
        boolean bl = false;
        it.setAddSeparator(false);
        it.setShowPopupYOffset(1);
        it.setPopupHandler((Function1)new Function1<JBPopup, Unit>(this){
            final /* synthetic */ JavaOrKotlinOnboardingTourPromoter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JBPopup it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                StatisticBase.Companion.logOnboardingBannerSwitcherExpanded(JavaOrKotlinOnboardingTourPromoter.access$getLessonId(this.this$0));
            }
        });
        Action[] button2 = actionArray;
        return (JComponent)button2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001a\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/training/promoter/JavaOrKotlinOnboardingTourPromoter$StartOnboardingAction;", "Ljavax/swing/AbstractAction;", "languageId", "", "name", "Lorg/jetbrains/annotations/Nls;", "(Lorg/jetbrains/kotlin/training/promoter/JavaOrKotlinOnboardingTourPromoter;Ljava/lang/String;Ljava/lang/String;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.kotlin.onboarding-promoter"})
    private final class StartOnboardingAction
    extends AbstractAction {
        @NotNull
        private final String languageId;

        public StartOnboardingAction(@NotNull String languageId, String name) {
            Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name);
            this.languageId = languageId;
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            JavaOrKotlinOnboardingTourPromoter.this.startOnboardingLessonWithSdk(JavaOrKotlinOnboardingTourPromoter.this.getLessonId(), this.languageId);
        }
    }
}

