/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public final class JavacFileData {
    public static final String CUSTOM_DATA_PLUGIN_ID = "ast.reference.collector";
    public static final String CUSTOM_DATA_KIND = "JavacFileData";
    private static final byte CLASS_MARKER = 0;
    private static final byte METHOD_MARKER = 1;
    private static final byte FIELD_MARKER = 2;
    private static final byte FUN_EXPR_MARKER = 3;
    private final String myFilePath;
    private final Map<JavacRef, Integer> myRefs;
    private final List<JavacTypeCast> myCasts;
    private final List<JavacDef> myDefs;
    private final Set<JavacRef> myImplicitRefs;

    public JavacFileData(@NotNull String path, @NotNull Map<JavacRef, Integer> refs, @NotNull List<JavacTypeCast> casts, @NotNull List<JavacDef> defs, @NotNull Set<JavacRef> implicitRefs) {
        if (path == null) {
            JavacFileData.$$$reportNull$$$0(0);
        }
        if (refs == null) {
            JavacFileData.$$$reportNull$$$0(1);
        }
        if (casts == null) {
            JavacFileData.$$$reportNull$$$0(2);
        }
        if (defs == null) {
            JavacFileData.$$$reportNull$$$0(3);
        }
        if (implicitRefs == null) {
            JavacFileData.$$$reportNull$$$0(4);
        }
        this.myFilePath = path;
        this.myRefs = refs;
        this.myCasts = casts;
        this.myDefs = defs;
        this.myImplicitRefs = implicitRefs;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFilePath;
        if (string == null) {
            JavacFileData.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Set<JavacRef> getImplicitToStringRefs() {
        Set<JavacRef> set = this.myImplicitRefs;
        if (set == null) {
            JavacFileData.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Map<JavacRef, Integer> getRefs() {
        Map<JavacRef, Integer> map = this.myRefs;
        if (map == null) {
            JavacFileData.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    public List<JavacTypeCast> getCasts() {
        List<JavacTypeCast> list = this.myCasts;
        if (list == null) {
            JavacFileData.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<JavacDef> getDefs() {
        List<JavacDef> list = this.myDefs;
        if (list == null) {
            JavacFileData.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public byte[] asBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(os);
        try {
            stream.writeUTF(this.getFilePath());
            JavacFileData.saveRefs(stream, this.getRefs());
            JavacFileData.saveCasts(stream, this.getCasts());
            JavacFileData.saveDefs(stream, this.getDefs());
            JavacFileData.saveImplicitToString(stream, this.getImplicitToStringRefs());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] byArray = os.toByteArray();
        if (byArray == null) {
            JavacFileData.$$$reportNull$$$0(10);
        }
        return byArray;
    }

    @NotNull
    public static JavacFileData fromBytes(byte[] bytes) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            String path = in.readUTF();
            Map<JavacRef, Integer> refs = JavacFileData.readRefs(in);
            List<JavacTypeCast> casts = JavacFileData.readCasts(in);
            List<JavacDef> defs = JavacFileData.readDefs(in);
            Set<JavacRef> implicitRefs = JavacFileData.readImplicitToString(in);
            return new JavacFileData(path, refs, casts, defs, implicitRefs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void saveRefs(DataOutput out, Map<JavacRef, Integer> refs) throws IOException {
        out.writeInt(refs.size());
        for (Map.Entry<JavacRef, Integer> entry : refs.entrySet()) {
            JavacFileData.writeJavacRef(out, entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    private static Map<JavacRef, Integer> readRefs(DataInput in) throws IOException {
        int size = in.readInt();
        HashMap<JavacRef, Integer> deserialized = new HashMap<JavacRef, Integer>(size, 0.95f);
        while (size-- > 0) {
            JavacRef key = JavacFileData.readJavacRef(in);
            int value = in.readInt();
            deserialized.put(key, value);
        }
        return deserialized;
    }

    private static void saveDefs(DataOutput out, List<? extends JavacDef> defs) throws IOException {
        out.writeInt(defs.size());
        for (JavacDef javacDef : defs) {
            JavacFileData.writeJavacDef(out, javacDef);
        }
    }

    private static List<JavacDef> readDefs(DataInput in) throws IOException {
        int size = in.readInt();
        ArrayList<JavacDef> result = new ArrayList<JavacDef>(size);
        while (size-- > 0) {
            result.add(JavacFileData.readJavacDef(in));
        }
        return result;
    }

    private static JavacDef readJavacDef(@NotNull DataInput in) throws IOException {
        if (in == null) {
            JavacFileData.$$$reportNull$$$0(11);
        }
        byte marker = in.readByte();
        switch (marker) {
            case 0: {
                int supersSize = in.readInt();
                JavacRef[] superClasses = new JavacRef[supersSize];
                for (int i = 0; i < supersSize; ++i) {
                    superClasses[i] = JavacFileData.readJavacRef(in);
                }
                return new JavacDef.JavacClassDef(JavacFileData.readJavacRef(in), superClasses);
            }
            case 3: {
                return new JavacDef.JavacFunExprDef(JavacFileData.readJavacRef(in));
            }
            case 1: {
                JavacRef retType = JavacFileData.readJavacRef(in);
                byte dimension = in.readByte();
                boolean isStatic = in.readBoolean();
                return new JavacDef.JavacMemberDef(JavacFileData.readJavacRef(in), retType, dimension, isStatic);
            }
        }
        throw new IllegalStateException("unknown marker " + marker);
    }

    private static void writeJavacDef(@NotNull DataOutput out, JavacDef def) throws IOException {
        if (out == null) {
            JavacFileData.$$$reportNull$$$0(12);
        }
        if (def instanceof JavacDef.JavacClassDef) {
            out.writeByte(0);
            JavacRef[] superClasses = ((JavacDef.JavacClassDef)def).getSuperClasses();
            out.writeInt(superClasses.length);
            for (JavacRef aClass : superClasses) {
                JavacFileData.writeJavacRef(out, aClass);
            }
        } else if (def instanceof JavacDef.JavacFunExprDef) {
            out.writeByte(3);
        } else if (def instanceof JavacDef.JavacMemberDef) {
            out.writeByte(1);
            JavacFileData.writeJavacRef(out, ((JavacDef.JavacMemberDef)def).getReturnType());
            out.writeByte(((JavacDef.JavacMemberDef)def).getIteratorKind());
            out.writeBoolean(((JavacDef.JavacMemberDef)def).isStatic());
        } else {
            throw new IllegalStateException("unknown type: " + def.getClass());
        }
        JavacFileData.writeJavacRef(out, def.getDefinedElement());
    }

    private static void writeJavacRef(@NotNull DataOutput out, JavacRef ref) throws IOException {
        if (out == null) {
            JavacFileData.$$$reportNull$$$0(13);
        }
        if (ref instanceof JavacRef.JavacClass) {
            out.writeByte(0);
            out.writeBoolean(((JavacRef.JavacClass)ref).isAnonymous());
        } else if (ref instanceof JavacRef.JavacField) {
            out.writeByte(2);
            String containingClass = ((JavacRef.JavacField)ref).getContainingClass();
            out.writeUTF(containingClass == null ? "" : containingClass);
            out.writeUTF(ref.getOwnerName());
            String descriptor = ((JavacRef.JavacField)ref).getDescriptor();
            out.writeUTF(descriptor == null ? "" : descriptor);
        } else if (ref instanceof JavacRef.JavacMethod) {
            out.writeByte(1);
            String containingClass = ((JavacRef.JavacMethod)ref).getContainingClass();
            out.writeUTF(containingClass == null ? "" : containingClass);
            out.writeUTF(ref.getOwnerName());
            out.write(((JavacRef.JavacMethod)ref).getParamCount());
        } else {
            throw new IllegalStateException("unknown type: " + ref.getClass());
        }
        JavacFileData.writeModifiers(out, ref.getModifiers());
        out.writeUTF(ref.getName());
    }

    private static JavacRef readJavacRef(@NotNull DataInput in) throws IOException {
        if (in == null) {
            JavacFileData.$$$reportNull$$$0(14);
        }
        byte marker = in.readByte();
        switch (marker) {
            case 0: {
                boolean isAnonymous = in.readBoolean();
                Set<Modifier> classModifiers = JavacFileData.readModifiers(in);
                String className = in.readUTF();
                return new JavacRef.JavacClassImpl(isAnonymous, classModifiers, className);
            }
            case 1: {
                String methodContainingClass = in.readUTF();
                String methodOwnerName = in.readUTF();
                byte methodParamCount = in.readByte();
                Set<Modifier> methodModifiers = JavacFileData.readModifiers(in);
                String methodName = in.readUTF();
                return new JavacRef.JavacMethodImpl(methodContainingClass, methodOwnerName, methodParamCount, methodModifiers, methodName);
            }
            case 2: {
                String fieldContainingClass = in.readUTF();
                String fieldOwnerName = in.readUTF();
                String fieldDescriptor = in.readUTF();
                Set<Modifier> fieldModifiers = JavacFileData.readModifiers(in);
                String fieldName = in.readUTF();
                return new JavacRef.JavacFieldImpl(fieldContainingClass, fieldOwnerName, fieldModifiers, fieldName, fieldDescriptor);
            }
        }
        throw new IllegalStateException("unknown marker " + marker);
    }

    private static void writeModifiers(DataOutput output, Set<Modifier> modifiers) throws IOException {
        output.writeInt(modifiers.size());
        for (Modifier modifier : modifiers) {
            output.writeUTF(modifier.name());
        }
    }

    private static Set<Modifier> readModifiers(DataInput input) throws IOException {
        int size = input.readInt();
        ArrayList<Modifier> modifierList = new ArrayList<Modifier>(size);
        while (size-- > 0) {
            modifierList.add(Modifier.valueOf(input.readUTF()));
        }
        return modifierList.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(modifierList);
    }

    private static void saveCasts(@NotNull DataOutput output, @NotNull List<? extends JavacTypeCast> casts) throws IOException {
        if (output == null) {
            JavacFileData.$$$reportNull$$$0(15);
        }
        if (casts == null) {
            JavacFileData.$$$reportNull$$$0(16);
        }
        output.writeInt(casts.size());
        for (JavacTypeCast javacTypeCast : casts) {
            JavacFileData.writeJavacRef(output, javacTypeCast.getOperandType());
            JavacFileData.writeJavacRef(output, javacTypeCast.getCastType());
        }
    }

    @NotNull
    private static List<JavacTypeCast> readCasts(@NotNull DataInput input) throws IOException {
        if (input == null) {
            JavacFileData.$$$reportNull$$$0(17);
        }
        int size = input.readInt();
        ArrayList<JavacTypeCast> result = new ArrayList<JavacTypeCast>(size);
        while (size-- > 0) {
            JavacRef.JavacClass operandType = (JavacRef.JavacClass)JavacFileData.readJavacRef(input);
            JavacRef.JavacClass castType = (JavacRef.JavacClass)JavacFileData.readJavacRef(input);
            result.add(new JavacTypeCast(operandType, castType));
        }
        ArrayList<JavacTypeCast> arrayList = result;
        if (arrayList == null) {
            JavacFileData.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    private static Set<JavacRef> readImplicitToString(@NotNull DataInputStream in) throws IOException {
        if (in == null) {
            JavacFileData.$$$reportNull$$$0(19);
        }
        int size = in.readInt();
        HashSet<JavacRef> result = new HashSet<JavacRef>(size);
        while (size-- > 0) {
            result.add(JavacFileData.readJavacRef(in));
        }
        HashSet<JavacRef> hashSet = result;
        if (hashSet == null) {
            JavacFileData.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    private static void saveImplicitToString(@NotNull DataOutputStream out, @NotNull Set<? extends JavacRef> refs) throws IOException {
        if (out == null) {
            JavacFileData.$$$reportNull$$$0(21);
        }
        if (refs == null) {
            JavacFileData.$$$reportNull$$$0(22);
        }
        out.writeInt(refs.size());
        for (JavacRef javacRef : refs) {
            JavacFileData.writeJavacRef(out, javacRef);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitRefs";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/javac/ast/api/JavacFileData";
                break;
            }
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 12: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/javac/ast/api/JavacFileData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitToStringRefs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asBytes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readCasts";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "readImplicitToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readJavacDef";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeJavacDef";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeJavacRef";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readJavacRef";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "saveCasts";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readCasts";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readImplicitToString";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "saveImplicitToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

