/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.BuilderService;
import org.jetbrains.jps.service.JpsServiceManager;

public final class TargetTypeRegistry {
    private static final Logger LOG = Logger.getInstance(TargetTypeRegistry.class);
    private final Map<String, BuildTargetType<?>> myTargetTypes = new LinkedHashMap();

    public static TargetTypeRegistry getInstance() {
        return Holder.ourInstance;
    }

    private TargetTypeRegistry() {
        for (BuilderService service : JpsServiceManager.getInstance().getExtensions(BuilderService.class)) {
            for (BuildTargetType<?> type : service.getTargetTypes()) {
                String id = type.getTypeId();
                BuildTargetType<?> old = this.myTargetTypes.put(id, type);
                if (old == null) continue;
                LOG.error("Two build target types (" + type + ", " + old + ") use same id (" + id + ")");
            }
        }
    }

    @Nullable
    public BuildTargetType<?> getTargetType(String typeId) {
        return this.myTargetTypes.get(typeId);
    }

    public Collection<BuildTargetType<?>> getTargetTypes() {
        return this.myTargetTypes.values();
    }

    private static final class Holder {
        static final TargetTypeRegistry ourInstance = new TargetTypeRegistry();

        private Holder() {
        }
    }
}

