/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.floating;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorCustomizer;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.plugins.markdown.editor.EditorUtilKt;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.ui.floating.MarkdownFloatingToolbar;
import org.intellij.plugins.markdown.util.MarkdownPluginScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/floating/AddFloatingToolbarTextEditorCustomizer;", "Lcom/intellij/openapi/fileEditor/impl/text/TextEditorCustomizer;", "()V", "customize", "", "textEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "shouldAcceptEditor", "", "editor", "shouldAcceptScratchFile", "intellij.markdown.core"})
final class AddFloatingToolbarTextEditorCustomizer
implements TextEditorCustomizer {
    public void customize(@NotNull TextEditor textEditor) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Project project = textEditor.getEditor().getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (this.shouldAcceptEditor(textEditor) && !AdvancedSettings.Companion.getBoolean("markdown.hide.floating.toolbar")) {
            CoroutineScope coroutineScope = MarkdownPluginScope.Companion.createChildScope(project2);
            Editor editor2 = textEditor.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            MarkdownFloatingToolbar toolbar2 = new MarkdownFloatingToolbar(editor2, coroutineScope);
            Disposer.register((Disposable)((Disposable)textEditor), (Disposable)((Disposable)toolbar2));
        }
    }

    private final boolean shouldAcceptEditor(TextEditor editor2) {
        VirtualFile file = editor2.getFile();
        Intrinsics.checkNotNull((Object)file);
        return MarkdownLanguageUtilsKt.hasMarkdownType(file) || this.shouldAcceptScratchFile(editor2);
    }

    private final boolean shouldAcceptScratchFile(TextEditor editor2) {
        VirtualFile file = editor2.getFile();
        Project project = editor2.getEditor().getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        Intrinsics.checkNotNull((Object)file);
        return EditorUtilKt.isMarkdownScratchFile(project2, file);
    }
}

