/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diff.editor.DiffContentVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsEditorTabFilesListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@com.intellij.openapi.components.State(name="VcsEditorTab.Settings", storages={@Storage(value="vcs.xml")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J+\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0016J;\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\r*\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager$State;", "Lcom/intellij/openapi/Disposable;", "()V", "value", "", "shouldOpenInNewWindow", "getShouldOpenInNewWindow", "()Z", "setShouldOpenInNewWindow", "(Z)V", "dispose", "", "openFile", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "focusEditor", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Z)[Lcom/intellij/openapi/fileEditor/FileEditor;", "openInNewWindow", "shouldCloseFile", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;ZZZ)[Lcom/intellij/openapi/fileEditor/FileEditor;", "selectAndFocusEditor", "Lcom/intellij/openapi/fileEditor/impl/FileEditorManagerImpl;", "Companion", "State", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsEditorTabFilesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsEditorTabFilesManager.kt\ncom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n26#2:123\n1#3:124\n*S KotlinDebug\n*F\n+ 1 VcsEditorTabFilesManager.kt\ncom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager\n*L\n76#1:123\n*E\n"})
public final class VcsEditorTabFilesManager
extends SimplePersistentStateComponent<State>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public VcsEditorTabFilesManager() {
        super((BaseState)new State());
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        final MessageBus messageBus2 = messageBus;
        MessageBusConnection messageBusConnection = messageBus2.connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source2, @NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file instanceof DiffContentVirtualFile && source2 instanceof FileEditorManagerEx) {
                    boolean bl;
                    EditorWindow editorWindow = Companion.findFloatingWindowForFile((FileEditorManagerEx)source2, file);
                    if (editorWindow != null) {
                        EditorWindow it = editorWindow;
                        boolean bl2 = false;
                        bl = it.getTabCount() == 1;
                    } else {
                        bl = false;
                    }
                    boolean isOpenInNewWindow = bl;
                    this.setShouldOpenInNewWindow(isOpenInNewWindow);
                    ((VcsEditorTabFilesListener)messageBus2.syncPublisher(VcsEditorTabFilesListener.TOPIC)).shouldOpenInNewWindowChanged(file, isOpenInNewWindow);
                }
            }
        });
    }

    public final boolean getShouldOpenInNewWindow() {
        return ((State)this.getState()).getOpenInNewWindow();
    }

    private final void setShouldOpenInNewWindow(boolean value2) {
        ((State)this.getState()).setOpenInNewWindow(value2);
    }

    @NotNull
    public final FileEditor[] openFile(@NotNull Project project2, @NotNull VirtualFile file, boolean focusEditor, boolean openInNewWindow, boolean shouldCloseFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl editorManager = (FileEditorManagerImpl)fileEditorManager;
        if (shouldCloseFile && editorManager.isFileOpen(file)) {
            editorManager.closeFile(file);
        }
        this.setShouldOpenInNewWindow(openInNewWindow);
        return this.openFile(project2, file, focusEditor);
    }

    @NotNull
    public final FileEditor[] openFile(@NotNull Project project2, @NotNull VirtualFile file, boolean focusEditor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
        FileEditorManagerImpl editorManager = (FileEditorManagerImpl)fileEditorManager;
        if (!ClientId.Companion.isCurrentlyUnderLocalId()) {
            return editorManager.openFile(file, focusEditor, true);
        }
        if (editorManager.isFileOpen(file)) {
            this.selectAndFocusEditor(editorManager, file, focusEditor);
            boolean $i$f$emptyArray = false;
            return new FileEditor[0];
        }
        if (this.getShouldOpenInNewWindow()) {
            Object object = editorManager.openFileInNewWindow((VirtualFile)file).first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            return (FileEditor[])object;
        }
        return editorManager.openFile(file, focusEditor, true);
    }

    private final void selectAndFocusEditor(FileEditorManagerImpl $this$selectAndFocusEditor, VirtualFile file, boolean focusEditor) {
        EditorWindow editorWindow;
        block4: {
            EditorWindow[] editorWindowArray = $this$selectAndFocusEditor.getWindows();
            int n = editorWindowArray.length;
            for (int i = 0; i < n; ++i) {
                EditorWindow editorWindow2;
                EditorWindow it = editorWindow2 = editorWindowArray[i];
                boolean bl = false;
                if (!it.isFileOpen(file)) continue;
                editorWindow = editorWindow2;
                break block4;
            }
            editorWindow = null;
        }
        if (editorWindow == null) {
            return;
        }
        EditorWindow window = editorWindow;
        EditorComposite editorComposite = window.getComposite(file);
        if (editorComposite == null) {
            return;
        }
        EditorComposite composite = editorComposite;
        window.setSelectedComposite(composite, focusEditor);
        if (focusEditor) {
            window.requestFocus(true);
            window.toFront();
        }
    }

    public void dispose() {
    }

    @JvmStatic
    @NotNull
    public static final VcsEditorTabFilesManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final EditorWindow findFloatingWindowForFile(@NotNull FileEditorManagerEx $this$findFloatingWindowForFile, @NotNull VirtualFile file) {
        return Companion.findFloatingWindowForFile($this$findFloatingWindowForFile, file);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager;", "findFloatingWindowForFile", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "Lcom/intellij/openapi/fileEditor/ex/FileEditorManagerEx;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsEditorTabFilesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsEditorTabFilesManager.kt\ncom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n43#2,3:123\n1#3:126\n*S KotlinDebug\n*F\n+ 1 VcsEditorTabFilesManager.kt\ncom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager$Companion\n*L\n102#1:123,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final VcsEditorTabFilesManager getInstance() {
            boolean $i$f$service = false;
            Class<VcsEditorTabFilesManager> serviceClass$iv = VcsEditorTabFilesManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (VcsEditorTabFilesManager)((Object)object);
        }

        @JvmStatic
        @Nullable
        public final EditorWindow findFloatingWindowForFile(@NotNull FileEditorManagerEx $this$findFloatingWindowForFile, @NotNull VirtualFile file) {
            EditorWindow editorWindow;
            block1: {
                Intrinsics.checkNotNullParameter((Object)$this$findFloatingWindowForFile, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                EditorWindow[] editorWindowArray = $this$findFloatingWindowForFile.getWindows();
                int n = editorWindowArray.length;
                for (int i = 0; i < n; ++i) {
                    EditorWindow editorWindow2;
                    EditorWindow it = editorWindow2 = editorWindowArray[i];
                    boolean bl = false;
                    if (!(it.getOwner().isFloating() && it.isFileOpen(file))) continue;
                    editorWindow = editorWindow2;
                    break block1;
                }
                editorWindow = null;
            }
            return editorWindow;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsEditorTabFilesManager$State;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "openInNewWindow", "getOpenInNewWindow", "()Z", "setOpenInNewWindow", "(Z)V", "openInNewWindow$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.platform.vcs.impl"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty openInNewWindow$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[0]);

        public final boolean getOpenInNewWindow() {
            return (Boolean)this.openInNewWindow$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setOpenInNewWindow(boolean bl) {
            this.openInNewWindow$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "openInNewWindow", "getOpenInNewWindow()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

