/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.reflect.Type;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolvingElementQuickFix
implements LocalQuickFix,
IntentionAction {
    private final String myNewName;
    private final List<? extends DomElement> myParents;
    private final DomCollectionChildDescription myChildDescription;
    private String myTypeName;

    public ResolvingElementQuickFix(Class<? extends DomElement> clazz, String newName, List<? extends DomElement> parents, DomCollectionChildDescription childDescription) {
        this.myNewName = newName;
        this.myParents = parents;
        this.myChildDescription = childDescription;
        this.myTypeName = TypePresentationService.getService().getTypePresentableName(clazz);
    }

    public void setTypeName(String typeName) {
        this.myTypeName = typeName;
    }

    @NotNull
    public String getName() {
        String string2 = XmlDomBundle.message("dom.quickfix.create.new.element.name", this.myTypeName, this.myNewName);
        if (string2 == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @NotNull
    public String getText() {
        String string2 = this.getName();
        if (string2 == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = XmlDomBundle.message("dom.quickfix.create.new.element.family", new Object[0]);
        if (string2 == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(4);
        }
        this.applyFix();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            ResolvingElementQuickFix.$$$reportNull$$$0(6);
        }
        this.applyFix();
    }

    private void applyFix() {
        ResolvingElementQuickFix.chooseParent(this.myParents, (Consumer<? super DomElement>)((Consumer)parent -> WriteCommandAction.writeCommandAction((Project)parent.getManager().getProject(), (PsiFile[])new PsiFile[]{DomUtil.getFile(parent)}).run(() -> this.doFix((DomElement)parent, this.myChildDescription, this.myNewName))));
    }

    protected DomElement doFix(DomElement parent, DomCollectionChildDescription childDescription, String newName) {
        DomElement domElement = childDescription.addValue(parent);
        GenericDomValue<?> nameDomElement = domElement.getGenericInfo().getNameDomElement(domElement);
        assert (nameDomElement != null);
        nameDomElement.setStringValue(newName);
        return domElement;
    }

    protected static void chooseParent(List<? extends DomElement> files2, final Consumer<? super DomElement> onChoose) {
        switch (files2.size()) {
            case 0: {
                break;
            }
            case 1: {
                onChoose.consume((Object)files2.iterator().next());
                break;
            }
            default: {
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<DomElement>(XmlDomBundle.message("dom.quickfix.create.new.element.choose.file.title", new Object[0]), files2){

                    public PopupStep onChosen(DomElement selectedValue, boolean finalChoice) {
                        onChoose.consume((Object)selectedValue);
                        return super.onChosen((Object)selectedValue, finalChoice);
                    }

                    public Icon getIconFor(DomElement aValue) {
                        return DomUtil.getFile(aValue).getIcon(0);
                    }

                    @NotNull
                    public String getTextFor(DomElement value2) {
                        String string2 = DomUtil.getFile(value2).getName();
                        if (string2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/ResolvingElementQuickFix$1", "getTextFor"));
                    }
                }).showInBestPositionFor(DataManager.getInstance().getDataContext());
            }
        }
    }

    @Nullable
    public static <T extends DomElement> DomCollectionChildDescription getChildDescription(List<? extends DomElement> contexts, Class<T> clazz) {
        if (contexts.size() == 0) {
            return null;
        }
        DomElement context = contexts.get(0);
        DomGenericInfo genericInfo = context.getGenericInfo();
        List<? extends DomCollectionChildDescription> descriptions = genericInfo.getCollectionChildrenDescriptions();
        for (DomCollectionChildDescription domCollectionChildDescription : descriptions) {
            Type type2 = domCollectionChildDescription.getType();
            if (!type2.equals(clazz)) continue;
            return domCollectionChildDescription;
        }
        return null;
    }

    @Nullable
    public static ResolvingElementQuickFix createFix(String newName, Class<? extends DomElement> clazz, DomElement scope2) {
        List<DomElement> parents = ModelMergerUtil.getImplementations(scope2);
        return ResolvingElementQuickFix.createFix(newName, clazz, parents);
    }

    @Nullable
    public static ResolvingElementQuickFix createFix(String newName, Class<? extends DomElement> clazz, List<? extends DomElement> parents) {
        DomCollectionChildDescription childDescription = ResolvingElementQuickFix.getChildDescription(parents, clazz);
        if (newName.length() > 0 && childDescription != null) {
            return new ResolvingElementQuickFix(clazz, newName, parents, childDescription);
        }
        return null;
    }

    public static LocalQuickFix[] createFixes(String newName, Class<? extends DomElement> clazz, DomElement scope2) {
        LocalQuickFix[] localQuickFixArray;
        ResolvingElementQuickFix fix = ResolvingElementQuickFix.createFix(newName, clazz, scope2);
        if (fix != null) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = fix;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/ResolvingElementQuickFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/ResolvingElementQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string2);
        };
    }
}

