/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpanAttribute;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBranchLikeFilter;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.history.CommitMetadataWithPath;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryBuilder;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryFiltererKt;
import com.intellij.vcs.log.history.FileHistoryPaths;
import com.intellij.vcs.log.history.FileHistorySpeedSearch;
import com.intellij.vcs.log.history.FileHistoryTask;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.history.Rename;
import com.intellij.vcs.log.history.VcsLogFileHistoryFilter;
import com.intellij.vcs.log.statistics.VcsLogRepoSizeCollector;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VcsLogFiltererImplKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0002?@B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001eH\u0002J2\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001eH\u0002J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\"H\u0016J<\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203012\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002022\u0006\u00107\u001a\u0002082\u0006\u0010\u001f\u001a\u00020 2\u0006\u00109\u001a\u000203H\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010+2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010;\u001a\u00020<*\u00020\u001a2\u0006\u0010=\u001a\u00020>2\u0006\u0010'\u001a\u00020\u000fH\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\r\u001aJ\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u0011 \u0010*#\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u0012\u00a2\u0006\u0002\b\f0\u000e\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006A"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "Lcom/intellij/openapi/Disposable;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logId", "", "(Lcom/intellij/vcs/log/data/VcsLogData;Ljava/lang/String;)V", "fileHistoryTask", "Lcom/intellij/vcs/log/history/FileHistoryTask;", "index", "Lcom/intellij/vcs/log/data/index/VcsLogIndex;", "Lorg/jetbrains/annotations/NotNull;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/intellij/vcs/log/VcsLogProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "vcsLogFilterer", "Lcom/intellij/vcs/log/visible/VcsLogFiltererImpl;", "vcsLogObjectsFactory", "Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "getVcsLogObjectsFactory", "()Lcom/intellij/vcs/log/VcsLogObjectsFactory;", "canFilterEmptyPack", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "cancelLastTask", "", "wait", "createFileHistoryTask", "historyHandler", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "root", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "isInitial", "createProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dispose", "filter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "oldVisiblePack", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "commitCount", "getHash", "createCommitMetadataWithPath", "Lcom/intellij/vcs/log/history/CommitMetadataWithPath;", "revision", "Lcom/intellij/openapi/vcs/history/VcsFileRevisionEx;", "Companion", "MyWorker", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistoryFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryFilterer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,457:1\n30#2,3:458\n1#3:461\n10#4:462\n*S KotlinDebug\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryFilterer\n*L\n61#1:458,3\n328#1:462\n*E\n"})
public final class FileHistoryFilterer
implements VcsLogFilterer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final String logId;
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    @NotNull
    private final VcsLogStorage storage;
    @NotNull
    private final VcsLogIndex index;
    @NotNull
    private final VcsLogFiltererImpl vcsLogFilterer;
    @Nullable
    private FileHistoryTask fileHistoryTask;
    @NotNull
    private static final Logger LOG;

    public FileHistoryFilterer(@NotNull VcsLogData logData, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        this.logData = logData;
        this.logId = logId;
        Project project2 = this.logData.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.project = project2;
        Map<VirtualFile, VcsLogProvider> map2 = this.logData.getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getLogProviders(...)");
        this.logProviders = map2;
        VcsLogStorage vcsLogStorage = this.logData.getStorage();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getStorage(...)");
        this.storage = vcsLogStorage;
        VcsLogIndex vcsLogIndex = this.logData.getIndex();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex, (String)"getIndex(...)");
        this.index = vcsLogIndex;
        TopCommitsCache topCommitsCache = this.logData.getTopCommitsCache();
        Intrinsics.checkNotNullExpressionValue((Object)topCommitsCache, (String)"getTopCommitsCache(...)");
        CommitDetailsGetter commitDetailsGetter = this.logData.getCommitDetailsGetter();
        Intrinsics.checkNotNullExpressionValue((Object)commitDetailsGetter, (String)"getCommitDetailsGetter(...)");
        this.vcsLogFilterer = new VcsLogFiltererImpl(this.logProviders, this.storage, topCommitsCache, commitDetailsGetter, this.index);
    }

    private final VcsLogObjectsFactory getVcsLogObjectsFactory() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsLogObjectsFactory> serviceClass$iv = VcsLogObjectsFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return (VcsLogObjectsFactory)object;
    }

    @Override
    @NotNull
    public Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        VcsLogFileHistoryHandler fileHistoryHandler;
        VcsLogProvider logProvider;
        VirtualFile virtualFile;
        FilePath filePath;
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
        Intrinsics.checkNotNullParameter((Object)((Object)sortType), (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)commitCount, (String)"commitCount");
        FilePath filePath2 = filePath = Companion.getFilePath(filters);
        if (filePath2 != null) {
            FilePath it = filePath2;
            boolean bl = false;
            virtualFile = VcsLogUtil.getActualRoot(this.project, filePath);
        } else {
            virtualFile = null;
        }
        VirtualFile root = virtualFile;
        Hash hash2 = this.getHash(filters);
        VcsLogProvider vcsLogProvider = logProvider = this.logProviders.get(root);
        VcsLogFileHistoryHandler vcsLogFileHistoryHandler = fileHistoryHandler = vcsLogProvider != null ? vcsLogProvider.getFileHistoryHandler() : null;
        if (root != null && !filePath.isDirectory() && fileHistoryHandler != null) {
            VcsKey vcsKey = logProvider.getSupportedVcs();
            Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getSupportedVcs(...)");
            return new MyWorker(vcsKey, fileHistoryHandler, root, filePath, hash2).filter(dataPack, oldVisiblePack, sortType, filters, commitCount);
        }
        return this.vcsLogFilterer.filter(dataPack, oldVisiblePack, sortType, filters, commitCount);
    }

    @Override
    public boolean canFilterEmptyPack(@NotNull VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        return true;
    }

    private final void cancelLastTask(boolean wait) {
        FileHistoryTask fileHistoryTask = this.fileHistoryTask;
        if (fileHistoryTask != null) {
            fileHistoryTask.cancel(wait);
        }
        this.fileHistoryTask = null;
    }

    private final FileHistoryTask createFileHistoryTask(VcsLogFileHistoryHandler historyHandler, VirtualFile root, FilePath filePath, Hash hash2, boolean isInitial) {
        FileHistoryTask oldHistoryTask = this.fileHistoryTask;
        if (oldHistoryTask != null && !oldHistoryTask.isCancelled() && !isInitial && Intrinsics.areEqual((Object)oldHistoryTask.getFilePath(), (Object)filePath) && Intrinsics.areEqual((Object)oldHistoryTask.getHash(), (Object)hash2)) {
            return oldHistoryTask;
        }
        this.cancelLastTask(false);
        VcsLogObjectsFactory factory = this.getVcsLogObjectsFactory();
        Project project2 = this.project;
        ProgressIndicator progressIndicator = this.createProgressIndicator();
        FileHistoryTask newHistoryTask2 = new FileHistoryTask(historyHandler, root, filePath, hash2, this, factory, project2, progressIndicator){
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ FileHistoryFilterer this$0;
            final /* synthetic */ VcsLogObjectsFactory $factory;
            {
                this.$root = $root;
                this.this$0 = $receiver;
                this.$factory = $factory;
                super($super_call_param$1, $historyHandler, $root, $filePath, $hash, $super_call_param$2);
            }

            @NotNull
            protected CommitMetadataWithPath createCommitMetadataWithPath(@NotNull VcsFileRevision revision) {
                Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
                return FileHistoryFilterer.access$createCommitMetadataWithPath(this.this$0, this.$factory, (VcsFileRevisionEx)revision, this.$root);
            }
        };
        this.fileHistoryTask = newHistoryTask2;
        return newHistoryTask2;
    }

    private final CommitMetadataWithPath createCommitMetadataWithPath(VcsLogObjectsFactory $this$createCommitMetadataWithPath, VcsFileRevisionEx revision, VirtualFile root) {
        Hash hash2 = $this$createCommitMetadataWithPath.createHash(revision.getRevisionNumber().asString());
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"createHash(...)");
        Hash commitHash = hash2;
        List list2 = CollectionsKt.emptyList();
        long l = revision.getRevisionDate().getTime();
        String string2 = revision.getCommitMessage();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = CommitPresentationUtil.getSubject(string2);
        String string4 = revision.getAuthor();
        Intrinsics.checkNotNull((Object)string4);
        String string5 = revision.getAuthorEmail();
        Intrinsics.checkNotNull((Object)string5);
        String string6 = revision.getCommitMessage();
        Intrinsics.checkNotNull((Object)string6);
        String string7 = revision.getCommitterName();
        Intrinsics.checkNotNull((Object)string7);
        String string8 = revision.getCommitterEmail();
        Intrinsics.checkNotNull((Object)string8);
        Date date = revision.getAuthorDate();
        Intrinsics.checkNotNull((Object)date);
        VcsCommitMetadata vcsCommitMetadata = $this$createCommitMetadataWithPath.createCommitMetadata(commitHash, list2, l, root, string3, string4, string5, string6, string7, string8, date.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"createCommitMetadata(...)");
        VcsCommitMetadata metadata = vcsCommitMetadata;
        int n = this.storage.getCommitIndex(commitHash, root);
        FilePath filePath = revision.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getPath(...)");
        return new CommitMetadataWithPath(n, metadata, new MaybeDeletedFilePath(filePath, revision.isDeleted()));
    }

    private final ProgressIndicator createProgressIndicator() {
        ProgressIndicator progressIndicator = this.logData.getProgress().createProgressIndicator(new VcsLogProgress.ProgressKey("file history task for " + this.logId));
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"createProgressIndicator(...)");
        return progressIndicator;
    }

    public void dispose() {
        this.cancelLastTask(true);
    }

    private final Hash getHash(VcsLogFilterCollection filters) {
        VcsLogFileHistoryFilter fileHistoryFilter;
        VcsLogStructureFilter vcsLogStructureFilter = FileHistoryFilterer.Companion.getStructureFilter(filters);
        VcsLogFileHistoryFilter vcsLogFileHistoryFilter = fileHistoryFilter = vcsLogStructureFilter instanceof VcsLogFileHistoryFilter ? (VcsLogFileHistoryFilter)vcsLogStructureFilter : null;
        if (fileHistoryFilter != null) {
            return fileHistoryFilter.getHash();
        }
        VcsLogRevisionFilter revisionFilter = filters.get(VcsLogFilterCollection.REVISION_FILTER);
        Object object = revisionFilter;
        return object != null && (object = object.getHeads()) != null && (object = (CommitId)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) != null ? ((CommitId)object).getHash() : null;
    }

    @JvmStatic
    @NotNull
    public static final VcsLogFilterCollection createFilters(@NotNull FilePath path2, @Nullable Hash revision, @NotNull VirtualFile root, boolean showAllBranches) {
        return Companion.createFilters(path2, revision, root, showAllBranches);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileHistoryFilterer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J>\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0017H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0006J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createFilters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "revision", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "showAllBranches", "", "createVisibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "matchingHeads", "", "matchingCommits", "getFilePath", "filters", "getStructureFilter", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final VcsLogStructureFilter getStructureFilter(VcsLogFilterCollection filters) {
            List<VcsLogDetailsFilter> list2 = filters.getDetailsFilters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getDetailsFilters(...)");
            Object object = CollectionsKt.singleOrNull(list2);
            return object instanceof VcsLogStructureFilter ? (VcsLogStructureFilter)object : null;
        }

        @Nullable
        public final FilePath getFilePath(@NotNull VcsLogFilterCollection filters) {
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            VcsLogStructureFilter vcsLogStructureFilter = this.getStructureFilter(filters);
            if (vcsLogStructureFilter == null) {
                return null;
            }
            VcsLogStructureFilter filter2 = vcsLogStructureFilter;
            Collection<FilePath> collection = filter2.getFiles();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getFiles(...)");
            return (FilePath)CollectionsKt.singleOrNull((Iterable)collection);
        }

        @JvmStatic
        @NotNull
        public final VcsLogFilterCollection createFilters(@NotNull FilePath path2, @Nullable Hash revision, @NotNull VirtualFile root, boolean showAllBranches) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            VcsLogFileHistoryFilter fileFilter = new VcsLogFileHistoryFilter(path2, revision);
            VcsLogBranchLikeFilter revisionFilter = showAllBranches ? null : (revision != null ? (VcsLogBranchLikeFilter)VcsLogFilterObject.fromCommit(new CommitId(revision, root)) : (VcsLogBranchLikeFilter)VcsLogFilterObject.fromBranch("HEAD"));
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{fileFilter, revisionFilter};
            return VcsLogFilterObject.collection(vcsLogFilterArray);
        }

        private final VisibleGraph<Integer> createVisibleGraph(DataPack dataPack, PermanentGraph.SortType sortType, Set<Integer> matchingHeads, Set<Integer> matchingCommits) {
            if (VcsLogFiltererImplKt.matchesNothing((Collection)matchingHeads) || VcsLogFiltererImplKt.matchesNothing((Collection)matchingCommits)) {
                VisibleGraph<Integer> visibleGraph = EmptyVisibleGraph.getInstance();
                Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"getInstance(...)");
                return visibleGraph;
            }
            VisibleGraph<Integer> visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, matchingHeads, matchingCommits);
            Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"createVisibleGraph(...)");
            return visibleGraph;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\"\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J:\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001dJJ\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0018\u0010'\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010(\u001a\u00020\u001aH\u0002J8\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u000eH\u0002J(\u0010*\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020-0,2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010/\u001a\u00020\u0010H\u0002J\u001c\u00100\u001a\b\u0012\u0004\u0012\u000202012\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker;", "", "vcsKey", "Lcom/intellij/openapi/vcs/VcsKey;", "fileHistoryHandler", "Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "hash", "Lcom/intellij/vcs/log/Hash;", "(Lcom/intellij/vcs/log/history/FileHistoryFilterer;Lcom/intellij/openapi/vcs/VcsKey;Lcom/intellij/vcs/log/VcsLogFileHistoryHandler;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/Hash;)V", "checkNotEmpty", "", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "visiblePack", "Lcom/intellij/vcs/log/visible/VisiblePack;", "withIndex", "collectRenamesFromProvider", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/UnorderedPair;", "", "Lcom/intellij/vcs/log/history/Rename;", "fileHistory", "Lcom/intellij/vcs/log/history/FileHistory;", "filter", "Lkotlin/Pair;", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "oldVisiblePack", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "commitCount", "filterWithIndex", "indexDataGetter", "Lcom/intellij/vcs/log/data/index/IndexDataGetter;", "oldRenames", "oldFileHistory", "isInitial", "filterWithVcs", "getFilteredRefs", "", "Lcom/intellij/vcs/log/data/CompressedRefs;", "getHead", "pack", "toCommitMetadata", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "revisions", "", "Lcom/intellij/vcs/log/history/CommitMetadataWithPath;", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nFileHistoryFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker\n+ 2 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,457:1\n21#2,3:458\n100#2,2:461\n115#2:463\n103#2,10:464\n21#2,3:495\n100#2,2:498\n115#2:519\n103#2,10:520\n1549#3:474\n1620#3,3:475\n1179#3,2:478\n1253#3,4:480\n1549#3:484\n1620#3,3:485\n1179#3,2:488\n1253#3,4:490\n1603#3,9:500\n1855#3:509\n1856#3:511\n1612#3:512\n1549#3:513\n1620#3,3:514\n1855#3,2:517\n1#4:494\n1#4:510\n*S KotlinDebug\n*F\n+ 1 FileHistoryFilterer.kt\ncom/intellij/vcs/log/history/FileHistoryFilterer$MyWorker\n*L\n139#1:458,3\n139#1:461,2\n139#1:463\n139#1:464,10\n292#1:495,3\n292#1:498,2\n292#1:519\n292#1:520,10\n192#1:474\n192#1:475,3\n203#1:478,2\n203#1:480,4\n212#1:484\n212#1:485,3\n219#1:488,2\n219#1:490,4\n293#1:500,9\n293#1:509\n293#1:511\n293#1:512\n298#1:513\n298#1:514,3\n307#1:517,2\n293#1:510\n*E\n"})
    private final class MyWorker {
        @NotNull
        private final VcsKey vcsKey;
        @NotNull
        private final VcsLogFileHistoryHandler fileHistoryHandler;
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final FilePath filePath;
        @Nullable
        private final Hash hash;

        public MyWorker(@NotNull VcsKey vcsKey, @NotNull VcsLogFileHistoryHandler fileHistoryHandler, @NotNull VirtualFile root, @Nullable FilePath filePath, Hash hash2) {
            Intrinsics.checkNotNullParameter((Object)vcsKey, (String)"vcsKey");
            Intrinsics.checkNotNullParameter((Object)fileHistoryHandler, (String)"fileHistoryHandler");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.vcsKey = vcsKey;
            this.fileHistoryHandler = fileHistoryHandler;
            this.root = root;
            this.filePath = filePath;
            this.hash = hash2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public final Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
            VisiblePack visiblePack;
            void $this$useWithScope$iv;
            Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
            Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
            Intrinsics.checkNotNullParameter((Object)((Object)sortType), (String)"sortType");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)commitCount, (String)"commitCount");
            long start2 = System.currentTimeMillis();
            SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogHistory.Computing.name());
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            SpanBuilder spanBuilder2 = spanBuilder;
            FileHistoryFilterer fileHistoryFilterer = FileHistoryFilterer.this;
            boolean $i$f$useWithScope = false;
            Span span$iv = $this$useWithScope$iv.startSpan();
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            Scope it$iv = (Scope)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)span$iv);
            Span $this$use$iv$iv = span$iv;
            boolean $i$f$use = false;
            Span scope2 = $this$use$iv$iv;
            boolean bl2 = false;
            boolean isInitial = Intrinsics.areEqual((Object)commitCount, (Object)CommitCountStage.INITIAL);
            scope2.setAttribute("filePath", this.filePath.toString());
            scope2.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getFILE_HISTORY_IS_INITIAL().getKey(), isInitial);
            scope2.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getVCS_NAME().getKey(), VcsLogRepoSizeCollector.getVcsKeySafe(this.vcsKey));
            IndexDataGetter indexDataGetter = fileHistoryFilterer.index.getDataGetter();
            if (indexDataGetter != null && fileHistoryFilterer.index.isIndexed(this.root) && dataPack.isFull() && Registry.is((String)"vcs.history.use.index")) {
                fileHistoryFilterer.cancelLastTask(false);
                visiblePack = this.filterWithIndex(indexDataGetter, dataPack, oldVisiblePack, sortType, filters, isInitial);
                LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for computing history for " + this.filePath + " with index");
                scope2.setAttribute(VcsTelemetrySpanAttribute.INSTANCE.getFILE_HISTORY_TYPE().getKey(), "index");
                if (this.checkNotEmpty(dataPack, visiblePack, true)) {
                    Pair pair = new Pair((Object)visiblePack, (Object)commitCount);
                    Pair pair2 = pair;
                    return pair2;
                }
            }
            visiblePack = this.filterWithVcs(dataPack, sortType, filters, commitCount);
            scope2.setAttribute("type", "history provider");
            LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start2) + " for computing history for " + this.filePath + " with history provider");
            this.checkNotEmpty(dataPack, visiblePack, false);
            Pair pair = new Pair((Object)visiblePack, (Object)commitCount);
            Pair pair3 = pair;
            return pair3;
            {
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (CancellationException e$iv$iv) {}
                {
                    throw e$iv$iv;
                }
            }
            catch (ProcessCanceledException e$iv$iv) {
                throw e$iv$iv;
            }
            catch (Throwable e$iv$iv) {
                $this$use$iv$iv.recordException(e$iv$iv);
                $this$use$iv$iv.setStatus(StatusCode.ERROR);
                throw e$iv$iv;
            }
            finally {
                $this$use$iv$iv.end();
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final boolean checkNotEmpty(DataPack dataPack, VisiblePack visiblePack, boolean withIndex) {
            if (!dataPack.isFull()) {
                LOG.debug("Data pack is not full while computing file history for " + this.filePath + "\nFound " + visiblePack.getVisibleGraph().getVisibleCommitCount() + " commits");
                return true;
            }
            if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
                LOG.warn("Empty file history from " + (withIndex ? "index" : "provider") + " for " + this.filePath);
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final VisiblePack filterWithVcs(DataPack dataPack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters, CommitCountStage commitCount) throws VcsException {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$mapTo$iv$iv;
            Pair pair;
            Object object;
            Object object2;
            boolean isFastStart = Intrinsics.areEqual((Object)commitCount, (Object)CommitCountStage.INITIAL);
            if (isFastStart) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                FileHistoryFilterer.this.cancelLastTask(false);
                Iterable iterable = this.fileHistoryHandler.getHistoryFast(this.root, this.filePath, this.hash, commitCount.getCount());
                FileHistoryFilterer fileHistoryFilterer = FileHistoryFilterer.this;
                boolean $i$f$map = false;
                void var10_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                object2 = $this$mapTo$iv$iv2.iterator();
                while (object2.hasNext()) {
                    void it;
                    Object item$iv$iv = object2.next();
                    VcsFileRevisionEx vcsFileRevisionEx = (VcsFileRevisionEx)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(fileHistoryFilterer.createCommitMetadataWithPath(fileHistoryFilterer.getVcsLogObjectsFactory(), (VcsFileRevisionEx)it, this.root));
                }
                pair = TuplesKt.to((Object)((List)destination$iv$iv), (Object)false);
            } else {
                pair = FileHistoryFilterer.this.createFileHistoryTask(this.fileHistoryHandler, this.root, this.filePath, this.hash, Intrinsics.areEqual((Object)commitCount, (Object)CommitCountStage.FIRST_STEP)).waitForRevisions();
            }
            Pair pair2 = pair;
            List revisions = (List)pair2.component1();
            boolean isDone = (Boolean)pair2.component2();
            if (revisions.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"EMPTY");
                return visiblePack;
            }
            if (dataPack.isFull() && !isFastStart) {
                void $this$associateTo$iv$iv2;
                Iterable $this$associate$iv2 = revisions;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
                object2 = $this$associate$iv2;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv2) {
                    Map map2 = destination$iv$iv;
                    CommitMetadataWithPath it = (CommitMetadataWithPath)element$iv$iv;
                    boolean bl = false;
                    Pair pair3 = new Pair((Object)it.commit, (Object)it.path);
                    map2.put(pair3.getFirst(), pair3.getSecond());
                }
                Map pathMap = destination$iv$iv;
                VisibleGraph visibleGraph = Companion.createVisibleGraph(dataPack, sortType, null, pathMap.keySet());
                VisiblePack $this$filterWithVcs_u24lambda_u243 = $i$f$associate = FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, visibleGraph, !isDone, filters), new FileHistory(pathMap, null, null, null, 14, null));
                boolean bl = false;
                $this$filterWithVcs_u24lambda_u243.putUserData(FileHistorySpeedSearch.Companion.getCOMMIT_METADATA$intellij_platform_vcs_log_impl(), this.toCommitMetadata(revisions));
                return $i$f$associate;
            }
            Iterable $this$map$iv = revisions;
            boolean $i$f$map = false;
            Iterable $this$filterWithVcs_u24lambda_u243 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CommitMetadataWithPath element$iv$iv = (CommitMetadataWithPath)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(GraphCommitImpl.createCommit(it.commit, CollectionsKt.emptyList(), it.metadata.getTimestamp()));
            }
            List commits2 = (List)destination$iv$iv;
            Map<VirtualFile, CompressedRefs> refs = this.getFilteredRefs(dataPack);
            DataPack dataPack2 = DataPack.build(commits2, refs, MapsKt.mapOf((Pair)TuplesKt.to((Object)this.root, FileHistoryFilterer.this.logProviders.get(this.root))), FileHistoryFilterer.this.storage, false);
            Intrinsics.checkNotNullExpressionValue((Object)dataPack2, (String)"build(...)");
            DataPack fakeDataPack = dataPack2;
            VisibleGraph visibleGraph = Companion.createVisibleGraph(fakeDataPack, sortType, null, null);
            destination$iv$iv = revisions;
            VisiblePack visiblePack = new VisiblePack(fakeDataPack, visibleGraph, !isDone, filters);
            object = FileHistoryPaths.INSTANCE;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void item$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map3 = destination$iv$iv2;
                CommitMetadataWithPath it = (CommitMetadataWithPath)element$iv$iv;
                boolean bl = false;
                Pair pair4 = new Pair((Object)it.commit, (Object)it.path);
                map3.put(pair4.getFirst(), pair4.getSecond());
            }
            Map map4 = destination$iv$iv2;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 14;
            MultiMap multiMap = null;
            Set set = null;
            Set set2 = null;
            Map map5 = map4;
            Object $this$filterWithVcs_u24lambda_u246 = object2 = ((FileHistoryPaths)object).withFileHistory(visiblePack, new FileHistory(map5, set2, set, multiMap, n, defaultConstructorMarker));
            boolean bl = false;
            ((VisiblePack)$this$filterWithVcs_u24lambda_u246).putUserData(VisiblePack.NO_GRAPH_INFORMATION, true);
            ((VisiblePack)$this$filterWithVcs_u24lambda_u246).putUserData(FileHistorySpeedSearch.Companion.getCOMMIT_METADATA$intellij_platform_vcs_log_impl(), this.toCommitMetadata(revisions));
            return object2;
        }

        private final Int2ObjectMap<VcsCommitMetadata> toCommitMetadata(List<CommitMetadataWithPath> revisions) {
            if (revisions.isEmpty()) {
                Int2ObjectMap int2ObjectMap = Int2ObjectMaps.emptyMap();
                Intrinsics.checkNotNullExpressionValue((Object)int2ObjectMap, (String)"emptyMap(...)");
                return int2ObjectMap;
            }
            Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap(revisions.size());
            for (CommitMetadataWithPath revision : revisions) {
                result2.put(revision.commit, (Object)revision.metadata);
            }
            return (Int2ObjectMap)result2;
        }

        private final Map<VirtualFile, CompressedRefs> getFilteredRefs(DataPack dataPack) {
            CompressedRefs compressedRefs = dataPack.getRefsModel().getAllRefsByRoot().get(this.root);
            if (compressedRefs == null) {
                compressedRefs = new CompressedRefs(SetsKt.emptySet(), FileHistoryFilterer.this.storage);
            }
            CompressedRefs compressedRefs2 = compressedRefs;
            return MapsKt.mapOf((Pair)new Pair((Object)this.root, (Object)compressedRefs2));
        }

        private final VisiblePack filterWithIndex(IndexDataGetter indexDataGetter, DataPack dataPack, VisiblePack oldVisiblePack, PermanentGraph.SortType sortType, VcsLogFilterCollection filters, boolean isInitial) {
            FileHistory oldFileHistory = FileHistoryPaths.INSTANCE.getFileHistory(oldVisiblePack);
            if (isInitial) {
                return this.filterWithIndex(indexDataGetter, dataPack, filters, sortType, oldFileHistory.getCommitToRename$intellij_platform_vcs_log_impl(), new FileHistory(MapsKt.emptyMap(), oldFileHistory.getProcessedAdditionsDeletions$intellij_platform_vcs_log_impl(), null, null, 12, null));
            }
            MultiMap<UnorderedPair<Integer>, Rename> renames2 = this.collectRenamesFromProvider(oldFileHistory);
            return this.filterWithIndex(indexDataGetter, dataPack, filters, sortType, (MultiMap<UnorderedPair<Integer>, Rename>)FileHistoryFiltererKt.access$union(renames2, oldFileHistory.getCommitToRename$intellij_platform_vcs_log_impl()), oldFileHistory);
        }

        private final VisiblePack filterWithIndex(IndexDataGetter indexDataGetter, DataPack dataPack, VcsLogFilterCollection filters, PermanentGraph.SortType sortType, MultiMap<UnorderedPair<Integer>, Rename> oldRenames, FileHistory oldFileHistory) {
            Integer n;
            VcsLogFiltererImpl vcsLogFiltererImpl = FileHistoryFilterer.this.vcsLogFilterer;
            RefsModel refsModel = dataPack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
            Set<Integer> matchingHeads = vcsLogFiltererImpl.getMatchingHeads(refsModel, (Collection<? extends VirtualFile>)SetsKt.setOf((Object)this.root), filters);
            FileHistoryData data2 = indexDataGetter.createFileHistoryData(this.filePath).build$intellij_platform_vcs_log_impl(oldRenames);
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"getPermanentGraph(...)");
            PermanentGraph<Integer> permanentGraph2 = permanentGraph;
            if (!(permanentGraph2 instanceof PermanentGraphImpl)) {
                VisibleGraph visibleGraph = Companion.createVisibleGraph(dataPack, sortType, matchingHeads, (Set)data2.getCommits());
                FileHistory fileHistory = new FileHistory(data2.buildPathsMap(), null, null, null, 14, null);
                return FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, visibleGraph, false, filters), fileHistory);
            }
            if (VcsLogFiltererImplKt.matchesNothing((Collection)matchingHeads) || data2.isEmpty()) {
                VisiblePack visiblePack = VisiblePack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"EMPTY");
                return visiblePack;
            }
            Hash hash2 = this.hash;
            if (hash2 == null) {
                hash2 = this.getHead(dataPack);
            }
            if (hash2 != null) {
                Hash hash3 = hash2;
                FileHistoryFilterer fileHistoryFilterer = FileHistoryFilterer.this;
                Hash it = hash3;
                boolean bl = false;
                n = fileHistoryFilterer.storage.getCommitIndex(it, this.root);
            } else {
                n = null;
            }
            Integer commit2 = n;
            FileHistoryBuilder historyBuilder = new FileHistoryBuilder(commit2, this.filePath, data2, oldFileHistory, null, FileHistoryBuilder.Companion.isRemoveTrivialMerges$intellij_platform_vcs_log_impl(), FileHistoryBuilder.Companion.isRefine$intellij_platform_vcs_log_impl(), 16, null);
            VisibleGraph<Integer> visibleGraph = ((PermanentGraphImpl)permanentGraph2).createVisibleGraph(sortType, matchingHeads, (Set)data2.getCommits(), historyBuilder);
            Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"createVisibleGraph(...)");
            VisibleGraph<Integer> visibleGraph2 = visibleGraph;
            FileHistory fileHistory = historyBuilder.getFileHistory();
            return FileHistoryPaths.INSTANCE.withFileHistory(new VisiblePack(dataPack, visibleGraph2, !((Collection)fileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl()).isEmpty(), filters), fileHistory);
        }

        /*
         * Exception decompiling
         */
        private final MultiMap<UnorderedPair<Integer>, Rename> collectRenamesFromProvider(FileHistory fileHistory) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private final Hash getHead(DataPack pack) {
            RefsModel refsModel = pack.getRefsModel();
            Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
            VcsRef vcsRef = DataPackUtilKt.findBranch(refsModel, "HEAD", this.root);
            return vcsRef != null ? vcsRef.getCommitHash() : null;
        }
    }
}

